/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.transform.stream;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import javax.xml.transform.Source;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StreamSource
implements Source {
    public static final String FEATURE = "http://javax.xml.transform.stream.StreamSource/feature";
    private String publicId;
    private String systemId;
    private InputStream inputStream;
    private Reader reader;

    public StreamSource() {
        this.Block$();
    }

    public StreamSource(File file) {
        this.Block$();
        this.setSystemId(file);
    }

    public StreamSource(InputStream inputStream) {
        this.Block$();
        this.inputStream = inputStream;
    }

    public StreamSource(InputStream inputStream, String string) {
        this.Block$();
        this.inputStream = inputStream;
        this.systemId = string;
    }

    public StreamSource(Reader reader) {
        this.Block$();
        this.reader = reader;
    }

    public StreamSource(Reader reader, String string) {
        this.Block$();
        this.reader = reader;
        this.systemId = string;
    }

    public StreamSource(String string) {
        this.Block$();
        this.systemId = string;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public String getPublicId() {
        return this.publicId;
    }

    public Reader getReader() {
        return this.reader;
    }

    @Override
    public String getSystemId() {
        return this.systemId;
    }

    public void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public void setPublicId(String string) {
        this.publicId = string;
    }

    public void setReader(Reader reader) {
        this.reader = reader;
    }

    public void setSystemId(File file) {
        try {
            this.systemId = StreamSource.fileToURL(file).toString();
            return;
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.getMessage());
        }
    }

    @Override
    public void setSystemId(String string) {
        this.systemId = string;
    }

    static String fileToURL(File file) throws IOException {
        String string = file.getAbsolutePath();
        if (File.separatorChar != '/') {
            string = string.replace(File.separatorChar, '/');
        }
        if (!string.startsWith("/")) {
            string = new StringBuffer().append("/").append(string).toString();
        }
        if (!string.endsWith("/") && file.isDirectory()) {
            string = new StringBuffer().append(string).append("/").toString();
        }
        return new StringBuffer().append("file:").append(string).toString();
    }

    private /* synthetic */ void Block$() {
        this.publicId = null;
        this.systemId = null;
        this.inputStream = null;
        this.reader = null;
    }
}

