/*
 * Decompiled with CFR 0.152.
 */
package kaffe.awt;

import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import kaffe.awt.FlavorConverter;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ExportTransferable
implements Transferable,
ClipboardOwner {
    protected Object data;
    protected DataFlavor[] flavors;
    protected FlavorConverter[] converters;

    protected ExportTransferable(Object object, DataFlavor[] dataFlavorArray, FlavorConverter[] flavorConverterArray) {
        this.data = object;
        this.flavors = dataFlavorArray;
        this.converters = flavorConverterArray;
    }

    public byte[] getNativeData(String string) {
        int n = 0;
        while (n < this.flavors.length) {
            if (this.flavors[n].isMimeTypeEqual(string) && this.converters[n] != null) {
                return this.converters[n].exportObject(this.data);
            }
            ++n;
        }
        return null;
    }

    @Override
    public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
        return null;
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return this.flavors;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        int n = 0;
        while (n < this.flavors.length) {
            if (this.flavors[n].equals(dataFlavor)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
    }

    public String toString() {
        return new StringBuffer().append(this.getClass().getName()).append(" [").append(this.data).append(']').toString();
    }
}

