/*
 * Decompiled with CFR 0.152.
 */
package kaffe.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;
import kaffe.io.ByteToCharDefault;
import kaffe.io.ByteToCharIconv;
import kaffe.io.ConverterAlias;
import kaffe.util.Assert;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ByteToCharConverter {
    private static String encodingRoot;
    private static String encodingDefault;
    private static Hashtable cache;
    private static Class noConverter;
    protected byte[] buf;
    protected int blen;

    void carry(byte[] byArray, int n, int n2) {
        int n3 = this.blen + n2;
        Assert.that(this.blen == 0);
        if (this.buf == null) {
            int n4 = n2 < 128 ? 128 : n2;
            this.buf = new byte[n4];
        } else if (n3 > this.buf.length) {
            int n5 = this.buf.length * 2;
            while (n5 < n3) {
                n5 *= 2;
            }
            byte[] byArray2 = new byte[n5];
            System.arraycopy(this.buf, 0, byArray2, 0, this.blen);
            this.buf = byArray2;
        }
        System.arraycopy(byArray, n, this.buf, this.blen, n2);
        this.blen = n3;
    }

    public abstract int convert(byte[] var1, int var2, int var3, char[] var4, int var5, int var6);

    public int flush(char[] cArray, int n, int n2) {
        if (this.blen == 0) {
            return 0;
        }
        int n3 = this.blen;
        this.blen = 0;
        return this.convert(this.buf, 0, n3, cArray, n, n2);
    }

    public boolean havePending() {
        return this.blen != 0;
    }

    public int withdraw(byte[] byArray, int n, int n2) {
        int n3;
        int n4 = n3 = n2 < this.blen ? n2 : this.blen;
        if (n3 == 0) {
            return 0;
        }
        System.arraycopy(this.buf, 0, byArray, 0, n3);
        if (n3 < this.blen) {
            System.arraycopy(this.buf, n3, this.buf, 0, this.blen - n3);
        }
        this.blen -= n3;
        return n3;
    }

    private static ByteToCharConverter getConverterInternal(String string) {
        Class clazz = (Class)cache.get(string);
        if (clazz == noConverter) {
            return null;
        }
        try {
            if (clazz == null) {
                String string2 = new StringBuffer().append(encodingRoot).append(".ByteToChar").append(ConverterAlias.alias(string)).toString();
                clazz = Class.forName(string2);
                cache.put(string, clazz);
            }
            return (ByteToCharConverter)clazz.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                String string3 = new StringBuffer().append(encodingRoot).append(".ByteToChar").append(ConverterAlias.alias(string)).toString();
                InputStream inputStream = ClassLoader.getSystemResourceAsStream(new StringBuffer().append(string3.replace('.', '/')).append(".ser").toString());
                if (inputStream != null) {
                    ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
                    Object object = objectInputStream.readObject();
                    objectInputStream.close();
                    return (ByteToCharConverter)object;
                }
            }
            catch (IOException iOException) {
            }
            catch (ClassNotFoundException classNotFoundException2) {}
        }
        catch (ClassCastException classCastException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InstantiationException instantiationException) {
            // empty catch block
        }
        cache.put(string, noConverter);
        return null;
    }

    public static ByteToCharConverter getConverter(String string) throws UnsupportedEncodingException {
        ByteToCharConverter byteToCharConverter = ByteToCharConverter.getConverterInternal(string);
        if (byteToCharConverter != null) {
            return byteToCharConverter;
        }
        return new ByteToCharIconv(string);
    }

    public static ByteToCharConverter getDefault() {
        try {
            return ByteToCharConverter.getConverter(encodingDefault);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new ByteToCharDefault();
        }
    }

    public abstract int getNumberOfChars(byte[] var1, int var2, int var3);

    static {
        cache = new Hashtable();
        noConverter = Class.forName("java.lang.Object");
        encodingRoot = "kaffe.io";
        encodingDefault = System.getProperty("file.encoding");
    }
}

