/*
 * Decompiled with CFR 0.152.
 */
package kaffe.io;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CircularBuffer {
    private char[] buffer;
    private int in;
    private int out;
    private boolean empty;
    private boolean closed;

    public CircularBuffer(int n) {
        this.Block$();
        this.buffer = new char[n];
    }

    public int available() {
        if (this.isFull()) {
            return this.buffer.length;
        }
        return (this.in - this.out) % this.buffer.length;
    }

    public int capacity() {
        return this.buffer.length - this.available();
    }

    public void close() {
        this.closed = true;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public boolean isEmpty() {
        return this.in == this.out && this.empty;
    }

    public boolean isFull() {
        return this.in == this.out && !this.empty;
    }

    public int read(char[] cArray, int n, int n2) {
        if (this.isClosed() && this.isEmpty()) {
            return -1;
        }
        int n3 = Math.min(this.buffer.length - this.out, Math.min(n2, this.available()));
        if (n3 > 0) {
            System.arraycopy(this.buffer, this.out, cArray, n, n3);
            this.out = (this.out + n3) % this.buffer.length;
            if (this.in == this.out) {
                this.empty = true;
            }
        }
        return n3;
    }

    public int write(char[] cArray, int n, int n2) {
        int n3 = Math.min(this.buffer.length - this.in, Math.min(n2, this.capacity()));
        if (n3 > 0) {
            System.arraycopy(cArray, n, this.buffer, this.in, n3);
            n += n3;
            n2 -= n3;
            this.in = (this.in + n3) % this.buffer.length;
            this.empty = false;
        }
        return n3;
    }

    private /* synthetic */ void Block$() {
        this.empty = true;
    }
}

