/*
 * Decompiled with CFR 0.152.
 */
package kaffe.lang;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.CodeSource;
import java.security.cert.Certificate;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import kaffe.lang.PackageHelper;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AppClassLoader
extends URLClassLoader {
    private static final AppClassLoader SINGLETON = new AppClassLoader();
    private Source sources;

    public static ClassLoader getSingleton() {
        return SINGLETON;
    }

    private String listPath() {
        String string = "";
        Source source = this.sources;
        while (source != null) {
            string = string.concat(new StringBuffer().append(source).append(File.pathSeparator).toString());
            source = source.next;
        }
        return string;
    }

    public void addSource(String string) {
        File file = new File(string);
        if (!file.exists()) {
            return;
        }
        Source source = null;
        try {
            source = file.isDirectory() ? new DirSource(file.getAbsoluteFile()) : new JarSource(file.getAbsoluteFile());
            if (this.sources == null) {
                this.sources = source;
                return;
            }
            Source source2 = this.sources;
            while (source2.next != null) {
                source2 = source2.next;
            }
            source2.next = source;
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    private AppClassLoader() {
        super(new URL[0]);
        StringTokenizer stringTokenizer = new StringTokenizer(System.getProperty("java.class.path"), File.pathSeparator);
        while (stringTokenizer.hasMoreTokens()) {
            this.addSource(stringTokenizer.nextToken().trim());
        }
    }

    @Override
    public Enumeration findResources(String string) throws IOException {
        Vector vector = new Vector();
        if (string.charAt(0) == '/') {
            string = string.substring(1);
        }
        Source source = this.sources;
        while (source != null) {
            source.findResources(vector, string);
            source = source.next;
        }
        return vector.elements();
    }

    @Override
    public URL findResource(String string) {
        Vector vector = new Vector();
        if (string.charAt(0) == '/') {
            string = string.substring(1);
        }
        Source source = this.sources;
        while (source != null && vector.size() == 0) {
            source.findResources(vector, string);
            source = source.next;
        }
        if (vector.size() > 0) {
            return (URL)vector.elementAt(0);
        }
        return null;
    }

    @Override
    protected Class findClass(String string) throws ClassNotFoundException {
        Class clazz = null;
        String string2 = new StringBuffer().append(string.replace('.', '/')).append(".class").toString();
        Source source = this.sources;
        while (source != null && clazz == null) {
            clazz = source.findClass(string, string2);
            source = source.next;
        }
        if (clazz == null) {
            throw new ClassNotFoundException(string);
        }
        return clazz;
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class Source {
        Source next;
        CodeSource codeSource;

        abstract Class findClass(String var1, String var2);

        abstract void findResources(Vector var1, String var2);

        private Source() {
        }
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class DirSource
    extends Source {
        File dir;

        DirSource(File file) throws IOException {
            this.dir = file.getCanonicalFile();
        }

        @Override
        Class findClass(String string, String string2) {
            File file = new File(this.dir, string2);
            if (!file.exists()) {
                return null;
            }
            try {
                Class clazz;
                String string3;
                int n = (int)file.length();
                FileInputStream fileInputStream = new FileInputStream(file);
                byte[] byArray = new byte[n];
                int n2 = 0;
                while (n2 < n) {
                    n2 += fileInputStream.read(byArray, n2, n - n2);
                }
                if (this.codeSource == null) {
                    try {
                        this.codeSource = new CodeSource(this.dir.toURL(), new Certificate[0]);
                    }
                    catch (MalformedURLException malformedURLException) {
                        // empty catch block
                    }
                }
                if (AppClassLoader.this.getPackage(string3 = PackageHelper.getPackageName(clazz = AppClassLoader.this.defineClass(string, byArray, 0, n, this.codeSource))) == null) {
                    AppClassLoader.this.definePackage(string3, null, null, null, null, null, null, null);
                }
                return clazz;
            }
            catch (Exception exception) {
                return null;
            }
        }

        @Override
        void findResources(Vector vector, String string) {
            File file = new File(this.dir, string);
            if (file.exists()) {
                try {
                    vector.add(file.toURL());
                    return;
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
        }

        public String toString() {
            return new StringBuffer().append("DirSource[dir=").append(this.dir).append("]").toString();
        }
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class JarSource
    extends Source {
        JarFile jar;
        String urlPrefix;
        File file;

        public JarSource(File file) throws IOException {
            File file2 = file.getCanonicalFile();
            this.jar = new JarFile(file2);
            this.urlPrefix = new StringBuffer().append("jar:file:").append(file2.getPath().replace(File.separatorChar, '/')).append("!/").toString();
            this.file = file2;
        }

        @Override
        Class findClass(String string, String string2) {
            ZipEntry zipEntry = this.jar.getEntry(string2);
            if (zipEntry == null) {
                return null;
            }
            int n = (int)zipEntry.getSize();
            byte[] byArray = new byte[n];
            try {
                Class clazz;
                String string3;
                InputStream inputStream = this.jar.getInputStream(zipEntry);
                int n2 = 0;
                while (n2 < n) {
                    n2 += inputStream.read(byArray, n2, n - n2);
                }
                if (this.codeSource == null) {
                    try {
                        this.codeSource = new CodeSource(this.file.toURL(), new Certificate[0]);
                    }
                    catch (MalformedURLException malformedURLException) {
                        // empty catch block
                    }
                }
                if (AppClassLoader.this.getPackage(string3 = PackageHelper.getPackageName(clazz = AppClassLoader.this.defineClass(string, byArray, 0, n, this.codeSource))) == null) {
                    Manifest manifest = this.jar.getManifest();
                    if (manifest == null) {
                        AppClassLoader.this.definePackage(string3, null, null, null, null, null, null, null);
                    } else {
                        Attributes attributes = this.jar.getManifest().getAttributes(string3);
                        if (attributes == null) {
                            attributes = this.jar.getManifest().getMainAttributes();
                        }
                        AppClassLoader.this.definePackage(string3, attributes.getValue(Attributes.Name.SPECIFICATION_TITLE), attributes.getValue(Attributes.Name.SPECIFICATION_VERSION), attributes.getValue(Attributes.Name.SPECIFICATION_VENDOR), attributes.getValue(Attributes.Name.IMPLEMENTATION_TITLE), attributes.getValue(Attributes.Name.IMPLEMENTATION_VERSION), attributes.getValue(Attributes.Name.IMPLEMENTATION_VENDOR), null);
                    }
                }
                return clazz;
            }
            catch (IOException iOException) {
                return null;
            }
        }

        @Override
        void findResources(Vector vector, String string) {
            ZipEntry zipEntry = this.jar.getEntry(string);
            if (zipEntry != null && !zipEntry.isDirectory()) {
                try {
                    vector.addElement(new URL(new StringBuffer().append(this.urlPrefix).append(zipEntry.getName()).toString()));
                    return;
                }
                catch (MalformedURLException malformedURLException) {
                    malformedURLException.printStackTrace();
                }
            }
        }

        public String toString() {
            return new StringBuffer().append("JarSource[file=").append(this.file).append("]").toString();
        }
    }
}

