/*
 * Decompiled with CFR 0.152.
 */
package kaffe.net.www.protocol.http;

import java.awt.Toolkit;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.URL;
import java.net.URLConnection;
import java.util.Vector;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpURLConnection
extends java.net.HttpURLConnection {
    private static String proxyHost;
    private static int proxyPort;
    private static boolean useProxy;
    private Vector headerFields;
    private Socket sock;
    private InputStream in;
    private DataOutputStream out;
    private File tmpFile;
    private OutputStream tmpOut;
    private boolean redir;

    public HttpURLConnection(URL uRL) {
        super(uRL);
        this.Block$();
        this.connected = false;
    }

    @Override
    public void connect() throws IOException {
        if (this.connected) {
            return;
        }
        this.connected = true;
        if (this.tmpOut != null) {
            this.tmpOut.close();
        }
        while (true) {
            Object object;
            String string;
            String string2;
            int n;
            this.responseCode = -1;
            this.responseMessage = null;
            this.headerFields = new Vector();
            if (useProxy) {
                n = proxyPort;
                string2 = proxyHost;
                if (n == -1) {
                    n = 80;
                }
                try {
                    this.sock = new Socket(string2, n);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (this.sock == null) {
                n = this.url.getPort();
                string2 = this.url.getHost();
                if (n == -1) {
                    n = 80;
                }
                this.sock = new Socket(string2, n);
            }
            this.in = new BufferedInputStream(this.sock.getInputStream());
            this.out = new DataOutputStream(this.sock.getOutputStream());
            if (useProxy) {
                string = this.url.toString();
            } else {
                string = this.url.getFile();
                if (string.equals("")) {
                    string = "/";
                }
            }
            if (this.doOutput) {
                this.method = "POST";
            }
            this.out.writeBytes(new StringBuffer().append(this.method).append(" ").append(string).append(" HTTP/1.0\r\n").toString());
            n = this.url.getPort();
            if (n == -1 || n == 80) {
                this.out.writeBytes(new StringBuffer().append("Host: ").append(this.url.getHost()).append("\r\n").toString());
            } else {
                this.out.writeBytes(new StringBuffer().append("Host: ").append(this.url.getHost()).append(":").append(n).append("\r\n").toString());
            }
            if (this.doOutput) {
                long l = this.tmpFile != null ? this.tmpFile.length() : 0L;
                this.out.writeBytes(new StringBuffer().append("Content-Length: ").append(l).append("\r\n").toString());
            }
            Object object2 = this.requestProperties.iterator();
            while (object2.hasNext()) {
                object = (String)object2.next();
                String string3 = (String)object2.next();
                this.out.writeBytes((String)object);
                if (string3 != null) {
                    this.out.writeBytes(new StringBuffer().append(": ").append(string3).toString());
                }
                this.out.writeBytes("\r\n");
            }
            if (!this.useCaches) {
                if (!this.requestProperties.contains("Cache-Control")) {
                    this.out.writeBytes("Cache-Control: no-cache\r\n");
                }
                if (!this.requestProperties.contains("Pragma")) {
                    this.out.writeBytes("Pragma: no-cache\r\n");
                }
            }
            this.out.writeBytes("\r\n");
            if (this.doOutput && this.tmpFile != null) {
                int n2;
                object2 = new FileInputStream(this.tmpFile);
                object = new byte[4096];
                while ((n2 = ((InputStream)object2).read((byte[])object, 0, ((Object)object).length)) >= 0) {
                    this.out.write((byte[])object, 0, n2);
                }
                ((InputStream)object2).close();
                this.tmpFile.delete();
            }
            this.out.flush();
            object2 = new DataInputStream(this.in);
            object = ((DataInputStream)object2).readLine();
            if (object == null) break;
            if (!((String)object).startsWith("HTTP/")) {
                return;
            }
            int n3 = ((String)object).indexOf(47);
            int n4 = ((String)object).indexOf(32);
            String string4 = ((String)object).substring(n3 + 1, n4);
            int n5 = ((String)object).indexOf(32, ++n4);
            try {
                this.responseCode = Integer.parseInt(((String)object).substring(n4, n5));
            }
            catch (NumberFormatException numberFormatException) {
                return;
            }
            this.responseMessage = ((String)object).substring(n5 + 1);
            this.headerFields.addElement(null);
            this.headerFields.addElement(object);
            while ((object = ((DataInputStream)object2).readLine()) != null && !((String)object).equals("")) {
                int n6 = ((String)object).indexOf(58);
                if (n6 <= 0) continue;
                String string5 = ((String)object).substring(0, n6);
                ++n6;
                while (Character.isWhitespace(((String)object).charAt(n6))) {
                    ++n6;
                }
                String string6 = ((String)object).substring(n6);
                this.setHeaderField(string5, string6);
            }
            String string7 = this.getHeaderField("Location");
            if (!this.redir || this.responseCode < 300 || this.responseCode > 305) break;
            if (string7 == null) {
                return;
            }
            this.url = new URL(string7);
        }
    }

    private void doConnect() throws IOException {
        if (!this.connected) {
            this.connect();
        }
    }

    private void tryConnect() {
        if (!this.connected) {
            try {
                this.connect();
                return;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public InputStream getInputStream() throws IOException {
        this.doConnect();
        return this.in;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        if (this.tmpOut != null) {
            return this.tmpOut;
        }
        this.tmpFile = File.createTempFile("POST", ".tmp");
        this.tmpFile.deleteOnExit();
        this.tmpOut = new FileOutputStream(this.tmpFile);
        return this.tmpOut;
    }

    @Override
    public String getHeaderField(String string) {
        this.tryConnect();
        int n = this.headerFields.size() - 2;
        while (n > 0) {
            if (((String)this.headerFields.elementAt(n)).equalsIgnoreCase(string)) {
                return (String)this.headerFields.elementAt(n + 1);
            }
            n -= 2;
        }
        return null;
    }

    @Override
    public String getHeaderField(int n) {
        this.tryConnect();
        if (n < 0 || n >= this.headerFields.size() >> 1) {
            return null;
        }
        return (String)this.headerFields.elementAt((n << 1) + 1);
    }

    @Override
    public String getHeaderFieldKey(int n) {
        this.tryConnect();
        if (n < 0 || n >= this.headerFields.size() >> 1) {
            return null;
        }
        return (String)this.headerFields.elementAt(n << 1);
    }

    protected void setHeaderField(String string, String string2) {
        int n = this.headerFields.size() - 2;
        while (n > 0) {
            if (((String)this.headerFields.elementAt(n)).equalsIgnoreCase(string)) {
                this.headerFields.setElementAt(string2, n + 1);
                return;
            }
            n -= 2;
        }
        this.headerFields.addElement(string);
        this.headerFields.addElement(string2);
    }

    @Override
    public Object getContent() throws IOException {
        this.tryConnect();
        String string = this.getContentType();
        if (string == null) {
            return this.in;
        }
        if (string.startsWith("image/")) {
            return Toolkit.getDefaultToolkit().getImage(this.url).getSource();
        }
        return this.in;
    }

    protected void setContentTypeFromName() {
        String string = URLConnection.getFileNameMap().getContentTypeFor(this.url.getFile());
        this.setHeaderField("Content-Type", string);
    }

    @Override
    public void disconnect() {
        try {
            this.sock.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.sock = null;
    }

    @Override
    public boolean usingProxy() {
        return useProxy;
    }

    public void setInstanceFollowRedirects(boolean bl) {
        this.redir = bl;
    }

    static {
        proxyPort = -1;
        proxyHost = System.getProperty("http.proxyHost");
        if (proxyHost != null && !proxyHost.equals("")) {
            useProxy = true;
            String string = System.getProperty("http.proxyPort");
            if (string != null) {
                try {
                    proxyPort = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    proxyPort = -1;
                }
            }
        }
    }

    private /* synthetic */ void Block$() {
        this.headerFields = new Vector(0);
        this.redir = java.net.HttpURLConnection.getFollowRedirects();
    }
}

