/*
 * Decompiled with CFR 0.152.
 */
package kaffe.rmi.server;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.Socket;
import java.rmi.RemoteException;
import kaffe.rmi.server.ProtocolConstants;
import kaffe.rmi.server.RMIObjectInputStream;
import kaffe.rmi.server.RMIObjectOutputStream;
import kaffe.rmi.server.UnicastConnectionManager;
import kaffe.rmi.server.UnicastServer;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnicastConnection
implements Runnable,
ProtocolConstants {
    UnicastConnectionManager manager;
    Socket sock;
    DataInputStream din;
    DataOutputStream dout;
    ObjectInputStream oin;
    ObjectOutputStream oout;

    UnicastConnection(UnicastConnectionManager unicastConnectionManager, Socket socket) {
        this.manager = unicastConnectionManager;
        this.sock = socket;
    }

    void acceptConnection() throws IOException {
        this.din = new DataInputStream(this.sock.getInputStream());
        this.dout = new DataOutputStream(this.sock.getOutputStream());
        int n = this.din.readInt();
        if (n != 1246907721) {
            throw new IOException("bad protocol header");
        }
        short s = this.din.readShort();
        if (s != 2) {
            throw new IOException("bad protocol version");
        }
        int n2 = this.din.readUnsignedByte();
        if (n2 != 76) {
            this.dout.writeByte(78);
            this.dout.writeUTF(this.manager.serverName);
            this.dout.writeInt(this.manager.serverPort);
            String string = this.din.readUTF();
            int n3 = this.din.readInt();
        }
    }

    void makeConnection(int n) throws IOException {
        this.dout = new DataOutputStream(this.sock.getOutputStream());
        this.din = new DataInputStream(this.sock.getInputStream());
        this.dout.writeInt(1246907721);
        this.dout.writeShort(2);
        this.dout.writeByte(n);
        this.dout.flush();
        if (n != 76) {
            int n2 = this.din.readUnsignedByte();
            if (n2 != 78) {
                throw new RemoteException("Unsupported protocol");
            }
            String string = this.din.readUTF();
            int n3 = this.din.readInt();
            this.dout.writeUTF(this.manager.serverName);
            this.dout.writeInt(this.manager.serverPort);
        }
    }

    DataInputStream getDataInputStream() throws IOException {
        return this.din;
    }

    DataOutputStream getDataOutputStream() throws IOException {
        return this.dout;
    }

    ObjectInputStream getObjectInputStream() throws IOException {
        if (this.oin == null) {
            this.oin = new RMIObjectInputStream(this.din, this.manager);
        }
        return this.oin;
    }

    ObjectOutputStream getObjectOutputStream() throws IOException {
        if (this.oout == null) {
            this.oout = new RMIObjectOutputStream(this.dout);
        }
        return this.oout;
    }

    void disconnect() {
        this.oin = null;
        this.oout = null;
        try {
            this.sock.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.din = null;
        this.dout = null;
        this.sock = null;
    }

    @Override
    public void run() {
        try {
            UnicastServer.dispatch(this);
            this.manager.discardConnection(this);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }
}

