/*
 * Decompiled with CFR 0.152.
 */
package kaffe.security;

import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Engine {
    private final Provider provider;
    private final String algorithm;
    private final Object engine;

    private Engine(Provider provider, String string, Object object) {
        this.provider = provider;
        this.algorithm = string;
        this.engine = object;
    }

    public Provider getProvider() {
        return this.provider;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public Object getEngine() {
        return this.engine;
    }

    public static Engine getCryptInstance(String string) throws NoSuchAlgorithmException {
        return Engine.getCryptInstance(string, null);
    }

    public static Engine getCryptInstance(String string, String string2) throws NoSuchAlgorithmException {
        Provider[] providerArray = Security.getProviders();
        int n = 0;
        while (n < providerArray.length) {
            try {
                return Engine.getCryptInstance(string, string2, providerArray[n]);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                ++n;
            }
        }
        if (string2 == null) {
            throw new NoSuchAlgorithmException();
        }
        throw new NoSuchAlgorithmException(string2);
    }

    public static Engine getCryptInstance(String string, String string2, String string3) throws NoSuchAlgorithmException, NoSuchProviderException {
        Provider provider = Security.getProvider(string3);
        if (provider == null) {
            throw new NoSuchProviderException(string3);
        }
        return Engine.getCryptInstance(string, string2, provider);
    }

    public static Engine getCryptInstance(String string, String string2, Provider provider) throws NoSuchAlgorithmException {
        String string3;
        if (string2 != null && (string3 = (String)provider.get(new StringBuffer().append("Alg.Alias.").append(string).append(".").append(string2).toString())) != null) {
            string2 = string3;
        }
        string3 = null;
        if (string2 != null) {
            string3 = (String)provider.get(new StringBuffer().append(string).append(".").append(string2).toString());
        } else {
            Iterator iterator = provider.entrySet().iterator();
            String string4 = new StringBuffer().append(string).append(".").toString();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                String string5 = (String)entry.getKey();
                if (!string5.startsWith(string4)) continue;
                string2 = string5.substring(string4.length());
                string3 = (String)entry.getValue();
                break;
            }
        }
        if (string3 == null) {
            throw new NoSuchAlgorithmException(new StringBuffer().append("\"").append(string2).append("\" not supported by provider").toString());
        }
        try {
            return new Engine(provider, string2, Class.forName(string3).newInstance());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoSuchAlgorithmException(new StringBuffer().append("class ").append(string3).append(" not found").toString());
        }
        catch (Exception exception) {
            throw new NoSuchAlgorithmException(new StringBuffer().append("can't instantiate class ").append(string3).append(": ").append(exception).toString());
        }
    }
}

