/*
 * Decompiled with CFR 0.152.
 */
package kaffe.security.provider;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandomSpi;
import java.util.Random;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SHA1PRNG
extends SecureRandomSpi {
    private static final int SEED_SIZE = 8;
    private static final int DATA_SIZE = 16;
    private MessageDigest md;
    private byte[] seed;
    private int seedPos;
    private byte[] data;
    private int dataPos;
    private long counter;

    public SHA1PRNG() {
        this.Block$();
        try {
            this.md = MessageDigest.getInstance("SHA-1");
            new Random().nextBytes(this.seed);
            byte[] byArray = this.md.digest(this.seed);
            System.arraycopy(byArray, 0, this.data, 0, 8);
            return;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            noSuchAlgorithmException.printStackTrace();
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    @Override
    protected void engineSetSeed(byte[] byArray) {
        try {
            int n = 0;
            while (n < byArray.length) {
                int n2 = this.seedPos++ % 8;
                this.seed[n2] = (byte)(this.seed[n2] ^ byArray[n]);
                ++n;
            }
            this.seedPos %= 8;
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    @Override
    protected void engineNextBytes(byte[] byArray) {
        if (byArray.length < 8 - this.dataPos) {
            System.arraycopy(this.data, this.dataPos, byArray, 0, byArray.length);
            this.dataPos += byArray.length;
            return;
        }
        int n = byArray.length;
        int n2 = 0;
        while (n2 < n) {
            int n3 = 8 - this.dataPos;
            int n4 = n - n2;
            if (n3 < n4) {
                n4 = n3;
            }
            System.arraycopy(this.data, this.dataPos, byArray, n2, n4);
            n2 += n4;
            this.dataPos += n4;
            if (this.dataPos < 8) continue;
            System.arraycopy(this.seed, 0, this.data, 0, 8);
            ++this.counter;
            this.data[8] = (byte)this.counter;
            this.data[9] = (byte)(this.counter >> 8);
            this.data[10] = (byte)(this.counter >> 16);
            this.data[11] = (byte)(this.counter >> 24);
            this.data[12] = (byte)(this.counter >> 32);
            this.data[13] = (byte)(this.counter >> 40);
            this.data[14] = (byte)(this.counter >> 48);
            this.data[15] = (byte)(this.counter >> 56);
            byte[] byArray2 = this.md.digest(this.data);
            System.arraycopy(byArray2, 0, this.data, 0, 8);
            this.dataPos = 0;
        }
    }

    @Override
    protected byte[] engineGenerateSeed(int n) {
        byte[] byArray = new byte[n];
        this.engineNextBytes(byArray);
        return byArray;
    }

    private /* synthetic */ void Block$() {
        this.seed = new byte[8];
        this.seedPos = 0;
        this.data = new byte[16];
        this.dataPos = 0;
        this.counter = 0L;
    }
}

