/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.lowlevel.alsa;

import java.util.Iterator;
import org.tritonus.lowlevel.alsa.Alsa;
import org.tritonus.lowlevel.alsa.AlsaSeqClientInfo;
import org.tritonus.lowlevel.alsa.AlsaSeqEvent;
import org.tritonus.lowlevel.alsa.AlsaSeqPortInfo;
import org.tritonus.lowlevel.alsa.AlsaSeqPortSubscribe;
import org.tritonus.lowlevel.alsa.AlsaSeqQueueInfo;
import org.tritonus.lowlevel.alsa.AlsaSeqQueueStatus;
import org.tritonus.lowlevel.alsa.AlsaSeqQueueTempo;
import org.tritonus.lowlevel.alsa.AlsaSeqQueueTimer;
import org.tritonus.lowlevel.alsa.AlsaSeqSystemInfo;
import org.tritonus.share.TDebug;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlsaSeq {
    public static final int SND_SEQ_EVENT_SYSTEM = 0;
    public static final int SND_SEQ_EVENT_RESULT = 1;
    public static final int SND_SEQ_EVENT_NOTE = 5;
    public static final int SND_SEQ_EVENT_NOTEON = 6;
    public static final int SND_SEQ_EVENT_NOTEOFF = 7;
    public static final int SND_SEQ_EVENT_KEYPRESS = 8;
    public static final int SND_SEQ_EVENT_CONTROLLER = 10;
    public static final int SND_SEQ_EVENT_PGMCHANGE = 11;
    public static final int SND_SEQ_EVENT_CHANPRESS = 12;
    public static final int SND_SEQ_EVENT_PITCHBEND = 13;
    public static final int SND_SEQ_EVENT_CONTROL14 = 14;
    public static final int SND_SEQ_EVENT_NONREGPARAM = 15;
    public static final int SND_SEQ_EVENT_REGPARAM = 16;
    public static final int SND_SEQ_EVENT_SONGPOS = 20;
    public static final int SND_SEQ_EVENT_SONGSEL = 21;
    public static final int SND_SEQ_EVENT_QFRAME = 22;
    public static final int SND_SEQ_EVENT_TIMESIGN = 23;
    public static final int SND_SEQ_EVENT_KEYSIGN = 24;
    public static final int SND_SEQ_EVENT_START = 30;
    public static final int SND_SEQ_EVENT_CONTINUE = 31;
    public static final int SND_SEQ_EVENT_STOP = 32;
    public static final int SND_SEQ_EVENT_SETPOS_TICK = 33;
    public static final int SND_SEQ_EVENT_SETPOS_TIME = 34;
    public static final int SND_SEQ_EVENT_TEMPO = 35;
    public static final int SND_SEQ_EVENT_CLOCK = 36;
    public static final int SND_SEQ_EVENT_TICK = 37;
    public static final int SND_SEQ_EVENT_SYNC = 38;
    public static final int SND_SEQ_EVENT_SYNC_POS = 39;
    public static final int SND_SEQ_EVENT_TUNE_REQUEST = 40;
    public static final int SND_SEQ_EVENT_RESET = 41;
    public static final int SND_SEQ_EVENT_SENSING = 42;
    public static final int SND_SEQ_EVENT_ECHO = 50;
    public static final int SND_SEQ_EVENT_OSS = 51;
    public static final int SND_SEQ_EVENT_CLIENT_START = 60;
    public static final int SND_SEQ_EVENT_CLIENT_EXIT = 61;
    public static final int SND_SEQ_EVENT_CLIENT_CHANGE = 62;
    public static final int SND_SEQ_EVENT_PORT_START = 63;
    public static final int SND_SEQ_EVENT_PORT_EXIT = 64;
    public static final int SND_SEQ_EVENT_PORT_CHANGE = 65;
    public static final int SND_SEQ_EVENT_PORT_SUBSCRIBED = 66;
    public static final int SND_SEQ_EVENT_PORT_UNSUBSCRIBED = 67;
    public static final int SND_SEQ_EVENT_SAMPLE = 70;
    public static final int SND_SEQ_EVENT_SAMPLE_CLUSTER = 71;
    public static final int SND_SEQ_EVENT_SAMPLE_START = 72;
    public static final int SND_SEQ_EVENT_SAMPLE_STOP = 73;
    public static final int SND_SEQ_EVENT_SAMPLE_FREQ = 74;
    public static final int SND_SEQ_EVENT_SAMPLE_VOLUME = 75;
    public static final int SND_SEQ_EVENT_SAMPLE_LOOP = 76;
    public static final int SND_SEQ_EVENT_SAMPLE_POSITION = 77;
    public static final int SND_SEQ_EVENT_SAMPLE_PRIVATE1 = 78;
    public static final int SND_SEQ_EVENT_USR0 = 90;
    public static final int SND_SEQ_EVENT_USR1 = 91;
    public static final int SND_SEQ_EVENT_USR2 = 92;
    public static final int SND_SEQ_EVENT_USR3 = 93;
    public static final int SND_SEQ_EVENT_USR4 = 94;
    public static final int SND_SEQ_EVENT_USR5 = 95;
    public static final int SND_SEQ_EVENT_USR6 = 96;
    public static final int SND_SEQ_EVENT_USR7 = 97;
    public static final int SND_SEQ_EVENT_USR8 = 98;
    public static final int SND_SEQ_EVENT_USR9 = 99;
    public static final int SND_SEQ_EVENT_INSTR_BEGIN = 100;
    public static final int SND_SEQ_EVENT_INSTR_END = 101;
    public static final int SND_SEQ_EVENT_INSTR_INFO = 102;
    public static final int SND_SEQ_EVENT_INSTR_INFO_RESULT = 103;
    public static final int SND_SEQ_EVENT_INSTR_FINFO = 104;
    public static final int SND_SEQ_EVENT_INSTR_FINFO_RESULT = 105;
    public static final int SND_SEQ_EVENT_INSTR_RESET = 106;
    public static final int SND_SEQ_EVENT_INSTR_STATUS = 107;
    public static final int SND_SEQ_EVENT_INSTR_STATUS_RESULT = 108;
    public static final int SND_SEQ_EVENT_INSTR_PUT = 109;
    public static final int SND_SEQ_EVENT_INSTR_GET = 110;
    public static final int SND_SEQ_EVENT_INSTR_GET_RESULT = 111;
    public static final int SND_SEQ_EVENT_INSTR_FREE = 112;
    public static final int SND_SEQ_EVENT_INSTR_LIST = 113;
    public static final int SND_SEQ_EVENT_INSTR_LIST_RESULT = 114;
    public static final int SND_SEQ_EVENT_INSTR_CLUSTER = 115;
    public static final int SND_SEQ_EVENT_INSTR_CLUSTER_GET = 116;
    public static final int SND_SEQ_EVENT_INSTR_CLUSTER_RESULT = 117;
    public static final int SND_SEQ_EVENT_INSTR_CHANGE = 118;
    public static final int SND_SEQ_EVENT_SYSEX = 130;
    public static final int SND_SEQ_EVENT_BOUNCE = 131;
    public static final int SND_SEQ_EVENT_USR_VAR0 = 135;
    public static final int SND_SEQ_EVENT_USR_VAR1 = 136;
    public static final int SND_SEQ_EVENT_USR_VAR2 = 137;
    public static final int SND_SEQ_EVENT_USR_VAR3 = 138;
    public static final int SND_SEQ_EVENT_USR_VAR4 = 139;
    public static final int SND_SEQ_EVENT_NONE = 255;
    public static final int SND_SEQ_ADDRESS_UNKNOWN = 253;
    public static final int SND_SEQ_ADDRESS_SUBSCRIBERS = 254;
    public static final int SND_SEQ_ADDRESS_BROADCAST = 255;
    public static final int SND_SEQ_QUEUE_DIRECT = 253;
    public static final int SND_SEQ_TIME_STAMP_TICK = 0;
    public static final int SND_SEQ_TIME_STAMP_REAL = 1;
    public static final int SND_SEQ_TIME_STAMP_MASK = 1;
    public static final int SND_SEQ_TIME_MODE_ABS = 0;
    public static final int SND_SEQ_TIME_MODE_REL = 2;
    public static final int SND_SEQ_TIME_MODE_MASK = 2;
    public static final int SND_SEQ_EVENT_LENGTH_FIXED = 0;
    public static final int SND_SEQ_EVENT_LENGTH_VARIABLE = 4;
    public static final int SND_SEQ_EVENT_LENGTH_VARUSR = 8;
    public static final int SND_SEQ_EVENT_LENGTH_VARIPC = 12;
    public static final int SND_SEQ_EVENT_LENGTH_MASK = 12;
    public static final int SND_SEQ_PRIORITY_NORMAL = 0;
    public static final int SND_SEQ_PRIORITY_HIGH = 16;
    public static final int SND_SEQ_PRIORITY_MASK = 16;
    public static final int SND_SEQ_CLIENT_SYSTEM = 0;
    public static final int SND_SEQ_CLIENT_DUMMY = 62;
    public static final int SND_SEQ_CLIENT_OSS = 63;
    public static final int SND_SEQ_FILTER_BROADCAST = 1;
    public static final int SND_SEQ_FILTER_MULTICAST = 2;
    public static final int SND_SEQ_FILTER_BOUNCE = 4;
    public static final long SND_SEQ_FILTER_USE_EVENT = 0x80000000L;
    public static final int SND_SEQ_REMOVE_INPUT = 1;
    public static final int SND_SEQ_REMOVE_OUTPUT = 2;
    public static final int SND_SEQ_REMOVE_DEST = 4;
    public static final int SND_SEQ_REMOVE_DEST_CHANNEL = 8;
    public static final int SND_SEQ_REMOVE_TIME_BEFORE = 16;
    public static final int SND_SEQ_REMOVE_TIME_AFTER = 32;
    public static final int SND_SEQ_REMOVE_TIME_TICK = 64;
    public static final int SND_SEQ_REMOVE_EVENT_TYPE = 128;
    public static final int SND_SEQ_REMOVE_IGNORE_OFF = 256;
    public static final int SND_SEQ_REMOVE_TAG_MATCH = 512;
    public static final int SND_SEQ_PORT_SYSTEM_TIMER = 0;
    public static final int SND_SEQ_PORT_SYSTEM_ANNOUNCE = 1;
    public static final int SND_SEQ_PORT_CAP_READ = 1;
    public static final int SND_SEQ_PORT_CAP_WRITE = 2;
    public static final int SND_SEQ_PORT_CAP_SYNC_READ = 4;
    public static final int SND_SEQ_PORT_CAP_SYNC_WRITE = 8;
    public static final int SND_SEQ_PORT_CAP_DUPLEX = 16;
    public static final int SND_SEQ_PORT_CAP_SUBS_READ = 32;
    public static final int SND_SEQ_PORT_CAP_SUBS_WRITE = 64;
    public static final int SND_SEQ_PORT_CAP_NO_EXPORT = 128;
    public static final int SND_SEQ_PORT_TYPE_SPECIFIC = 1;
    public static final int SND_SEQ_PORT_TYPE_MIDI_GENERIC = 2;
    public static final int SND_SEQ_PORT_TYPE_MIDI_GM = 4;
    public static final int SND_SEQ_PORT_TYPE_MIDI_GS = 8;
    public static final int SND_SEQ_PORT_TYPE_MIDI_XG = 16;
    public static final int SND_SEQ_PORT_TYPE_MIDI_MT32 = 32;
    public static final int SND_SEQ_PORT_TYPE_SYNTH = 1024;
    public static final int SND_SEQ_PORT_TYPE_DIRECT_SAMPLE = 2048;
    public static final int SND_SEQ_PORT_TYPE_SAMPLE = 4096;
    public static final int SND_SEQ_PORT_TYPE_APPLICATION = 0x100000;
    public static final String SND_SEQ_GROUP_SYSTEM = "system";
    public static final String SND_SEQ_GROUP_DEVICE = "device";
    public static final String SND_SEQ_GROUP_APPLICATION = "application";
    public static final int SND_SEQ_PORT_FLG_GIVEN_PORT = 1;
    public static final int SND_SEQ_QUEUE_FLG_SYNC = 1;
    public static final int SND_SEQ_QUEUE_FLG_SYNC_LOST = 1;
    public static final int SND_SEQ_SYNC_TICK = 128;
    public static final int SND_SEQ_SYNC_TIME = 64;
    public static final int SND_SEQ_SYNC_MODE = 192;
    public static final int SND_SEQ_SYNC_FMT_PRIVATE_CLOCK = 128;
    public static final int SND_SEQ_SYNC_FMT_PRIVATE_TIME = 64;
    public static final int SND_SEQ_SYNC_FMT_MIDI_CLOCK = 129;
    public static final int SND_SEQ_SYNC_FMT_MTC = 65;
    public static final int SND_SEQ_SYNC_FMT_DTL = 66;
    public static final int SND_SEQ_SYNC_FMT_SMPTE = 67;
    public static final int SND_SEQ_SYNC_FMT_MIDI_TICK = 68;
    public static final int SND_SEQ_SYNC_FPS_24 = 0;
    public static final int SND_SEQ_SYNC_FPS_25 = 1;
    public static final int SND_SEQ_SYNC_FPS_30_DP = 2;
    public static final int SND_SEQ_SYNC_FPS_30_NDP = 3;
    public static final int SND_SEQ_TIMER_ALSA = 0;
    public static final int SND_SEQ_TIMER_MIDI_CLOCK = 1;
    public static final int SND_SEQ_TIMER_MIDI_TICK = 2;
    public static final int SND_SEQ_QUERY_SUBS_READ = 0;
    public static final int SND_SEQ_QUERY_SUBS_WRITE = 1;
    public static final int SND_SEQ_INSTR_ATYPE_DATA = 0;
    public static final int SND_SEQ_INSTR_ATYPE_ALIAS = 1;
    public static final String SND_SEQ_INSTR_ID_DLS1 = "DLS1";
    public static final String SND_SEQ_INSTR_ID_DLS2 = "DLS2";
    public static final String SND_SEQ_INSTR_ID_SIMPLE = "Simple Wave";
    public static final String SND_SEQ_INSTR_ID_SOUNDFONT = "SoundFont";
    public static final String SND_SEQ_INSTR_ID_GUS_PATCH = "GUS Patch";
    public static final String SND_SEQ_INSTR_ID_INTERWAVE = "InterWave FFFF";
    public static final String SND_SEQ_INSTR_ID_OPL2_3 = "OPL2/3 FM";
    public static final String SND_SEQ_INSTR_ID_OPL4 = "OPL4";
    public static final int SND_SEQ_INSTR_TYPE0_DLS1 = 1;
    public static final int SND_SEQ_INSTR_TYPE0_DLS2 = 2;
    public static final int SND_SEQ_INSTR_TYPE1_SIMPLE = 1;
    public static final int SND_SEQ_INSTR_TYPE1_SOUNDFONT = 2;
    public static final int SND_SEQ_INSTR_TYPE1_GUS_PATCH = 4;
    public static final int SND_SEQ_INSTR_TYPE1_INTERWAVE = 8;
    public static final int SND_SEQ_INSTR_TYPE2_OPL2_3 = 1;
    public static final int SND_SEQ_INSTR_TYPE2_OPL4 = 2;
    public static final int SND_SEQ_INSTR_PUT_CMD_CREATE = 0;
    public static final int SND_SEQ_INSTR_PUT_CMD_REPLACE = 1;
    public static final int SND_SEQ_INSTR_PUT_CMD_MODIFY = 2;
    public static final int SND_SEQ_INSTR_PUT_CMD_ADD = 3;
    public static final int SND_SEQ_INSTR_PUT_CMD_REMOVE = 4;
    public static final int SND_SEQ_INSTR_GET_CMD_FULL = 0;
    public static final int SND_SEQ_INSTR_GET_CMD_PARTIAL = 1;
    public static final int SND_SEQ_INSTR_QUERY_FOLLOW_ALIAS = 1;
    public static final int SND_SEQ_INSTR_FREE_CMD_ALL = 0;
    public static final int SND_SEQ_INSTR_FREE_CMD_PRIVATE = 1;
    public static final int SND_SEQ_INSTR_FREE_CMD_CLUSTER = 2;
    public static final int SND_SEQ_INSTR_FREE_CMD_SINGLE = 3;
    private long m_lNativeHandle;

    public AlsaSeq() {
        int n;
        if (TDebug.TraceAlsaSeq) {
            TDebug.out("AlsaSeq.<init>(): begin");
        }
        if ((n = this.open()) < 0) {
            throw new RuntimeException("open failed");
        }
        if (TDebug.TraceAlsaSeq) {
            TDebug.out("AlsaSeq.<init>(): end");
        }
    }

    public AlsaSeq(String string) {
        this();
        if (TDebug.TraceAlsaSeq) {
            TDebug.out("AlsaSeq.<init>(String): begin");
        }
        this.setClientName(string);
        if (TDebug.TraceAlsaSeq) {
            TDebug.out("AlsaSeq.<init>(String): end");
        }
    }

    private native int open();

    public native void close();

    public native String getName();

    public native int getType();

    public native int setNonblock(boolean var1);

    public native int getClientId();

    public native int getOutputBufferSize();

    public native int getInputBufferSize();

    public native int setOutputBufferSize(int var1);

    public native int setInputBufferSize(int var1);

    public native int getSystemInfo(AlsaSeqSystemInfo var1);

    public int getClientInfo(AlsaSeqClientInfo alsaSeqClientInfo) {
        return this.getClientInfo(-1, alsaSeqClientInfo);
    }

    public native int getClientInfo(int var1, AlsaSeqClientInfo var2);

    public native int setClientInfo(AlsaSeqClientInfo var1);

    public native int getNextClient(int var1, int[] var2);

    public void setClientName(String string) {
        if (TDebug.TraceAlsaSeq) {
            TDebug.out("AlsaSeq.setClientName(): begin");
        }
        AlsaSeqClientInfo alsaSeqClientInfo = new AlsaSeqClientInfo();
        this.getClientInfo(alsaSeqClientInfo);
        alsaSeqClientInfo.setName(string);
        this.setClientInfo(alsaSeqClientInfo);
        if (TDebug.TraceAlsaSeq) {
            TDebug.out("AlsaSeq.setClientName(): end");
        }
    }

    public int getPortInfo(int n, AlsaSeqPortInfo alsaSeqPortInfo) {
        return this.getPortInfo(-1, n, alsaSeqPortInfo);
    }

    public native int getPortInfo(int var1, int var2, AlsaSeqPortInfo var3);

    public native int getNextPort(int var1, int var2, int[] var3);

    public native int createPort(String var1, int var2, int var3, int var4, int var5, int var6, int var7);

    public native int allocQueue();

    public native int freeQueue(int var1);

    public native boolean getQueueUsage(int var1);

    public native int setQueueUsage(int var1, boolean var2);

    public native int getQueueInfo(int var1, AlsaSeqQueueInfo var2);

    public native int setQueueInfo(int var1, AlsaSeqQueueInfo var2);

    public native int getQueueStatus(int var1, AlsaSeqQueueStatus var2);

    public native int getQueueTempo(int var1, AlsaSeqQueueTempo var2);

    public native int setQueueTempo(int var1, AlsaSeqQueueTempo var2);

    public native int getQueueTimer(int var1, AlsaSeqQueueTimer var2);

    public native int setQueueTimer(int var1, AlsaSeqQueueTimer var2);

    public native int getPortSubscription(AlsaSeqPortSubscribe var1);

    public native int subscribePort(AlsaSeqPortSubscribe var1);

    public native int unsubscribePort(AlsaSeqPortSubscribe var1);

    private static native void setTrace(boolean var0);

    public Iterator getClientInfos() {
        return new ClientInfoIterator();
    }

    public Iterator getPortInfos(int n) {
        return new PortInfoIterator(n);
    }

    public native int eventOutput(AlsaSeqEvent var1);

    public native int eventOutputBuffer(AlsaSeqEvent var1);

    public native int eventOutputDirect(AlsaSeqEvent var1);

    public native int eventInput(AlsaSeqEvent var1);

    public native int eventInputPending(int var1);

    public native int drainOutput();

    public native int eventOutputPending();

    public native int extractOutput(AlsaSeqEvent var1);

    public native int dropOutput();

    public native int dropOutputBuffer();

    public native int dropInput();

    public native int dropInputBuffer();

    static {
        Alsa.loadNativeLibrary();
        if (TDebug.TraceAlsaSeqNative) {
            AlsaSeq.setTrace(true);
        }
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ClientInfoIterator
    implements Iterator {
        private int m_nClient = -1;
        private AlsaSeqClientInfo m_clientInfo = this.createNextClientInfo();

        @Override
        public boolean hasNext() {
            return this.m_clientInfo != null;
        }

        @Override
        public Object next() {
            AlsaSeqClientInfo alsaSeqClientInfo = this.m_clientInfo;
            this.m_clientInfo = this.createNextClientInfo();
            return alsaSeqClientInfo;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private AlsaSeqClientInfo createNextClientInfo() {
            if (TDebug.TraceAlsaSeq) {
                TDebug.out("AlsaSeq.createNextClientInfo(): begin");
            }
            AlsaSeqClientInfo alsaSeqClientInfo = null;
            int[] nArray = new int[1];
            int n = AlsaSeq.this.getNextClient(this.m_nClient, nArray);
            if (TDebug.TraceAlsaSeq) {
                TDebug.out(new StringBuffer().append("succ: ").append(n).toString());
            }
            if (n == 0) {
                this.m_nClient = nArray[0];
                alsaSeqClientInfo = new AlsaSeqClientInfo();
                AlsaSeq.this.getClientInfo(this.m_nClient, alsaSeqClientInfo);
            }
            if (TDebug.TraceAlsaSeq) {
                TDebug.out("AlsaSeq.createNextClientInfo(): end");
            }
            return alsaSeqClientInfo;
        }
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PortInfoIterator
    implements Iterator {
        private int m_nClient;
        private int m_nPort;
        private AlsaSeqPortInfo m_portInfo;

        public PortInfoIterator(int n) {
            if (TDebug.TraceAlsaSeq) {
                TDebug.out("AlsaSeq.PortInfoIterator.<init>(): begin");
            }
            this.m_nClient = n;
            this.m_nPort = -1;
            this.m_portInfo = this.createNextPortInfo();
            if (TDebug.TraceAlsaSeq) {
                TDebug.out("AlsaSeq.PortInfoIterator.<init>(): end");
            }
        }

        @Override
        public boolean hasNext() {
            return this.m_portInfo != null;
        }

        @Override
        public Object next() {
            AlsaSeqPortInfo alsaSeqPortInfo = this.m_portInfo;
            this.m_portInfo = this.createNextPortInfo();
            return alsaSeqPortInfo;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private AlsaSeqPortInfo createNextPortInfo() {
            if (TDebug.TraceAlsaSeq) {
                TDebug.out("AlsaSeq.PortInfoIterator.createNextPortInfo(): begin");
            }
            AlsaSeqPortInfo alsaSeqPortInfo = null;
            int[] nArray = new int[2];
            int n = AlsaSeq.this.getNextPort(this.m_nClient, this.m_nPort, nArray);
            if (TDebug.TraceAlsaSeq) {
                TDebug.out(new StringBuffer().append("AlsaSeq.PortInfoIterator.createNextPortInfo(): getNextPort() returns: ").append(n).toString());
            }
            if (n == 0) {
                this.m_nPort = nArray[1];
                alsaSeqPortInfo = new AlsaSeqPortInfo();
                AlsaSeq.this.getPortInfo(this.m_nClient, this.m_nPort, alsaSeqPortInfo);
            }
            if (TDebug.TraceAlsaSeq) {
                TDebug.out("AlsaSeq.PortInfoIterator.createNextPortInfo(): end");
            }
            return alsaSeqPortInfo;
        }
    }
}

