/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.sampled.convert;

import java.util.HashSet;
import java.util.Set;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import org.tritonus.share.sampled.convert.TFormatConversionProvider;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SmartFormatConversionProvider
extends TFormatConversionProvider {
    private Set m_blockedThreads = new HashSet();

    @Override
    public AudioFormat.Encoding[] getSourceEncodings() {
        return TFormatConversionProvider.EMPTY_ENCODING_ARRAY;
    }

    @Override
    public AudioFormat.Encoding[] getTargetEncodings() {
        return TFormatConversionProvider.EMPTY_ENCODING_ARRAY;
    }

    @Override
    public AudioFormat.Encoding[] getTargetEncodings(AudioFormat audioFormat) {
        return null;
    }

    @Override
    public boolean isConversionSupported(AudioFormat.Encoding encoding, AudioFormat audioFormat) {
        return false;
    }

    @Override
    public AudioFormat[] getTargetFormats(AudioFormat.Encoding encoding, AudioFormat audioFormat) {
        return null;
    }

    @Override
    public boolean isConversionSupported(AudioFormat audioFormat, AudioFormat audioFormat2) {
        if (this.isCurrentThreadBlocked()) {
            return false;
        }
        AudioFormat[] audioFormatArray = this.getIntermediateFormats(audioFormat2, audioFormat);
        return audioFormatArray != null;
    }

    @Override
    public AudioInputStream getAudioInputStream(AudioFormat.Encoding encoding, AudioInputStream audioInputStream) {
        return null;
    }

    @Override
    public AudioInputStream getAudioInputStream(AudioFormat audioFormat, AudioInputStream audioInputStream) {
        return null;
    }

    private AudioFormat[] getIntermediateFormats(AudioFormat audioFormat, AudioFormat audioFormat2) {
        AudioFormat.Encoding encoding = audioFormat.getEncoding();
        AudioFormat.Encoding encoding2 = audioFormat2.getEncoding();
        this.blockCurrentThread();
        boolean bl = AudioSystem.isConversionSupported(audioFormat2, audioFormat);
        this.unblockCurrentThread();
        if (bl) {
            return TFormatConversionProvider.EMPTY_FORMAT_ARRAY;
        }
        if (SmartFormatConversionProvider.isPCM(encoding) && SmartFormatConversionProvider.isPCM(encoding2)) {
            return null;
        }
        if (!SmartFormatConversionProvider.isPCM(encoding)) {
            AudioFormat audioFormat3 = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, audioFormat.getSampleRate(), audioFormat.getSampleSizeInBits(), audioFormat.getChannels(), -1, audioFormat.getSampleRate(), true);
            this.blockCurrentThread();
            AudioFormat[] audioFormatArray = this.getIntermediateFormats(audioFormat, audioFormat3);
            this.unblockCurrentThread();
            AudioFormat[] audioFormatArray2 = this.getIntermediateFormats(audioFormat3, audioFormat2);
            if (audioFormatArray != null && audioFormatArray2 != null) {
                AudioFormat[] audioFormatArray3 = new AudioFormat[audioFormatArray.length + 1 + audioFormatArray2.length];
                System.arraycopy(audioFormatArray, 0, audioFormatArray3, 0, audioFormatArray.length);
                audioFormatArray3[audioFormatArray.length] = audioFormat3;
                System.arraycopy(audioFormatArray2, 0, audioFormatArray3, audioFormatArray.length, audioFormatArray2.length);
                return audioFormatArray3;
            }
            return null;
        }
        if (!SmartFormatConversionProvider.isPCM(encoding2)) {
            AudioFormat audioFormat4 = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, audioFormat2.getSampleRate(), audioFormat2.getSampleSizeInBits(), audioFormat2.getChannels(), -1, audioFormat2.getSampleRate(), true);
            AudioFormat[] audioFormatArray = this.getIntermediateFormats(audioFormat, audioFormat4);
            this.blockCurrentThread();
            AudioFormat[] audioFormatArray4 = this.getIntermediateFormats(audioFormat4, audioFormat2);
            this.unblockCurrentThread();
            if (audioFormatArray != null && audioFormatArray4 != null) {
                AudioFormat[] audioFormatArray5 = new AudioFormat[audioFormatArray.length + 1 + audioFormatArray4.length];
                System.arraycopy(audioFormatArray, 0, audioFormatArray5, 0, audioFormatArray.length);
                audioFormatArray5[audioFormatArray.length] = audioFormat4;
                System.arraycopy(audioFormatArray4, 0, audioFormatArray5, audioFormatArray.length, audioFormatArray4.length);
                return audioFormatArray5;
            }
            return null;
        }
        return null;
    }

    private static boolean isPCM(AudioFormat.Encoding encoding) {
        return encoding.equals(AudioFormat.Encoding.PCM_SIGNED) || encoding.equals(AudioFormat.Encoding.PCM_SIGNED);
    }

    private static boolean isSignedPCM(AudioFormat.Encoding encoding) {
        return encoding.equals(AudioFormat.Encoding.PCM_SIGNED);
    }

    private boolean isCurrentThreadBlocked() {
        return this.m_blockedThreads.contains(Thread.currentThread());
    }

    private void blockCurrentThread() {
        this.m_blockedThreads.add(Thread.currentThread());
    }

    private void unblockCurrentThread() {
        this.m_blockedThreads.remove(Thread.currentThread());
    }
}

