/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.sampled.file;

import java.io.IOException;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import org.tritonus.sampled.file.AiffTool;
import org.tritonus.share.TDebug;
import org.tritonus.share.sampled.file.TAudioOutputStream;
import org.tritonus.share.sampled.file.TDataOutputStream;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AiffAudioOutputStream
extends TAudioOutputStream {
    private static final int LENGTH_NOT_KNOWN = -1;
    private AudioFileFormat.Type m_FileType;

    public AiffAudioOutputStream(AudioFormat audioFormat, AudioFileFormat.Type type, long l, TDataOutputStream tDataOutputStream) {
        super(audioFormat, l, tDataOutputStream, l == -1L && tDataOutputStream.supportsSeek());
        if (l != -1L && l > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("AIFF files cannot be larger than 2GB.");
        }
        this.m_FileType = type;
        if (!audioFormat.getEncoding().equals(AudioFormat.Encoding.PCM_SIGNED) && !audioFormat.getEncoding().equals(AudioFormat.Encoding.PCM_UNSIGNED)) {
            this.m_FileType = AudioFileFormat.Type.AIFC;
        }
    }

    @Override
    protected void writeHeader() throws IOException {
        if (TDebug.TraceAudioOutputStream) {
            TDebug.out("AiffAudioOutputStream.writeHeader(): called.");
        }
        AudioFormat audioFormat = this.getFormat();
        boolean bl = this.m_FileType.equals(AudioFileFormat.Type.AIFC);
        long l = this.getLength();
        TDataOutputStream tDataOutputStream = this.getDataOutputStream();
        int n = 18;
        int n2 = AiffTool.getFormatCode(audioFormat);
        if (bl) {
            n += 6;
        }
        int n3 = 12 + n + 8;
        if (bl) {
            n3 += 12;
        }
        if (l != -1L && l + (long)n3 > Integer.MAX_VALUE) {
            l = Integer.MAX_VALUE - (long)n3;
        }
        long l2 = l != -1L ? l + l % 2L + 8L : -1L;
        tDataOutputStream.writeInt(1179603533);
        tDataOutputStream.writeInt(l != -1L ? (int)(l2 + (long)n3) : -1);
        if (bl) {
            tDataOutputStream.writeInt(1095321155);
            tDataOutputStream.writeInt(1180058962);
            tDataOutputStream.writeInt(4);
            tDataOutputStream.writeInt(-1568648896);
        } else {
            tDataOutputStream.writeInt(1095321158);
        }
        tDataOutputStream.writeInt(1129270605);
        tDataOutputStream.writeInt(n);
        tDataOutputStream.writeShort((short)audioFormat.getChannels());
        tDataOutputStream.writeInt(l != -1L ? (int)(l / (long)audioFormat.getFrameSize()) : -1);
        if (n2 == 1970037111) {
            tDataOutputStream.writeShort(16);
        } else {
            tDataOutputStream.writeShort((short)audioFormat.getSampleSizeInBits());
        }
        this.writeIeeeExtended(tDataOutputStream, audioFormat.getSampleRate());
        if (bl) {
            tDataOutputStream.writeInt(n2);
            tDataOutputStream.writeShort(0);
        }
        tDataOutputStream.writeInt(1397968452);
        tDataOutputStream.writeInt(l != -1L ? (int)(l + 8L) : -1);
        tDataOutputStream.writeInt(0);
        tDataOutputStream.writeInt(0);
    }

    @Override
    protected void patchHeader() throws IOException {
        TDataOutputStream tDataOutputStream = this.getDataOutputStream();
        tDataOutputStream.seek(0L);
        this.setLengthFromCalculatedLength();
        this.writeHeader();
    }

    @Override
    public void close() throws IOException {
        long l = this.getCalculatedLength();
        if (l % 2L == 1L) {
            if (TDebug.TraceAudioOutputStream) {
                TDebug.out("AiffOutputStream.close(): adding padding byte");
            }
            TDataOutputStream tDataOutputStream = this.getDataOutputStream();
            tDataOutputStream.writeByte(0);
        }
        super.close();
    }

    public void writeIeeeExtended(TDataOutputStream tDataOutputStream, float f) throws IOException {
        int n = (int)f;
        int n2 = 0;
        while (n != 0 && (n & Integer.MIN_VALUE) == 0) {
            n2 = (short)(n2 + 1);
            n <<= 1;
        }
        tDataOutputStream.writeShort(16414 - n2);
        tDataOutputStream.writeInt(n);
        tDataOutputStream.writeInt(0);
    }
}

