/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.sampled.file;

import java.io.IOException;
import javax.sound.sampled.AudioFormat;
import org.tritonus.sampled.file.AuTool;
import org.tritonus.share.TDebug;
import org.tritonus.share.sampled.file.TAudioOutputStream;
import org.tritonus.share.sampled.file.TDataOutputStream;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuAudioOutputStream
extends TAudioOutputStream {
    private static String description = "Created by Tritonus";

    protected static void writeText(TDataOutputStream tDataOutputStream, String string) throws IOException {
        if (string.length() > 0) {
            tDataOutputStream.writeBytes(string);
            tDataOutputStream.writeByte(0);
            if (string.length() % 2 == 0) {
                tDataOutputStream.writeByte(0);
            }
        }
    }

    protected static int getTextLength(String string) {
        if (string.length() == 0) {
            return 0;
        }
        return string.length() + 2 & 0xFFFFFFFE;
    }

    public AuAudioOutputStream(AudioFormat audioFormat, long l, TDataOutputStream tDataOutputStream) {
        super(audioFormat, l > Integer.MAX_VALUE ? -1L : l, tDataOutputStream, l == -1L && tDataOutputStream.supportsSeek());
    }

    @Override
    protected void writeHeader() throws IOException {
        if (TDebug.TraceAudioOutputStream) {
            TDebug.out("AuAudioOutputStream.writeHeader(): called.");
        }
        AudioFormat audioFormat = this.getFormat();
        long l = this.getLength();
        TDataOutputStream tDataOutputStream = this.getDataOutputStream();
        if (TDebug.TraceAudioOutputStream) {
            TDebug.out(new StringBuffer().append("AuAudioOutputStream.writeHeader(): AudioFormat: ").append(audioFormat).toString());
            TDebug.out(new StringBuffer().append("AuAudioOutputStream.writeHeader(): length: ").append(l).toString());
        }
        tDataOutputStream.writeInt(779316836);
        tDataOutputStream.writeInt(24 + AuAudioOutputStream.getTextLength(description));
        tDataOutputStream.writeInt(l != -1L ? (int)l : -1);
        tDataOutputStream.writeInt(AuTool.getFormatCode(audioFormat));
        tDataOutputStream.writeInt((int)audioFormat.getSampleRate());
        tDataOutputStream.writeInt(audioFormat.getChannels());
        AuAudioOutputStream.writeText(tDataOutputStream, description);
    }

    @Override
    protected void patchHeader() throws IOException {
        TDataOutputStream tDataOutputStream = this.getDataOutputStream();
        tDataOutputStream.seek(0L);
        this.setLengthFromCalculatedLength();
        this.writeHeader();
    }
}

