/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.sampled.mixer.alsa;

import java.util.Collection;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.LineUnavailableException;
import org.tritonus.lowlevel.alsa.Alsa;
import org.tritonus.lowlevel.alsa.AlsaPcm;
import org.tritonus.lowlevel.alsa.AlsaPcmHWParams;
import org.tritonus.lowlevel.alsa.AlsaPcmSWParams;
import org.tritonus.sampled.mixer.alsa.AlsaDataLineMixer;
import org.tritonus.sampled.mixer.alsa.AlsaUtils;
import org.tritonus.share.TDebug;
import org.tritonus.share.sampled.mixer.TBaseDataLine;
import org.tritonus.share.sampled.mixer.TMixer;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AlsaBaseDataLine
extends TBaseDataLine {
    private AlsaPcm m_alsaPcm;
    private boolean m_bSwapBytes;
    private int m_nBytesPerSample;

    public AlsaBaseDataLine(AlsaDataLineMixer alsaDataLineMixer, DataLine.Info info) throws LineUnavailableException {
        super((TMixer)alsaDataLineMixer, info);
        if (TDebug.TraceSourceDataLine) {
            TDebug.out("AlsaBaseDataLine.<init>(): begin");
        }
        if (TDebug.TraceSourceDataLine) {
            TDebug.out("AlsaBaseDataLine.<init>(): end");
        }
    }

    public AlsaBaseDataLine(AlsaDataLineMixer alsaDataLineMixer, DataLine.Info info, Collection collection) throws LineUnavailableException {
        super((TMixer)alsaDataLineMixer, info);
        if (TDebug.TraceSourceDataLine) {
            TDebug.out("AlsaBaseDataLine.<init>(): begin");
        }
        if (TDebug.TraceSourceDataLine) {
            TDebug.out("AlsaBaseDataLine.<init>(): end");
        }
    }

    protected AlsaDataLineMixer getAlsaDataLineMixer() {
        return (AlsaDataLineMixer)this.getMixer();
    }

    protected AlsaPcm getAlsaPcm() {
        return this.m_alsaPcm;
    }

    protected abstract int getAlsaStreamType();

    protected boolean getSwapBytes() {
        return this.m_bSwapBytes;
    }

    protected int getBytesPerSample() {
        return this.m_nBytesPerSample;
    }

    @Override
    protected void openImpl() throws LineUnavailableException {
        int n;
        if (TDebug.TraceSourceDataLine) {
            TDebug.out("AlsaBaseDataLine.openImpl(): begin");
        }
        this.checkOpen();
        AudioFormat audioFormat = this.getFormat();
        if (TDebug.TraceSourceDataLine) {
            TDebug.out(new StringBuffer().append("AlsaBaseDataLine.openImpl(): input format: ").append(audioFormat).toString());
        }
        boolean bl = false;
        AudioFormat.Encoding encoding = audioFormat.getEncoding();
        boolean bl2 = audioFormat.isBigEndian();
        this.m_bSwapBytes = false;
        if (audioFormat.getSampleSizeInBits() == 16 && bl2 != bl) {
            this.m_bSwapBytes = true;
            bl2 = bl;
        } else if (audioFormat.getSampleSizeInBits() == 8 && encoding.equals(AudioFormat.Encoding.PCM_SIGNED)) {
            this.m_bSwapBytes = true;
            encoding = AudioFormat.Encoding.PCM_UNSIGNED;
        }
        if (this.getSwapBytes()) {
            audioFormat = new AudioFormat(encoding, audioFormat.getSampleRate(), audioFormat.getSampleSizeInBits(), audioFormat.getChannels(), audioFormat.getFrameSize(), audioFormat.getFrameRate(), bl2);
            if (TDebug.TraceSourceDataLine) {
                TDebug.out(new StringBuffer().append("AlsaBaseDataLine.openImpl(): output format: ").append(audioFormat).toString());
            }
            this.m_nBytesPerSample = audioFormat.getFrameSize() / audioFormat.getChannels();
        }
        int n2 = AlsaUtils.getAlsaFormat(audioFormat);
        if (TDebug.TraceSourceDataLine) {
            TDebug.out(new StringBuffer().append("AlsaBaseDataLine.openImpl(): ALSA output format: ").append(n2).toString());
        }
        if (n2 == -1) {
            throw new IllegalArgumentException("unsupported format");
        }
        try {
            this.m_alsaPcm = new AlsaPcm(this.getAlsaDataLineMixer().getPcmName(), this.getAlsaStreamType(), 0);
        }
        catch (Exception exception) {
            if (TDebug.TraceAllExceptions) {
                TDebug.out(exception);
            }
            throw new LineUnavailableException();
        }
        AlsaPcmHWParams alsaPcmHWParams = new AlsaPcmHWParams();
        int n3 = this.m_alsaPcm.getAnyHWParams(alsaPcmHWParams);
        if (n3 != 0) {
            TDebug.out(new StringBuffer().append("AlsaBaseDataLine.openImpl(): getAnyHWParams(): ").append(Alsa.getStringError(n3)).toString());
            throw new LineUnavailableException(Alsa.getStringError(n3));
        }
        n3 = this.m_alsaPcm.setHWParamsAccess(alsaPcmHWParams, 3);
        if (n3 != 0) {
            TDebug.out(new StringBuffer().append("AlsaBaseDataLine.openImpl(): setHWParamsFormat(): ").append(Alsa.getStringError(n3)).toString());
            throw new LineUnavailableException(Alsa.getStringError(n3));
        }
        n3 = this.m_alsaPcm.setHWParamsFormat(alsaPcmHWParams, n2);
        if (n3 != 0) {
            TDebug.out(new StringBuffer().append("AlsaBaseDataLine.openImpl(): setHWParamsFormat(): ").append(Alsa.getStringError(n3)).toString());
            throw new LineUnavailableException(Alsa.getStringError(n3));
        }
        n3 = this.m_alsaPcm.setHWParamsChannels(alsaPcmHWParams, audioFormat.getChannels());
        if (n3 != 0) {
            TDebug.out(new StringBuffer().append("AlsaBaseDataLine.openImpl(): setHWParamsChannels(): ").append(Alsa.getStringError(n3)).toString());
            throw new LineUnavailableException(Alsa.getStringError(n3));
        }
        n3 = this.m_alsaPcm.setHWParamsRateNear(alsaPcmHWParams, (int)audioFormat.getSampleRate());
        if (n3 < 0) {
            TDebug.out(new StringBuffer().append("AlsaBaseDataLine.openImpl(): setHWParamsRateNear(): ").append(Alsa.getStringError(n3)).toString());
            throw new LineUnavailableException(Alsa.getStringError(n3));
        }
        int n4 = n3 = this.m_alsaPcm.setHWParamsBufferTimeNear(alsaPcmHWParams, 500000);
        if (n3 < 0) {
            TDebug.out(new StringBuffer().append("AlsaBaseDataLine.openImpl(): setHWParamsBufferTimeNear(): ").append(Alsa.getStringError(n3)).toString());
            throw new LineUnavailableException(Alsa.getStringError(n3));
        }
        n3 = this.m_alsaPcm.setHWParamsPeriodTimeNear(alsaPcmHWParams, n4 / 4);
        if (n3 < 0) {
            TDebug.out(new StringBuffer().append("AlsaBaseDataLine.openImpl(): setHWParamsPeriodTimeNear(): ").append(Alsa.getStringError(n3)).toString());
            throw new LineUnavailableException(Alsa.getStringError(n3));
        }
        n3 = this.m_alsaPcm.setHWParams(alsaPcmHWParams);
        if (n3 < 0) {
            TDebug.out(new StringBuffer().append("AlsaBaseDataLine.openImpl(): setHWParams(): ").append(Alsa.getStringError(n3)).toString());
            throw new LineUnavailableException(Alsa.getStringError(n3));
        }
        int n5 = alsaPcmHWParams.getPeriodSize(null);
        if (n5 == (n = alsaPcmHWParams.getBufferSize())) {
            throw new LineUnavailableException("period size is equal to buffer size");
        }
        AlsaPcmSWParams alsaPcmSWParams = new AlsaPcmSWParams();
        n3 = this.m_alsaPcm.getSWParams(alsaPcmSWParams);
        if (n3 != 0) {
            TDebug.out(new StringBuffer().append("AlsaBaseDataLine.openImpl(): getSWParams(): ").append(Alsa.getStringError(n3)).toString());
            throw new LineUnavailableException(Alsa.getStringError(n3));
        }
        n3 = this.m_alsaPcm.setSWParamsSleepMin(alsaPcmSWParams, 0);
        if (n3 != 0) {
            TDebug.out(new StringBuffer().append("AlsaBaseDataLine.openImpl(): setSWParamsSleepMin(): ").append(Alsa.getStringError(n3)).toString());
            throw new LineUnavailableException(Alsa.getStringError(n3));
        }
        n3 = this.m_alsaPcm.setSWParamsXrunMode(alsaPcmSWParams, 0);
        if (n3 != 0) {
            TDebug.out(new StringBuffer().append("AlsaBaseDataLine.openImpl(): setSWParamsXrunMode(): ").append(Alsa.getStringError(n3)).toString());
            throw new LineUnavailableException(Alsa.getStringError(n3));
        }
        n3 = this.m_alsaPcm.setSWParamsAvailMin(alsaPcmSWParams, n5);
        if (n3 != 0) {
            TDebug.out(new StringBuffer().append("AlsaBaseDataLine.openImpl(): setSWParamsAvailMin(): ").append(Alsa.getStringError(n3)).toString());
            throw new LineUnavailableException(Alsa.getStringError(n3));
        }
        long l = (long)((double)audioFormat.getFrameRate() * 1.0 / 1000000.0);
        n3 = this.m_alsaPcm.setSWParamsStartThreshold(alsaPcmSWParams, (int)l);
        if (n3 != 0) {
            TDebug.out(new StringBuffer().append("AlsaBaseDataLine.openImpl(): setSWParamsStartThreshold(): ").append(Alsa.getStringError(n3)).toString());
            throw new LineUnavailableException(Alsa.getStringError(n3));
        }
        long l2 = (long)((double)n + (double)audioFormat.getFrameRate() * 0.0 / 1000000.0);
        n3 = this.m_alsaPcm.setSWParamsStopThreshold(alsaPcmSWParams, (int)l2);
        if (n3 != 0) {
            TDebug.out(new StringBuffer().append("AlsaBaseDataLine.openImpl(): setSWParamsStopThreshold(): ").append(Alsa.getStringError(n3)).toString());
            throw new LineUnavailableException(Alsa.getStringError(n3));
        }
        n3 = this.m_alsaPcm.setSWParams(alsaPcmSWParams);
        if (n3 != 0) {
            TDebug.out(new StringBuffer().append("AlsaBaseDataLine.openImpl(): setSWParams(): ").append(Alsa.getStringError(n3)).toString());
            throw new LineUnavailableException(Alsa.getStringError(n3));
        }
        if (TDebug.TraceSourceDataLine) {
            TDebug.out("AlsaBaseDataLine.openImpl(): end");
        }
    }

    @Override
    protected void closeImpl() {
        if (TDebug.TraceSourceDataLine) {
            TDebug.out("AlsaBaseDataLine.closeImpl(): begin");
        }
        this.m_alsaPcm.close();
        if (TDebug.TraceSourceDataLine) {
            TDebug.out("AlsaBaseDataLine.closeImpl(): end");
        }
    }

    @Override
    protected void stopImpl() {
        int n;
        if (TDebug.TraceSourceDataLine) {
            TDebug.out("AlsaBaseDataLine.stopImpl(): called");
        }
        if ((n = 0) != 0) {
            TDebug.out(new StringBuffer().append("flushChannel: ").append(Alsa.getStringError(n)).toString());
        }
    }

    @Override
    public int available() {
        return -1;
    }

    @Override
    public void drain() {
    }

    @Override
    public void flush() {
    }

    private void setGain(float f) {
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class AlsaBaseDataLineGainControl
    extends FloatControl {
        private final float MAX_GAIN;
        private final float MIN_GAIN;
        private final int GAIN_INCREMENTS;

        AlsaBaseDataLineGainControl() {
            super(FloatControl.Type.VOLUME, -96.0f, 24.0f, 0.01f, 0, 0.0f, "dB", "-96.0", "", "+24.0");
            this.Block$();
        }

        @Override
        public void setValue(float f) {
            if ((double)Math.abs((f = Math.max(Math.min(f, this.getMaximum()), this.getMinimum())) - this.getValue()) > 1.0E9) {
                super.setValue(f);
                AlsaBaseDataLine.this.setGain(this.getValue());
            }
        }

        private /* synthetic */ void Block$() {
            this.MAX_GAIN = 90.0f;
            this.MIN_GAIN = -96.0f;
            this.GAIN_INCREMENTS = 1000;
        }
    }
}

