/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.sampled.mixer.alsa;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.TargetDataLine;
import org.tritonus.lowlevel.alsa.Alsa;
import org.tritonus.lowlevel.alsa.AlsaPcm;
import org.tritonus.lowlevel.alsa.AlsaPcmHWParams;
import org.tritonus.lowlevel.alsa.AlsaPcmHWParamsFormatMask;
import org.tritonus.sampled.mixer.alsa.AlsaSourceDataLine;
import org.tritonus.sampled.mixer.alsa.AlsaTargetDataLine;
import org.tritonus.sampled.mixer.alsa.AlsaUtils;
import org.tritonus.share.GlobalInfo;
import org.tritonus.share.TDebug;
import org.tritonus.share.TSettings;
import org.tritonus.share.sampled.mixer.TMixer;
import org.tritonus.share.sampled.mixer.TMixerInfo;
import org.tritonus.share.sampled.mixer.TSoftClip;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlsaDataLineMixer
extends TMixer {
    private static final AudioFormat[] EMPTY_AUDIOFORMAT_ARRAY = new AudioFormat[0];
    private static final int CHANNELS_LIMIT = 32;
    private static final int DEFAULT_BUFFER_SIZE = 32768;
    private String m_strPcmName;

    public static String getDeviceNamePrefix() {
        if (TSettings.AlsaUsePlughw) {
            return "plughw";
        }
        return "hw";
    }

    public static String getPcmName(int n) {
        String string = new StringBuffer().append(AlsaDataLineMixer.getDeviceNamePrefix()).append(":").append(n).toString();
        return string;
    }

    public AlsaDataLineMixer() {
        this(0);
    }

    public AlsaDataLineMixer(int n) {
        this(AlsaDataLineMixer.getPcmName(n));
    }

    public AlsaDataLineMixer(String string) {
        super(new TMixerInfo(new StringBuffer().append("Alsa DataLine Mixer (").append(string).append(")").toString(), GlobalInfo.getVendor(), new StringBuffer().append("Mixer for the Advanced Linux Sound Architecture (card ").append(string).append(")").toString(), GlobalInfo.getVersion()), new Line.Info(Class.forName("javax.sound.sampled.Mixer")));
        if (TDebug.TraceMixer) {
            TDebug.out("AlsaDataLineMixer.<init>(String): begin.");
        }
        this.m_strPcmName = string;
        List list = this.getSupportedFormats(0);
        List list2 = this.getSupportedFormats(1);
        ArrayList arrayList = new ArrayList();
        DataLine.Info info = new DataLine.Info(Class.forName("javax.sound.sampled.SourceDataLine"), (AudioFormat[])list.toArray(EMPTY_AUDIOFORMAT_ARRAY), -1, -1);
        arrayList.add(info);
        ArrayList arrayList2 = new ArrayList();
        DataLine.Info info2 = new DataLine.Info(Class.forName("javax.sound.sampled.TargetDataLine"), (AudioFormat[])list2.toArray(EMPTY_AUDIOFORMAT_ARRAY), -1, -1);
        arrayList2.add(info2);
        this.setSupportInformation(list, list2, arrayList, arrayList2);
        if (TDebug.TraceMixer) {
            TDebug.out("AlsaDataLineMixer.<init>(String): end.");
        }
    }

    public String getPcmName() {
        return this.m_strPcmName;
    }

    @Override
    public void open() {
        if (TDebug.TraceMixer) {
            TDebug.out("AlsaDataLineMixer.open(): begin");
        }
        if (TDebug.TraceMixer) {
            TDebug.out("AlsaDataLineMixer.open(): end");
        }
    }

    @Override
    public void close() {
        if (TDebug.TraceMixer) {
            TDebug.out("AlsaDataLineMixer.close(): begin");
        }
        if (TDebug.TraceMixer) {
            TDebug.out("AlsaDataLineMixer.close(): end");
        }
    }

    @Override
    public int getMaxLines(Line.Info info) {
        if (TDebug.TraceMixer) {
            TDebug.out("AlsaDataLineMixer.getMaxLines(): begin");
        }
        if (TDebug.TraceMixer) {
            TDebug.out("AlsaDataLineMixer.getMaxLines(): end");
        }
        return 0;
    }

    @Override
    protected SourceDataLine getSourceDataLine(AudioFormat audioFormat, int n) throws LineUnavailableException {
        if (TDebug.TraceMixer) {
            TDebug.out("AlsaDataLineMixer.getSourceDataLine(): begin");
        }
        if (TDebug.TraceMixer) {
            TDebug.out(new StringBuffer().append("AlsaDataLineMixer.getSourceDataLine(): format: ").append(audioFormat).toString());
            TDebug.out(new StringBuffer().append("AlsaDataLineMixer.getSourceDataLine(): buffer size: ").append(n).toString());
        }
        if (n < 1) {
            n = 32768;
        }
        AlsaSourceDataLine alsaSourceDataLine = new AlsaSourceDataLine(this, audioFormat, n);
        if (TDebug.TraceMixer) {
            TDebug.out(new StringBuffer().append("AlsaDataLineMixer.getSourceDataLine(): returning: ").append(alsaSourceDataLine).toString());
        }
        if (TDebug.TraceMixer) {
            TDebug.out("AlsaDataLineMixer.getSourceDataLine(): end");
        }
        return alsaSourceDataLine;
    }

    @Override
    protected TargetDataLine getTargetDataLine(AudioFormat audioFormat, int n) throws LineUnavailableException {
        if (TDebug.TraceMixer) {
            TDebug.out("AlsaDataLineMixer.getTargetDataLine(): begin");
        }
        int n2 = n * audioFormat.getFrameSize();
        AlsaTargetDataLine alsaTargetDataLine = new AlsaTargetDataLine(this, audioFormat, n2);
        if (TDebug.TraceMixer) {
            TDebug.out(new StringBuffer().append("AlsaDataLineMixer.getTargetDataLine(): returning: ").append(alsaTargetDataLine).toString());
        }
        if (TDebug.TraceMixer) {
            TDebug.out("AlsaDataLineMixer.getTargetDataLine(): end");
        }
        return alsaTargetDataLine;
    }

    @Override
    protected Clip getClip(AudioFormat audioFormat) throws LineUnavailableException {
        if (TDebug.TraceMixer) {
            TDebug.out("AlsaDataLineMixer.getClip(): begin");
        }
        TSoftClip tSoftClip = new TSoftClip((Mixer)this, audioFormat);
        if (TDebug.TraceMixer) {
            TDebug.out("AlsaDataLineMixer.getClip(): end");
        }
        return tSoftClip;
    }

    private List getSupportedFormats(int n) {
        if (TDebug.TraceMixer) {
            TDebug.out("AlsaDataLineMixer.getSupportedFormats(): begin");
        }
        if (TDebug.TraceMixer) {
            TDebug.out(new StringBuffer().append("AlsaDataLineMixer.getSupportedFormats(): direction: ").append(n).toString());
        }
        ArrayList arrayList = new ArrayList();
        AlsaPcm alsaPcm = null;
        try {
            alsaPcm = new AlsaPcm(this.getPcmName(), n, 0);
        }
        catch (Exception exception) {
            if (TDebug.TraceAllExceptions) {
                TDebug.out(exception);
            }
            throw new RuntimeException("cannot open pcm");
        }
        AlsaPcmHWParams alsaPcmHWParams = new AlsaPcmHWParams();
        int n2 = alsaPcm.getAnyHWParams(alsaPcmHWParams);
        if (n2 != 0) {
            TDebug.out(new StringBuffer().append("AlsaDataLineMixer.getSupportedFormats(): getAnyHWParams(): ").append(Alsa.getStringError(n2)).toString());
            throw new RuntimeException(Alsa.getStringError(n2));
        }
        AlsaPcmHWParamsFormatMask alsaPcmHWParamsFormatMask = new AlsaPcmHWParamsFormatMask();
        int n3 = alsaPcmHWParams.getChannelsMin();
        if (TDebug.TraceMixer) {
            TDebug.out(new StringBuffer().append("AlsaDataLineMixer.getSupportedFormats(): min channels: ").append(n3).toString());
        }
        int n4 = alsaPcmHWParams.getChannelsMax();
        n4 = Math.min(n4, 32);
        if (TDebug.TraceMixer) {
            TDebug.out(new StringBuffer().append("AlsaDataLineMixer.getSupportedFormats(): max channels: ").append(n4).toString());
        }
        alsaPcmHWParams.getFormatMask(alsaPcmHWParamsFormatMask);
        int n5 = 0;
        while (n5 < 32) {
            if (TDebug.TraceMixer) {
                TDebug.out(new StringBuffer().append("AlsaDataLineMixer.getSupportedFormats(): checking ALSA format index: ").append(n5).toString());
            }
            if (alsaPcmHWParamsFormatMask.test(n5)) {
                if (TDebug.TraceMixer) {
                    TDebug.out("AlsaDataLineMixer.getSupportedFormats(): ...supported");
                }
                AudioFormat audioFormat = AlsaUtils.getAlsaFormat(n5);
                if (TDebug.TraceMixer) {
                    TDebug.out(new StringBuffer().append("AlsaDataLineMixer.getSupportedFormats(): adding AudioFormat: ").append(audioFormat).toString());
                }
                AlsaDataLineMixer.addChanneledAudioFormats(arrayList, audioFormat, n3, n4);
            } else if (TDebug.TraceMixer) {
                TDebug.out("AlsaDataLineMixer.getSupportedFormats(): ...not supported");
            }
            ++n5;
        }
        alsaPcm.close();
        if (TDebug.TraceMixer) {
            TDebug.out("AlsaDataLineMixer.getSupportedFormats(): end");
        }
        return arrayList;
    }

    private static void addChanneledAudioFormats(Collection collection, AudioFormat audioFormat, int n, int n2) {
        if (TDebug.TraceMixer) {
            TDebug.out("AlsaDataLineMixer.addChanneledAudioFormats(): begin");
        }
        int n3 = n;
        while (n3 <= n2) {
            AudioFormat audioFormat2 = AlsaDataLineMixer.getChanneledAudioFormat(audioFormat, n3);
            if (TDebug.TraceMixer) {
                TDebug.out(new StringBuffer().append("AlsaDataLineMixer.addChanneledAudioFormats(): adding AudioFormat: ").append(audioFormat2).toString());
            }
            collection.add(audioFormat2);
            ++n3;
        }
        if (TDebug.TraceMixer) {
            TDebug.out("AlsaDataLineMixer.addChanneledAudioFormats(): end");
        }
    }

    private static AudioFormat getChanneledAudioFormat(AudioFormat audioFormat, int n) {
        AudioFormat audioFormat2 = new AudioFormat(audioFormat.getEncoding(), audioFormat.getSampleRate(), audioFormat.getSampleSizeInBits(), n, audioFormat.getSampleSizeInBits() / 8 * n, audioFormat.getFrameRate(), audioFormat.isBigEndian());
        return audioFormat2;
    }
}

