/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.sampled.mixer.alsa;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sound.sampled.BooleanControl;
import javax.sound.sampled.CompoundControl;
import javax.sound.sampled.Control;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Port;
import org.tritonus.lowlevel.alsa.AlsaMixer;
import org.tritonus.lowlevel.alsa.AlsaMixerElement;
import org.tritonus.share.GlobalInfo;
import org.tritonus.share.TDebug;
import org.tritonus.share.sampled.mixer.TCompoundControlType;
import org.tritonus.share.sampled.mixer.TMixer;
import org.tritonus.share.sampled.mixer.TMixerInfo;
import org.tritonus.share.sampled.mixer.TPort;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlsaPortMixer
extends TMixer {
    public static final int DIRECTION_NONE = -1;
    public static final int DIRECTION_COMMON = 0;
    public static final int DIRECTION_PLAYBACK = 1;
    public static final int DIRECTION_CAPTURE = 2;
    private List m_mixerElements;
    private Map m_portMap;
    private Map m_mixerElementMap;

    public AlsaPortMixer(int n) {
        this(new StringBuffer().append("hw:").append(n).toString());
    }

    public AlsaPortMixer(String string) {
        AlsaMixer alsaMixer;
        block12: {
            super(new TMixerInfo(new StringBuffer().append("Alsa Port Mixer (").append(string).append(")").toString(), GlobalInfo.getVendor(), new StringBuffer().append("System Mixer for the Advanced Linux Sound System (card ").append(string).append(")").toString(), GlobalInfo.getVersion()), new Line.Info(Class.forName("javax.sound.sampled.Mixer")));
            if (TDebug.TraceMixer) {
                TDebug.out("AlsaPortMixer.<init>: begin");
            }
            this.m_mixerElements = new ArrayList();
            this.m_mixerElementMap = new HashMap();
            this.m_portMap = new HashMap();
            alsaMixer = null;
            try {
                alsaMixer = new AlsaMixer(string);
                if (TDebug.TraceMixer) {
                    TDebug.out("AlsaPortMixer.<init>: successfully created AlsaMixer instance");
                }
            }
            catch (Exception exception) {
                if (!TDebug.TraceMixer && !TDebug.TraceAllExceptions) break block12;
                TDebug.out(exception);
            }
        }
        int n = 150;
        int[] nArray = null;
        String[] stringArray = null;
        int n2 = 0;
        while ((n2 = alsaMixer.readControlList(nArray = new int[n], stringArray = new String[n])) < 0) {
            if (TDebug.TraceMixer) {
                TDebug.out(new StringBuffer().append("AlsaPortMixer.<init>: increating array size for AlsaMixer.readControlList(): now ").append(n * 2).toString());
            }
            n *= 2;
        }
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        int n3 = 0;
        while (n3 < n2) {
            AlsaMixerElement alsaMixerElement;
            if (TDebug.TraceMixer) {
                TDebug.out(new StringBuffer().append("AlsaPortMixer.<init>(): control ").append(n3).append(": ").append(nArray[n3]).append(" ").append(stringArray[n3]).toString());
            }
            if ((alsaMixerElement = new AlsaMixerElement(alsaMixer, nArray[n3], stringArray[n3])).isActive()) {
                Port.Info info;
                this.m_mixerElements.add(alsaMixerElement);
                if (AlsaPortMixer.hasPlaybackChannels(alsaMixerElement)) {
                    info = new Port.Info(Class.forName("javax.sound.sampled.Port"), alsaMixerElement.getName(), true);
                    arrayList.add(info);
                    this.m_mixerElementMap.put(info, alsaMixerElement);
                }
                if (AlsaPortMixer.hasCaptureChannels(alsaMixerElement)) {
                    info = new Port.Info(Class.forName("javax.sound.sampled.Port"), alsaMixerElement.getName(), false);
                    arrayList2.add(info);
                    this.m_mixerElementMap.put(info, alsaMixerElement);
                }
            }
            ++n3;
        }
        this.setSupportInformation(new ArrayList(), new ArrayList(), arrayList, arrayList2);
        if (TDebug.TraceMixer) {
            TDebug.out("AlsaPortMixer.<init>: end.");
        }
    }

    private static boolean hasPlaybackChannels(AlsaMixerElement alsaMixerElement) {
        boolean bl = false;
        int n = 0;
        while (n <= 5) {
            bl |= alsaMixerElement.hasPlaybackChannel(n);
            ++n;
        }
        return bl;
    }

    private static boolean hasCaptureChannels(AlsaMixerElement alsaMixerElement) {
        boolean bl = false;
        int n = 0;
        while (n <= 5) {
            bl |= alsaMixerElement.hasCaptureChannel(n);
            ++n;
        }
        return bl;
    }

    @Override
    public void open() {
        if (TDebug.TraceMixer) {
            TDebug.out("AlsaPortMixer.open(): begin");
        }
        if (TDebug.TraceMixer) {
            TDebug.out("AlsaPortMixer.open(): end");
        }
    }

    @Override
    public void close() {
        if (TDebug.TraceMixer) {
            TDebug.out("AlsaPortMixer.close(): begin");
        }
        if (TDebug.TraceMixer) {
            TDebug.out("AlsaPortMixer.close(): end");
        }
    }

    @Override
    public int getMaxLines(Line.Info info) {
        return 0;
    }

    @Override
    protected Port getPort(Port.Info info) throws LineUnavailableException {
        if (TDebug.TraceMixer) {
            TDebug.out("AlsaPortMixer.getPort(): begin");
        }
        Port port = null;
        port = (Port)this.m_portMap.get(info);
        if (port == null) {
            port = this.createPort(info);
            this.m_portMap.put(info, port);
        }
        if (TDebug.TraceMixer) {
            TDebug.out("AlsaPortMixer.getPort(): end");
        }
        return port;
    }

    private Port createPort(Port.Info info) {
        AlsaMixerElement alsaMixerElement;
        if (TDebug.TraceMixer) {
            TDebug.out("AlsaPortMixer.createPort(): begin");
        }
        if ((alsaMixerElement = (AlsaMixerElement)this.m_mixerElementMap.get(info)) == null) {
            throw new IllegalArgumentException("no port for this info");
        }
        List list = info.isSource() ? this.createSourcePortControls(alsaMixerElement) : new ArrayList();
        TPort tPort = new TPort(this, info, list);
        if (TDebug.TraceMixer) {
            TDebug.out("AlsaPortMixer.createPort(): end");
        }
        return tPort;
    }

    private List createSourcePortControls(AlsaMixerElement alsaMixerElement) {
        Control[] controlArray;
        ArrayList arrayList;
        Control control;
        int n = 1;
        ArrayList arrayList2 = new ArrayList();
        if (alsaMixerElement.hasPlaybackVolume() || alsaMixerElement.hasCommonVolume()) {
            if (alsaMixerElement.isPlaybackMono() || alsaMixerElement.hasPlaybackVolumeJoined()) {
                control = this.createVolumeControl(alsaMixerElement, 0, n);
                arrayList2.add(control);
            } else {
                arrayList = new ArrayList();
                int n2 = 0;
                while (n2 < 31) {
                    if (alsaMixerElement.hasPlaybackChannel(n2)) {
                        control = this.createVolumeControl(alsaMixerElement, n2, n);
                        arrayList.add(control);
                    }
                    ++n2;
                }
                TCompoundControlType tCompoundControlType = new TCompoundControlType("test");
                controlArray = (Control[])arrayList.toArray(new Control[0]);
                control = new AlsaCompoundControl(tCompoundControlType, controlArray);
                arrayList2.add(control);
            }
        }
        if (alsaMixerElement.hasPlaybackSwitch() || alsaMixerElement.hasCommonSwitch()) {
            if (alsaMixerElement.isPlaybackMono() || alsaMixerElement.hasPlaybackSwitchJoined()) {
                control = this.createSwitchControl(alsaMixerElement, 0, n);
                arrayList2.add(control);
            } else {
                arrayList = new ArrayList();
                int n3 = 0;
                while (n3 < 31) {
                    if (alsaMixerElement.hasPlaybackChannel(n3)) {
                        control = this.createSwitchControl(alsaMixerElement, n3, n);
                        arrayList.add(control);
                    }
                    ++n3;
                }
                TCompoundControlType tCompoundControlType = new TCompoundControlType("test");
                controlArray = (Control[])arrayList.toArray(new Control[0]);
                control = new AlsaCompoundControl(tCompoundControlType, controlArray);
                arrayList2.add(control);
            }
        }
        return arrayList2;
    }

    private FloatControl createVolumeControl(AlsaMixerElement alsaMixerElement, int n, int n2) {
        int[] nArray = new int[2];
        switch (n2) {
            case 0: 
            case 1: {
                alsaMixerElement.getPlaybackVolumeRange(nArray);
                break;
            }
            case 2: {
                alsaMixerElement.getCaptureVolumeRange(nArray);
            }
        }
        AlsaVolumeControl alsaVolumeControl = new AlsaVolumeControl(FloatControl.Type.VOLUME, nArray[0], nArray[1], 1.0f, -1, nArray[0], "", "", "", "", alsaMixerElement, n, n2);
        return alsaVolumeControl;
    }

    private BooleanControl createSwitchControl(AlsaMixerElement alsaMixerElement, int n, int n2) {
        AlsaSwitchControl alsaSwitchControl = new AlsaSwitchControl(BooleanControl.Type.MUTE, false, "", "", alsaMixerElement, n, n2);
        return alsaSwitchControl;
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AlsaVolumeControl
    extends FloatControl {
        private AlsaMixerElement m_element;
        private int m_nChannel;
        private int m_nDirection;

        public AlsaVolumeControl(FloatControl.Type type, float f, float f2, float f3, int n, float f4, String string, String string2, String string3, String string4, AlsaMixerElement alsaMixerElement, int n2, int n3) {
            super(type, f, f2, f3, n, f4, string, string2, string3, string4);
            if (TDebug.TraceMixer) {
                TDebug.out("AlsaPortMixer.AlsaFloatControl.<init>(): begin");
            }
            this.m_element = alsaMixerElement;
            this.m_nChannel = n2;
            this.m_nDirection = n3;
            this.setValue(this.getValueImpl());
            if (TDebug.TraceMixer) {
                TDebug.out("AlsaPortMixer.AlsaFloatControl.<init>(): end");
            }
        }

        private AlsaMixerElement getElement() {
            return this.m_element;
        }

        private int getChannel() {
            return this.m_nChannel;
        }

        private int getDirection() {
            return this.m_nDirection;
        }

        @Override
        public void setValue(float f) {
            super.setValue(f);
            int n = (int)f;
            switch (this.getDirection()) {
                case 0: 
                case 1: {
                    this.getElement().setPlaybackVolumeAll(n);
                    return;
                }
                case 2: {
                    this.getElement().setCaptureVolumeAll(n);
                }
            }
        }

        private float getValueImpl() {
            int n = this.getChannel();
            float f = 0.0f;
            switch (this.getDirection()) {
                case 0: 
                case 1: {
                    f = this.getElement().getPlaybackVolume(n);
                    break;
                }
                case 2: {
                    f = this.getElement().getCaptureVolume(n);
                }
            }
            return f;
        }
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AlsaSwitchControl
    extends BooleanControl {
        private AlsaMixerElement m_element;
        private int m_nChannel;
        private int m_nDirection;

        public AlsaSwitchControl(BooleanControl.Type type, boolean bl, String string, String string2, AlsaMixerElement alsaMixerElement, int n, int n2) {
            super(type, bl, string, string2);
            if (TDebug.TraceMixer) {
                TDebug.out("AlsaPortMixer.AlsaFloatControl.<init>(): begin");
            }
            this.m_element = alsaMixerElement;
            this.m_nChannel = n;
            this.m_nDirection = n2;
            if (TDebug.TraceMixer) {
                TDebug.out("AlsaPortMixer.AlsaFloatControl.<init>(): end");
            }
        }

        private AlsaMixerElement getElement() {
            return this.m_element;
        }

        private int getChannel() {
            return this.m_nChannel;
        }

        private int getDirection() {
            return this.m_nDirection;
        }

        @Override
        public void setValue(boolean bl) {
            super.setValue(bl);
            switch (this.getDirection()) {
                case 0: 
                case 1: {
                    this.getElement().setPlaybackSwitchAll(bl);
                    return;
                }
                case 2: {
                    this.getElement().setCaptureSwitchAll(bl);
                }
            }
        }
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class AlsaCompoundControl
    extends CompoundControl {
        public AlsaCompoundControl(CompoundControl.Type type, Control[] controlArray) {
            super(type, controlArray);
        }
    }
}

