/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.sampled.mixer.alsa;

import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import org.tritonus.lowlevel.alsa.Alsa;
import org.tritonus.sampled.mixer.alsa.AlsaBaseDataLine;
import org.tritonus.sampled.mixer.alsa.AlsaDataLineMixer;
import org.tritonus.share.TDebug;
import org.tritonus.share.sampled.TConversionTool;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlsaSourceDataLine
extends AlsaBaseDataLine
implements SourceDataLine {
    private byte[] m_abSwapBuffer;

    public AlsaSourceDataLine(AlsaDataLineMixer alsaDataLineMixer, AudioFormat audioFormat, int n) throws LineUnavailableException {
        super(alsaDataLineMixer, new DataLine.Info(Class.forName("javax.sound.sampled.SourceDataLine"), audioFormat, n));
        if (TDebug.TraceSourceDataLine) {
            TDebug.out("AlsaSourceDataLine.<init>(): begin");
        }
        if (TDebug.TraceSourceDataLine) {
            TDebug.out(new StringBuffer().append("AlsaSourceDataLine.<init>(): buffer size: ").append(n).toString());
        }
        if (TDebug.TraceSourceDataLine) {
            TDebug.out("AlsaSourceDataLine.<init>(): end");
        }
    }

    @Override
    protected int getAlsaStreamType() {
        return 0;
    }

    @Override
    protected void stopImpl() {
        int n;
        if (TDebug.TraceSourceDataLine) {
            TDebug.out("AlsaSourceDataLine.stopImpl(): called");
        }
        if ((n = 0) != 0) {
            TDebug.out(new StringBuffer().append("flushChannel: ").append(Alsa.getStringError(n)).toString());
        }
    }

    @Override
    public int available() {
        this.throwNYIException();
        return -1;
    }

    @Override
    public int write(byte[] byArray, int n, int n2) {
        if (TDebug.TraceSourceDataLine) {
            TDebug.out("AlsaSourceDataLine.write(): begin");
        }
        if (this.getSwapBytes()) {
            if (this.m_abSwapBuffer == null || this.m_abSwapBuffer.length < n + n2) {
                this.m_abSwapBuffer = new byte[n + n2];
            }
            TConversionTool.changeOrderOrSign(byArray, n, this.m_abSwapBuffer, n, n2, this.getBytesPerSample());
            byArray = this.m_abSwapBuffer;
        }
        int n3 = this.writeImpl(byArray, n, n2);
        if (TDebug.TraceSourceDataLine) {
            TDebug.out("AlsaSourceDataLine.write(): end");
        }
        return n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int writeImpl(byte[] byArray, int n, int n2) {
        int n3;
        if (TDebug.TraceSourceDataLine) {
            TDebug.out("AlsaSourceDataLine.writeImpl(): begin");
        }
        if (n2 > 0 && !this.isActive()) {
            this.start();
        }
        int n4 = this.getFormat().getFrameSize();
        for (int i = n2; i > 0 && this.isOpen(); i -= n3) {
            AlsaSourceDataLine alsaSourceDataLine = this;
            synchronized (alsaSourceDataLine) {
                int n5;
                if (!this.isOpen()) {
                    return n2 - i;
                }
                if (TDebug.TraceSourceDataLine) {
                    TDebug.out(new StringBuffer().append("AlsaSourceDataLine.writeImpl(): trying to write (bytes): ").append(i).toString());
                }
                int n6 = i / n4;
                if (TDebug.TraceSourceDataLine) {
                    TDebug.out(new StringBuffer().append("AlsaSourceDataLine.writeImpl(): trying to write (frames): ").append(n6).toString());
                }
                if ((n5 = (int)this.getAlsaPcm().writei(byArray, n, n6)) < 0) {
                    TDebug.out(new StringBuffer().append("AlsaSourceDataLine.writeImpl(): ").append(Alsa.getStringError(n5)).toString());
                    return n2 - i;
                }
                if (TDebug.TraceSourceDataLine) {
                    TDebug.out(new StringBuffer().append("AlsaSourceDataLine.writeImpl(): written (frames): ").append(n5).toString());
                }
                n3 = n5 * n4;
                if (TDebug.TraceSourceDataLine) {
                    TDebug.out(new StringBuffer().append("AlsaSourceDataLine.writeImpl(): written (bytes): ").append(n3).toString());
                }
                n += n3;
                continue;
            }
        }
        return n2;
    }

    @Override
    public void drain() {
    }

    @Override
    public void flush() {
    }

    private void setGain(float f) {
    }

    private void throwNYIException() {
        throw new RuntimeException("sorry, this feature is not yet implemented");
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class AlsaSourceDataLineGainControl
    extends FloatControl {
        private final float MAX_GAIN;
        private final float MIN_GAIN;
        private final int GAIN_INCREMENTS;

        AlsaSourceDataLineGainControl() {
            super(FloatControl.Type.VOLUME, -96.0f, 24.0f, 0.01f, 0, 0.0f, "dB", "-96.0", "", "+24.0");
            this.Block$();
        }

        @Override
        public void setValue(float f) {
            if ((double)Math.abs((f = Math.max(Math.min(f, this.getMaximum()), this.getMinimum())) - this.getValue()) > 1.0E9) {
                super.setValue(f);
                AlsaSourceDataLine.this.setGain(this.getValue());
            }
        }

        private /* synthetic */ void Block$() {
            this.MAX_GAIN = 90.0f;
            this.MIN_GAIN = -96.0f;
            this.GAIN_INCREMENTS = 1000;
        }
    }
}

