/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.sampled.mixer.alsa;

import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.TargetDataLine;
import org.tritonus.lowlevel.alsa.Alsa;
import org.tritonus.sampled.mixer.alsa.AlsaBaseDataLine;
import org.tritonus.sampled.mixer.alsa.AlsaDataLineMixer;
import org.tritonus.share.TDebug;
import org.tritonus.share.sampled.TConversionTool;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlsaTargetDataLine
extends AlsaBaseDataLine
implements TargetDataLine {
    private byte[] m_abSwapBuffer;

    public AlsaTargetDataLine(AlsaDataLineMixer alsaDataLineMixer, AudioFormat audioFormat, int n) throws LineUnavailableException {
        super(alsaDataLineMixer, new DataLine.Info(Class.forName("javax.sound.sampled.TargetDataLine"), audioFormat, n));
    }

    @Override
    protected int getAlsaStreamType() {
        return 1;
    }

    @Override
    protected void stopImpl() {
        int n;
        if (TDebug.TraceTargetDataLine) {
            TDebug.out("AlsaTargetDataLine.stopImpl(): called.");
        }
        if ((n = 0) != 0) {
            TDebug.out(new StringBuffer().append("flushChannel: ").append(Alsa.getStringError(n)).toString());
        }
    }

    @Override
    public int available() {
        return -1;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) {
        if (TDebug.TraceTargetDataLine) {
            TDebug.out("AlsaTargetDataLine.read(): called.");
            TDebug.out(new StringBuffer().append("AlsaTargetDataLine.read(): wanted length: ").append(n2).toString());
        }
        int n3 = n;
        if (n2 > 0 && !this.isActive()) {
            this.start();
        }
        if (!this.isOpen() && TDebug.TraceTargetDataLine) {
            TDebug.out("AlsaTargetDataLine.read(): stream closed");
        }
        int n4 = this.readImpl(byArray, n, n2);
        if (TDebug.TraceTargetDataLine) {
            TDebug.out(new StringBuffer().append("AlsaTargetDataLine.read(): read (bytes): ").append(n4).toString());
        }
        if (this.getSwapBytes() && n4 > 0) {
            TConversionTool.swapOrder16(byArray, n3, n4 / 2);
        }
        return n4;
    }

    public int readImpl(byte[] byArray, int n, int n2) {
        int n3;
        if (TDebug.TraceTargetDataLine) {
            TDebug.out("AlsaTargetDataLine.readImpl(): called.");
            TDebug.out(new StringBuffer().append("AlsaTargetDataLine.readImpl(): wanted length: ").append(n2).toString());
        }
        int n4 = this.getFormat().getFrameSize();
        int n5 = n;
        int n6 = n2 / n4;
        if (n2 > 0 && !this.isActive()) {
            this.start();
        }
        if (!this.isOpen() && TDebug.TraceTargetDataLine) {
            TDebug.out("AlsaTargetDataLine.readImpl(): stream closed");
        }
        if ((n3 = (int)this.getAlsaPcm().readi(byArray, n, n6)) < 0) {
            TDebug.out(new StringBuffer().append("AlsaTargetDataLine.readImpl(): ").append(Alsa.getStringError(n3)).toString());
        }
        int n7 = n3 * n4;
        if (TDebug.TraceTargetDataLine) {
            TDebug.out(new StringBuffer().append("AlsaTargetDataLine.readImpl(): read (bytes): ").append(n7).toString());
        }
        return n7;
    }

    @Override
    public void drain() {
    }

    @Override
    public void flush() {
    }

    public long getPosition() {
        return 0L;
    }

    private void setGain(float f) {
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class AlsaTargetDataLineGainControl
    extends FloatControl {
        private final float MAX_GAIN;
        private final float MIN_GAIN;
        private final int GAIN_INCREMENTS;

        AlsaTargetDataLineGainControl() {
            super(FloatControl.Type.VOLUME, -96.0f, 24.0f, 0.01f, 0, 0.0f, "dB", "-96.0", "", "+24.0");
            this.Block$();
        }

        @Override
        public void setValue(float f) {
            if ((double)Math.abs((f = Math.max(Math.min(f, this.getMaximum()), this.getMinimum())) - this.getValue()) > 1.0E9) {
                super.setValue(f);
                AlsaTargetDataLine.this.setGain(this.getValue());
            }
        }

        private /* synthetic */ void Block$() {
            this.MAX_GAIN = 90.0f;
            this.MIN_GAIN = -96.0f;
            this.GAIN_INCREMENTS = 1000;
        }
    }
}

