/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.sampled.mixer.esd;

import java.util.Arrays;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.TargetDataLine;
import org.tritonus.sampled.mixer.esd.EsdSourceDataLine;
import org.tritonus.sampled.mixer.esd.EsdTargetDataLine;
import org.tritonus.share.GlobalInfo;
import org.tritonus.share.TDebug;
import org.tritonus.share.sampled.mixer.TMixer;
import org.tritonus.share.sampled.mixer.TMixerInfo;
import org.tritonus.share.sampled.mixer.TSoftClip;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EsdMixer
extends TMixer {
    private static final int DEFAULT_BUFFER_SIZE = 32768;
    private static AudioFormat[] FORMATS = new AudioFormat[]{new AudioFormat(AudioFormat.Encoding.PCM_UNSIGNED, AudioSystem.NOT_SPECIFIED, 8, 1, 1, AudioSystem.NOT_SPECIFIED, true), new AudioFormat(AudioFormat.Encoding.PCM_UNSIGNED, AudioSystem.NOT_SPECIFIED, 8, 1, 1, AudioSystem.NOT_SPECIFIED, false), new AudioFormat(AudioFormat.Encoding.PCM_UNSIGNED, AudioSystem.NOT_SPECIFIED, 8, 2, 2, AudioSystem.NOT_SPECIFIED, true), new AudioFormat(AudioFormat.Encoding.PCM_UNSIGNED, AudioSystem.NOT_SPECIFIED, 8, 2, 2, AudioSystem.NOT_SPECIFIED, false), new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, AudioSystem.NOT_SPECIFIED, 16, 1, 2, AudioSystem.NOT_SPECIFIED, false), new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, AudioSystem.NOT_SPECIFIED, 16, 2, 4, AudioSystem.NOT_SPECIFIED, false), new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, AudioSystem.NOT_SPECIFIED, 8, 1, 1, AudioSystem.NOT_SPECIFIED, true), new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, AudioSystem.NOT_SPECIFIED, 8, 1, 1, AudioSystem.NOT_SPECIFIED, false), new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, AudioSystem.NOT_SPECIFIED, 8, 2, 2, AudioSystem.NOT_SPECIFIED, true), new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, AudioSystem.NOT_SPECIFIED, 8, 2, 2, AudioSystem.NOT_SPECIFIED, false), new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, AudioSystem.NOT_SPECIFIED, 16, 1, 2, AudioSystem.NOT_SPECIFIED, true), new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, AudioSystem.NOT_SPECIFIED, 16, 2, 4, AudioSystem.NOT_SPECIFIED, true)};
    private static Line.Info[] SOURCE_LINE_INFOS = new Line.Info[]{new DataLine.Info(Class.forName("javax.sound.sampled.SourceDataLine"), FORMATS, AudioSystem.NOT_SPECIFIED, AudioSystem.NOT_SPECIFIED)};
    private static Line.Info[] TARGET_LINE_INFOS = new Line.Info[]{new DataLine.Info(Class.forName("javax.sound.sampled.TargetDataLine"), FORMATS, AudioSystem.NOT_SPECIFIED, AudioSystem.NOT_SPECIFIED)};

    public EsdMixer() {
        super(new TMixerInfo("Esd Mixer", GlobalInfo.getVendor(), "Mixer for the Enlightened Sound Daemon (esd) running on the local machine", GlobalInfo.getVersion()), new Line.Info(Class.forName("javax.sound.sampled.Mixer")), Arrays.asList(FORMATS), Arrays.asList(FORMATS), Arrays.asList(SOURCE_LINE_INFOS), Arrays.asList(TARGET_LINE_INFOS));
        if (TDebug.TraceMixer) {
            TDebug.out("EsdMixer.<init>: begin");
        }
        if (TDebug.TraceMixer) {
            TDebug.out("EsdMixer.<init>: end");
        }
    }

    @Override
    public void open() {
        if (TDebug.TraceMixer) {
            TDebug.out("EsdMixer.open(): begin");
        }
        if (TDebug.TraceMixer) {
            TDebug.out("EsdMixer.open(): end");
        }
    }

    @Override
    public void close() {
        if (TDebug.TraceMixer) {
            TDebug.out("EsdMixer.close(): begin");
        }
        if (TDebug.TraceMixer) {
            TDebug.out("EsdMixer.close(): end");
        }
    }

    @Override
    public int getMaxLines(Line.Info info) {
        if (TDebug.TraceMixer) {
            TDebug.out("EsdMixer.getMaxLines(): begin");
        }
        int n = 0;
        if (info instanceof DataLine.Info) {
            Class clazz = info.getLineClass();
            if (clazz == Class.forName("javax.sound.sampled.SourceDataLine")) {
                n = 32;
            } else if (clazz == Class.forName("javax.sound.sampled.TargetDataLine")) {
                n = 1;
            }
        }
        if (TDebug.TraceMixer) {
            TDebug.out("EsdMixer.getMaxLines(): end");
        }
        return n;
    }

    @Override
    protected SourceDataLine getSourceDataLine(AudioFormat audioFormat, int n) throws LineUnavailableException {
        if (TDebug.TraceMixer) {
            TDebug.out("EsdMixer.getSourceDataLine(): begin");
        }
        if (TDebug.TraceMixer) {
            TDebug.out(new StringBuffer().append("EsdMixer.getSourceDataLine(): format: ").append(audioFormat).toString());
            TDebug.out(new StringBuffer().append("EsdMixer.getSourceDataLine(): buffer size: ").append(n).toString());
        }
        if (n < 1) {
            n = 32768;
        }
        EsdSourceDataLine esdSourceDataLine = new EsdSourceDataLine((TMixer)this, audioFormat, n);
        esdSourceDataLine.start();
        if (TDebug.TraceMixer) {
            TDebug.out(new StringBuffer().append("EsdMixer.getSourceDataLine(): returning: ").append(esdSourceDataLine).toString());
        }
        if (TDebug.TraceMixer) {
            TDebug.out("EsdMixer.getSourceDataLine(): end");
        }
        return esdSourceDataLine;
    }

    @Override
    protected TargetDataLine getTargetDataLine(AudioFormat audioFormat, int n) throws LineUnavailableException {
        if (TDebug.TraceMixer) {
            TDebug.out("EsdMixer.getTargetDataLine(): begin");
        }
        int n2 = n * audioFormat.getFrameSize();
        EsdTargetDataLine esdTargetDataLine = new EsdTargetDataLine((TMixer)this, audioFormat, n2);
        esdTargetDataLine.start();
        if (TDebug.TraceMixer) {
            TDebug.out(new StringBuffer().append("EsdMixer.getTargetDataLine(): returning: ").append(esdTargetDataLine).toString());
        }
        if (TDebug.TraceMixer) {
            TDebug.out("EsdMixer.getTargetDataLine(): end");
        }
        return esdTargetDataLine;
    }

    @Override
    protected Clip getClip(AudioFormat audioFormat) throws LineUnavailableException {
        if (TDebug.TraceMixer) {
            TDebug.out("EsdMixer.getClip(): begin");
        }
        TSoftClip tSoftClip = new TSoftClip((Mixer)this, audioFormat);
        if (TDebug.TraceMixer) {
            TDebug.out("EsdMixer.getClip(): end");
        }
        return tSoftClip;
    }
}

