/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.sampled.mixer.esd;

import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.TargetDataLine;
import org.tritonus.lowlevel.esd.EsdRecordingStream;
import org.tritonus.sampled.mixer.esd.EsdUtils;
import org.tritonus.share.TDebug;
import org.tritonus.share.sampled.TConversionTool;
import org.tritonus.share.sampled.mixer.TBaseDataLine;
import org.tritonus.share.sampled.mixer.TMixer;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EsdTargetDataLine
extends TBaseDataLine
implements TargetDataLine {
    private EsdRecordingStream m_esdStream;
    private boolean m_bSwapBytes;
    private byte[] m_abSwapBuffer;
    private int m_nBytesPerSample;

    public EsdTargetDataLine(TMixer tMixer, AudioFormat audioFormat, int n) throws LineUnavailableException {
        super(tMixer, new DataLine.Info(Class.forName("javax.sound.sampled.TargetDataLine"), audioFormat, n));
    }

    @Override
    protected void openImpl() {
        if (TDebug.TraceTargetDataLine) {
            TDebug.out("EsdTargetDataLine.openImpl(): called.");
        }
        this.checkOpen();
        AudioFormat audioFormat = this.getFormat();
        AudioFormat.Encoding encoding = audioFormat.getEncoding();
        boolean bl = audioFormat.isBigEndian();
        this.m_bSwapBytes = false;
        if (audioFormat.getSampleSizeInBits() == 16 && bl) {
            this.m_bSwapBytes = true;
            bl = false;
        } else if (audioFormat.getSampleSizeInBits() == 8 && encoding.equals(AudioFormat.Encoding.PCM_SIGNED)) {
            this.m_bSwapBytes = true;
            encoding = AudioFormat.Encoding.PCM_UNSIGNED;
        }
        if (this.m_bSwapBytes) {
            audioFormat = new AudioFormat(encoding, audioFormat.getSampleRate(), audioFormat.getSampleSizeInBits(), audioFormat.getChannels(), audioFormat.getFrameSize(), audioFormat.getFrameRate(), bl);
            this.m_nBytesPerSample = audioFormat.getFrameSize() / audioFormat.getChannels();
        }
        int n = 0x1000 | EsdUtils.getEsdFormat(audioFormat);
        this.m_esdStream = new EsdRecordingStream();
        this.m_esdStream.open(n, (int)audioFormat.getSampleRate());
    }

    @Override
    public int available() {
        return -1;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) {
        if (TDebug.TraceTargetDataLine) {
            TDebug.out("EsdTargetDataLine.read(): called.");
            TDebug.out(new StringBuffer().append("EsdTargetDataLine.read(): wanted length: ").append(n2).toString());
        }
        int n3 = n;
        if (n2 > 0 && !this.isActive()) {
            this.start();
        }
        if (!this.isOpen() && TDebug.TraceTargetDataLine) {
            TDebug.out("EsdTargetDataLine.read(): stream closed");
        }
        int n4 = this.m_esdStream.read(byArray, n, n2);
        if (TDebug.TraceTargetDataLine) {
            TDebug.out(new StringBuffer().append("EsdTargetDataLine.read(): read (bytes): ").append(n4).toString());
        }
        if (this.m_bSwapBytes && n4 > 0) {
            TConversionTool.swapOrder16(byArray, n3, n4 / 2);
        }
        return n4;
    }

    @Override
    public void closeImpl() {
        this.m_esdStream.close();
    }

    @Override
    public void drain() {
    }

    @Override
    public void flush() {
    }

    public long getPosition() {
        return 0L;
    }

    private void setGain(float f) {
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class EsdTargetDataLineGainControl
    extends FloatControl {
        private final float MAX_GAIN;
        private final float MIN_GAIN;
        private final int GAIN_INCREMENTS;

        EsdTargetDataLineGainControl() {
            super(FloatControl.Type.VOLUME, -96.0f, 24.0f, 0.01f, 0, 0.0f, "dB", "-96.0", "", "+24.0");
            this.Block$();
        }

        @Override
        public void setValue(float f) {
            if ((double)Math.abs((f = Math.max(Math.min(f, this.getMaximum()), this.getMinimum())) - this.getValue()) > 1.0E9) {
                super.setValue(f);
                EsdTargetDataLine.this.setGain(this.getValue());
            }
        }

        private /* synthetic */ void Block$() {
            this.MAX_GAIN = 90.0f;
            this.MIN_GAIN = -96.0f;
            this.GAIN_INCREMENTS = 1000;
        }
    }
}

