/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.share.midi;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.sound.midi.Transmitter;
import org.tritonus.share.TDebug;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TMidiDevice
implements MidiDevice {
    private MidiDevice.Info m_info;
    private boolean m_bOpen;
    private boolean m_bUseIn;
    private boolean m_bUseOut;
    private int m_nNumReceivers;
    private List m_transmitters;

    public TMidiDevice(MidiDevice.Info info) {
        this(info, true, true);
    }

    public TMidiDevice(MidiDevice.Info info, boolean bl, boolean bl2) {
        if (TDebug.TraceMidiDevice) {
            TDebug.out("TMidiDevice.<init>(): begin");
        }
        this.m_info = info;
        this.m_bUseIn = bl;
        this.m_bUseOut = bl2;
        this.m_bOpen = false;
        this.m_nNumReceivers = 0;
        this.m_transmitters = new ArrayList();
        if (TDebug.TraceMidiDevice) {
            TDebug.out("TMidiDevice.<init>(): end");
        }
    }

    @Override
    public MidiDevice.Info getDeviceInfo() {
        if (TDebug.TraceMidiDevice) {
            TDebug.out("TMidiDevice.getDeviceInfo(): begin");
        }
        if (TDebug.TraceMidiDevice) {
            TDebug.out("TMidiDevice.getDeviceInfo(): end");
        }
        return this.m_info;
    }

    @Override
    public void open() throws MidiUnavailableException {
        if (TDebug.TraceMidiDevice) {
            TDebug.out("TMidiDevice.open(): begin");
        }
        if (!this.isOpen()) {
            this.m_bOpen = true;
            this.openImpl();
        }
        if (TDebug.TraceMidiDevice) {
            TDebug.out("TMidiDevice.open(): end");
        }
    }

    protected void openImpl() throws MidiUnavailableException {
        if (TDebug.TraceMidiDevice) {
            TDebug.out("TMidiDevice.openImpl(): begin");
        }
        if (TDebug.TraceMidiDevice) {
            TDebug.out("TMidiDevice.openImpl(): end");
        }
    }

    @Override
    public void close() {
        if (TDebug.TraceMidiDevice) {
            TDebug.out("TMidiDevice.close(): begin");
        }
        if (this.isOpen()) {
            this.closeImpl();
            this.m_bOpen = false;
        }
        if (TDebug.TraceMidiDevice) {
            TDebug.out("TMidiDevice.close(): end");
        }
    }

    protected void closeImpl() {
        if (TDebug.TraceMidiDevice) {
            TDebug.out("TMidiDevice.closeImpl(): begin");
        }
        if (TDebug.TraceMidiDevice) {
            TDebug.out("TMidiDevice.closeImpl(): end");
        }
    }

    @Override
    public boolean isOpen() {
        return this.m_bOpen;
    }

    protected boolean getUseIn() {
        return this.m_bUseIn;
    }

    protected boolean getUseOut() {
        return this.m_bUseOut;
    }

    @Override
    public long getMicrosecondPosition() {
        return -1L;
    }

    @Override
    public int getMaxReceivers() {
        int n = 0;
        if (this.getUseOut()) {
            n = -1;
        }
        return n;
    }

    @Override
    public int getMaxTransmitters() {
        int n = 0;
        if (this.getUseIn()) {
            n = -1;
        }
        return n;
    }

    @Override
    public Receiver getReceiver() throws MidiUnavailableException {
        if (!this.getUseOut()) {
            throw new MidiUnavailableException("Receivers are not supported by this device");
        }
        return new TReceiver();
    }

    @Override
    public Transmitter getTransmitter() throws MidiUnavailableException {
        if (!this.getUseIn()) {
            throw new MidiUnavailableException("Transmitters are not supported by this device");
        }
        return new TTransmitter();
    }

    protected void receive(MidiMessage midiMessage, long l) {
        if (TDebug.TraceMidiDevice) {
            TDebug.out(new StringBuffer().append("### [should be overridden] TMidiDevice.receive(): message ").append(midiMessage).toString());
        }
    }

    private void addReceiver() {
        ++this.m_nNumReceivers;
    }

    private void removeReceiver() {
        this.m_nNumReceivers += -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addTransmitter(Transmitter transmitter) {
        List list = this.m_transmitters;
        synchronized (list) {
            this.m_transmitters.add(transmitter);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeTransmitter(Transmitter transmitter) {
        List list = this.m_transmitters;
        synchronized (list) {
            this.m_transmitters.remove(transmitter);
            return;
        }
    }

    protected void sendImpl(MidiMessage midiMessage, long l) {
        if (TDebug.TraceMidiDevice) {
            TDebug.out("TMidiDevice.sendImpl(): begin");
        }
        Iterator iterator = this.m_transmitters.iterator();
        while (iterator.hasNext()) {
            TTransmitter tTransmitter = (TTransmitter)iterator.next();
            MidiMessage midiMessage2 = null;
            if (midiMessage instanceof MetaMessage) {
                MetaMessage metaMessage;
                block10: {
                    MetaMessage metaMessage2 = (MetaMessage)midiMessage;
                    metaMessage = new MetaMessage();
                    try {
                        metaMessage.setMessage(metaMessage2.getType(), metaMessage2.getData(), metaMessage2.getData().length);
                    }
                    catch (InvalidMidiDataException invalidMidiDataException) {
                        if (!TDebug.TraceAllExceptions) break block10;
                        TDebug.out(invalidMidiDataException);
                    }
                }
                midiMessage2 = metaMessage;
            } else {
                midiMessage2 = (MidiMessage)midiMessage.clone();
            }
            if (midiMessage instanceof MetaMessage) {
                if (TDebug.TraceMidiDevice) {
                    TDebug.out(new StringBuffer().append("TMidiDevice.sendImpl(): MetaMessage.getData().length (original): ").append(((MetaMessage)midiMessage).getData().length).toString());
                }
                if (TDebug.TraceMidiDevice) {
                    TDebug.out(new StringBuffer().append("TMidiDevice.sendImpl(): MetaMessage.getData().length (cloned): ").append(((MetaMessage)midiMessage2).getData().length).toString());
                }
            }
            tTransmitter.send(midiMessage2, l);
        }
        if (TDebug.TraceMidiDevice) {
            TDebug.out("TMidiDevice.sendImpl(): end");
        }
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class TReceiver
    implements Receiver {
        private boolean m_bOpen;

        public TReceiver() {
            TMidiDevice.this.addReceiver();
            this.m_bOpen = true;
        }

        protected boolean isOpen() {
            return this.m_bOpen;
        }

        @Override
        public void send(MidiMessage midiMessage, long l) {
            if (TDebug.TraceMidiDevice) {
                TDebug.out(new StringBuffer().append("TMidiDevice.TReceiver.send(): message ").append(midiMessage).toString());
            }
            if (this.m_bOpen) {
                TMidiDevice.this.receive(midiMessage, l);
                return;
            }
            throw new IllegalStateException("receiver is not open");
        }

        @Override
        public void close() {
            TMidiDevice.this.removeReceiver();
            this.m_bOpen = false;
        }
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class TTransmitter
    implements Transmitter {
        private Receiver m_receiver;

        public TTransmitter() {
            TMidiDevice.this.addTransmitter(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setReceiver(Receiver receiver) {
            TTransmitter tTransmitter = this;
            synchronized (tTransmitter) {
                this.m_receiver = receiver;
                return;
            }
        }

        @Override
        public Receiver getReceiver() {
            return this.m_receiver;
        }

        public void send(MidiMessage midiMessage, long l) {
            if (this.getReceiver() != null) {
                this.getReceiver().send(midiMessage, l);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            TMidiDevice.this.removeTransmitter(this);
            TTransmitter tTransmitter = this;
            synchronized (tTransmitter) {
                this.m_receiver = null;
                return;
            }
        }
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Info
    extends MidiDevice.Info {
        public Info(String string, String string2, String string3, String string4) {
            super(string, string2, string3, string4);
        }
    }
}

