/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.share.sampled.convert;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.sound.sampled.AudioFormat;
import org.tritonus.share.ArraySet;
import org.tritonus.share.sampled.AudioFormats;
import org.tritonus.share.sampled.convert.TFormatConversionProvider;
import org.tritonus.share.sampled.convert.TSimpleFormatConversionProvider;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TMatrixFormatConversionProvider
extends TSimpleFormatConversionProvider {
    private Map m_targetEncodingsFromSourceFormat = new HashMap();
    private Map m_targetFormatsFromSourceFormat = new HashMap();

    protected TMatrixFormatConversionProvider(List list, List list2, boolean[][] blArray) {
        super(list, list2);
        int n = 0;
        while (n < list.size()) {
            AudioFormat audioFormat = (AudioFormat)list.get(n);
            ArraySet arraySet = new ArraySet();
            this.m_targetEncodingsFromSourceFormat.put(audioFormat, arraySet);
            HashMap hashMap = new HashMap();
            this.m_targetFormatsFromSourceFormat.put(audioFormat, hashMap);
            int n2 = 0;
            while (n2 < list2.size()) {
                AudioFormat audioFormat2 = (AudioFormat)list2.get(n2);
                if (blArray[n][n2]) {
                    AudioFormat.Encoding encoding = audioFormat2.getEncoding();
                    arraySet.add(encoding);
                    Collection collection = (Collection)hashMap.get(encoding);
                    if (collection == null) {
                        collection = new ArraySet();
                        hashMap.put(encoding, collection);
                    }
                    collection.add(audioFormat2);
                }
                ++n2;
            }
            ++n;
        }
    }

    @Override
    public AudioFormat.Encoding[] getTargetEncodings(AudioFormat audioFormat) {
        Iterator iterator = this.m_targetEncodingsFromSourceFormat.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            AudioFormat audioFormat2 = (AudioFormat)entry.getKey();
            if (!AudioFormats.matches(audioFormat2, audioFormat)) continue;
            Collection collection = (Collection)entry.getValue();
            return (AudioFormat.Encoding[])collection.toArray(TFormatConversionProvider.EMPTY_ENCODING_ARRAY);
        }
        return TFormatConversionProvider.EMPTY_ENCODING_ARRAY;
    }

    @Override
    public AudioFormat[] getTargetFormats(AudioFormat.Encoding encoding, AudioFormat audioFormat) {
        Iterator iterator = this.m_targetFormatsFromSourceFormat.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            AudioFormat audioFormat2 = (AudioFormat)entry.getKey();
            if (!AudioFormats.matches(audioFormat2, audioFormat)) continue;
            Map map = (Map)entry.getValue();
            Collection collection = (Collection)map.get(encoding);
            if (collection != null) {
                return (AudioFormat[])collection.toArray(TFormatConversionProvider.EMPTY_FORMAT_ARRAY);
            }
            return TFormatConversionProvider.EMPTY_FORMAT_ARRAY;
        }
        return TFormatConversionProvider.EMPTY_FORMAT_ARRAY;
    }
}

