/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.share.sampled.file;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Iterator;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.spi.AudioFileWriter;
import org.tritonus.share.ArraySet;
import org.tritonus.share.TDebug;
import org.tritonus.share.sampled.AudioFormats;
import org.tritonus.share.sampled.AudioUtils;
import org.tritonus.share.sampled.Encodings;
import org.tritonus.share.sampled.TConversionTool;
import org.tritonus.share.sampled.file.AudioOutputStream;
import org.tritonus.share.sampled.file.TDataOutputStream;
import org.tritonus.share.sampled.file.TNonSeekableDataOutputStream;
import org.tritonus.share.sampled.file.TSeekableDataOutputStream;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TAudioFileWriter
extends AudioFileWriter {
    protected static final int ALL = -1;
    public static AudioFormat.Encoding PCM_SIGNED = Encodings.getEncoding("PCM_SIGNED");
    public static AudioFormat.Encoding PCM_UNSIGNED = Encodings.getEncoding("PCM_UNSIGNED");
    private static final int BUFFER_LENGTH = 16384;
    protected static final AudioFileFormat.Type[] NULL_TYPE_ARRAY = new AudioFileFormat.Type[0];
    private Collection m_audioFileTypes;
    private Collection m_audioFormats;

    protected TAudioFileWriter(Collection collection, Collection collection2) {
        this.m_audioFileTypes = collection;
        this.m_audioFormats = collection2;
    }

    @Override
    public AudioFileFormat.Type[] getAudioFileTypes() {
        return (AudioFileFormat.Type[])this.m_audioFileTypes.toArray(NULL_TYPE_ARRAY);
    }

    @Override
    public boolean isFileTypeSupported(AudioFileFormat.Type type) {
        return this.m_audioFileTypes.contains(type);
    }

    @Override
    public AudioFileFormat.Type[] getAudioFileTypes(AudioInputStream audioInputStream) {
        AudioFormat audioFormat = audioInputStream.getFormat();
        ArraySet arraySet = new ArraySet();
        Iterator iterator = this.m_audioFileTypes.iterator();
        while (iterator.hasNext()) {
            AudioFileFormat.Type type = (AudioFileFormat.Type)iterator.next();
            if (!this.isAudioFormatSupportedImpl(audioFormat, type)) continue;
            arraySet.add(type);
        }
        return (AudioFileFormat.Type[])arraySet.toArray(NULL_TYPE_ARRAY);
    }

    @Override
    public boolean isFileTypeSupported(AudioFileFormat.Type type, AudioInputStream audioInputStream) {
        return this.isFileTypeSupported(type) && (this.isAudioFormatSupportedImpl(audioInputStream.getFormat(), type) || this.findConvertableFormat(audioInputStream.getFormat(), type) != null);
    }

    @Override
    public int write(AudioInputStream audioInputStream, AudioFileFormat.Type type, File file) throws IOException {
        if (TDebug.TraceAudioFileWriter) {
            TDebug.out(">TAudioFileWriter.write(.., File): called");
            TDebug.out(new StringBuffer().append("class: ").append(this.getClass().getName()).toString());
        }
        if (!this.isFileTypeSupported(type)) {
            if (TDebug.TraceAudioFileWriter) {
                TDebug.out("< file type is not supported");
            }
            throw new IllegalArgumentException("file type is not supported.");
        }
        AudioFormat audioFormat = audioInputStream.getFormat();
        if (TDebug.TraceAudioFileWriter) {
            TDebug.out(new StringBuffer().append("input format: ").append(audioFormat).toString());
        }
        AudioFormat audioFormat2 = null;
        boolean bl = false;
        if (this.isAudioFormatSupportedImpl(audioFormat, type)) {
            if (TDebug.TraceAudioFileWriter) {
                TDebug.out("input format is supported directely");
            }
            audioFormat2 = audioFormat;
            bl = false;
        } else {
            if (TDebug.TraceAudioFileWriter) {
                TDebug.out("input format is not supported directely; trying to find a convertable format");
            }
            if ((audioFormat2 = this.findConvertableFormat(audioFormat, type)) != null) {
                bl = true;
                if (audioFormat2.getSampleSizeInBits() == 8 && audioFormat2.getEncoding().equals(audioFormat.getEncoding())) {
                    bl = false;
                }
            } else {
                if (TDebug.TraceAudioFileWriter) {
                    TDebug.out("< input format is not supported and not convertable.");
                }
                throw new IllegalArgumentException("format not supported and not convertable");
            }
        }
        long l = AudioUtils.getLengthInBytes(audioInputStream);
        TSeekableDataOutputStream tSeekableDataOutputStream = new TSeekableDataOutputStream(file);
        AudioOutputStream audioOutputStream = this.getAudioOutputStream(audioFormat2, l, type, tSeekableDataOutputStream);
        int n = this.writeImpl(audioInputStream, audioOutputStream, bl);
        if (TDebug.TraceAudioFileWriter) {
            TDebug.out(new StringBuffer().append("< wrote ").append(n).append(" bytes.").toString());
        }
        return n;
    }

    @Override
    public int write(AudioInputStream audioInputStream, AudioFileFormat.Type type, OutputStream outputStream) throws IOException {
        if (!this.isFileTypeSupported(type)) {
            throw new IllegalArgumentException("file type is not supported.");
        }
        if (TDebug.TraceAudioFileWriter) {
            TDebug.out(">TAudioFileWriter.write(.., OutputStream): called");
            TDebug.out(new StringBuffer().append("class: ").append(this.getClass().getName()).toString());
        }
        AudioFormat audioFormat = audioInputStream.getFormat();
        if (TDebug.TraceAudioFileWriter) {
            TDebug.out(new StringBuffer().append("input format: ").append(audioFormat).toString());
        }
        AudioFormat audioFormat2 = null;
        boolean bl = false;
        if (this.isAudioFormatSupportedImpl(audioFormat, type)) {
            if (TDebug.TraceAudioFileWriter) {
                TDebug.out("input format is supported directely");
            }
            audioFormat2 = audioFormat;
            bl = false;
        } else {
            if (TDebug.TraceAudioFileWriter) {
                TDebug.out("input format is not supported directely; trying to find a convertable format");
            }
            if ((audioFormat2 = this.findConvertableFormat(audioFormat, type)) != null) {
                bl = true;
                if (audioFormat2.getSampleSizeInBits() == 8 && audioFormat2.getEncoding().equals(audioFormat.getEncoding())) {
                    bl = false;
                }
            } else {
                if (TDebug.TraceAudioFileWriter) {
                    TDebug.out("< format is not supported");
                }
                throw new IllegalArgumentException("format not supported and not convertable");
            }
        }
        long l = AudioUtils.getLengthInBytes(audioInputStream);
        TNonSeekableDataOutputStream tNonSeekableDataOutputStream = new TNonSeekableDataOutputStream(outputStream);
        AudioOutputStream audioOutputStream = this.getAudioOutputStream(audioFormat2, l, type, tNonSeekableDataOutputStream);
        int n = this.writeImpl(audioInputStream, audioOutputStream, bl);
        if (TDebug.TraceAudioFileWriter) {
            TDebug.out(new StringBuffer().append("< wrote ").append(n).append(" bytes.").toString());
        }
        return n;
    }

    protected int writeImpl(AudioInputStream audioInputStream, AudioOutputStream audioOutputStream, boolean bl) throws IOException {
        if (TDebug.TraceAudioFileWriter) {
            TDebug.out(">TAudioFileWriter.writeImpl(): called");
            TDebug.out(new StringBuffer().append("class: ").append(this.getClass().getName()).toString());
        }
        int n = 0;
        AudioFormat audioFormat = audioInputStream.getFormat();
        AudioFormat audioFormat2 = audioOutputStream.getFormat();
        int n2 = audioFormat2.getFrameSize() / audioFormat2.getChannels();
        int n3 = 16384 / audioFormat2.getFrameSize() * audioFormat2.getFrameSize();
        byte[] byArray = new byte[n3];
        while (true) {
            if (TDebug.TraceAudioFileWriter) {
                TDebug.out(new StringBuffer().append("trying to read (bytes): ").append(byArray.length).toString());
            }
            int n4 = audioInputStream.read(byArray);
            if (TDebug.TraceAudioFileWriter) {
                TDebug.out(new StringBuffer().append("read (bytes): ").append(n4).toString());
            }
            if (n4 == -1) break;
            if (bl) {
                TConversionTool.changeOrderOrSign(byArray, 0, n4, n2);
            }
            int n5 = audioOutputStream.write(byArray, 0, n4);
            n += n5;
        }
        if (TDebug.TraceAudioFileWriter) {
            TDebug.out(new StringBuffer().append("<TAudioFileWriter.writeImpl(): after main loop. Wrote ").append(n).append(" bytes").toString());
        }
        audioOutputStream.close();
        return n;
    }

    protected Iterator getSupportedAudioFormats(AudioFileFormat.Type type) {
        return this.m_audioFormats.iterator();
    }

    protected boolean isAudioFormatSupportedImpl(AudioFormat audioFormat, AudioFileFormat.Type type) {
        if (TDebug.TraceAudioFileWriter) {
            TDebug.out(new StringBuffer().append("> TAudioFileWriter.isAudioFormatSupportedImpl(): format to test: ").append(audioFormat).toString());
            TDebug.out(new StringBuffer().append("class: ").append(this.getClass().getName()).toString());
        }
        Iterator iterator = this.getSupportedAudioFormats(type);
        while (iterator.hasNext()) {
            AudioFormat audioFormat2 = (AudioFormat)iterator.next();
            if (TDebug.TraceAudioFileWriter) {
                TDebug.out(new StringBuffer().append("matching against format : ").append(audioFormat2).toString());
            }
            if (!AudioFormats.matches(audioFormat2, audioFormat)) continue;
            if (TDebug.TraceAudioFileWriter) {
                TDebug.out("<...succeeded.");
            }
            return true;
        }
        if (TDebug.TraceAudioFileWriter) {
            TDebug.out("< ... failed");
        }
        return false;
    }

    protected abstract AudioOutputStream getAudioOutputStream(AudioFormat var1, long var2, AudioFileFormat.Type var4, TDataOutputStream var5) throws IOException;

    private AudioFormat findConvertableFormat(AudioFormat audioFormat, AudioFileFormat.Type type) {
        if (TDebug.TraceAudioFileWriter) {
            TDebug.out(new StringBuffer().append("TAudioFileWriter.findConvertableFormat(): input format: ").append(audioFormat).toString());
        }
        if (!this.isFileTypeSupported(type)) {
            if (TDebug.TraceAudioFileWriter) {
                TDebug.out("< input file type is not supported.");
            }
            return null;
        }
        AudioFormat.Encoding encoding = audioFormat.getEncoding();
        if ((encoding.equals(PCM_SIGNED) || encoding.equals(PCM_UNSIGNED)) && audioFormat.getSampleSizeInBits() == 8) {
            AudioFormat audioFormat2 = this.convertFormat(audioFormat, true, false);
            if (TDebug.TraceAudioFileWriter) {
                TDebug.out(new StringBuffer().append("trying output format: ").append(audioFormat2).toString());
            }
            if (this.isAudioFormatSupportedImpl(audioFormat2, type)) {
                if (TDebug.TraceAudioFileWriter) {
                    TDebug.out("< ... succeeded");
                }
                return audioFormat2;
            }
            audioFormat2 = this.convertFormat(audioFormat, false, true);
            if (TDebug.TraceAudioFileWriter) {
                TDebug.out(new StringBuffer().append("trying output format: ").append(audioFormat2).toString());
            }
            if (this.isAudioFormatSupportedImpl(audioFormat2, type)) {
                if (TDebug.TraceAudioFileWriter) {
                    TDebug.out("< ... succeeded");
                }
                return audioFormat2;
            }
            audioFormat2 = this.convertFormat(audioFormat, true, true);
            if (TDebug.TraceAudioFileWriter) {
                TDebug.out(new StringBuffer().append("trying output format: ").append(audioFormat2).toString());
            }
            if (this.isAudioFormatSupportedImpl(audioFormat2, type)) {
                if (TDebug.TraceAudioFileWriter) {
                    TDebug.out("< ... succeeded");
                }
                return audioFormat2;
            }
            if (TDebug.TraceAudioFileWriter) {
                TDebug.out("< ... failed");
            }
            return null;
        }
        if (encoding.equals(PCM_SIGNED) && (audioFormat.getSampleSizeInBits() == 16 || audioFormat.getSampleSizeInBits() == 24 || audioFormat.getSampleSizeInBits() == 32)) {
            AudioFormat audioFormat3 = this.convertFormat(audioFormat, false, true);
            if (TDebug.TraceAudioFileWriter) {
                TDebug.out(new StringBuffer().append("trying output format: ").append(audioFormat3).toString());
            }
            if (this.isAudioFormatSupportedImpl(audioFormat3, type)) {
                if (TDebug.TraceAudioFileWriter) {
                    TDebug.out("< ... succeeded");
                }
                return audioFormat3;
            }
            if (TDebug.TraceAudioFileWriter) {
                TDebug.out("< ... failed");
            }
            return null;
        }
        if (TDebug.TraceAudioFileWriter) {
            TDebug.out("< ... failed");
        }
        return null;
    }

    private AudioFormat convertFormat(AudioFormat audioFormat, boolean bl, boolean bl2) {
        AudioFormat.Encoding encoding = PCM_SIGNED;
        if (audioFormat.getEncoding().equals(PCM_UNSIGNED) != bl) {
            encoding = PCM_UNSIGNED;
        }
        return new AudioFormat(encoding, audioFormat.getSampleRate(), audioFormat.getSampleSizeInBits(), audioFormat.getChannels(), audioFormat.getFrameSize(), audioFormat.getFrameRate(), audioFormat.isBigEndian() ^ bl2);
    }
}

