REBOL [
   Title:   "Feedback Submitter"
   Date:    13-Jan-1999
   Author:  "Bohdan Lechnowsky"
   File:    %feedback.r
   Email:   bo@rebol.com
   Purpose: {
      To send feedback from REBOL users to REBOL Technologies.
   }
]

menu: [
   ["Change Feedback Category" [feedback-type: feedback]]
   ["Change Name" [change-name true]]
   ["Change Email Address" [change-email true]]
   ["Change Date/Time" [change-date true]]
   ["Change Description" [desc: change-desc]]
   ["Change Subject Line" [subj: change-subject]]
   ["Send It!" [send-it]]
   ["Quit" [halt]]
]

feedback-func: func [] [
   print newline
   while [not integer? (feedback-choice: load ask trim
      {^/FEEDBACK CATEGORY
      ====================
      1 > Bug report
      2 > General Question
      3 > Enhancement idea
      4 > Comment/Praise
      5 > Documentation note
      6 > Other
      7 > Quit

      -> })] [print "^/Please enter the number of your selection!^/"]
   if feedback-choice > 6 [halt]
   if feedback-choice < 1 [feedback-choice: 1]
   return pick [ "[BUG]" "[SUPPORT]" "[ENHANCEMENT]" "[COMMENT]" "[DOC]" "[OTHER]" ] feedback-choice
]

change-name: func [change] [
   either any [(none? name: system/user/name) (change)] [
      name: ask "^/Please enter your name: "
   ][
      print ["^/Your name:" name]
   ]
]

change-email: func [change] [
   either any [(none? email: system/user/email) (change)] [
      system/user/email: email: ask "^/Enter your email address: "
   ][
      print ["^/Your email address: " email]
   ]
]

change-date: func [change] [
   prin {^/Date/Time }
   either change [
      until [
         all [(not error? try [time: load ask "DD/MM/YY/hh:mm>"]) (date? time)]
      ]
   ][
      print time: now
   ]
]

change-desc: func [] [
   print newline
   print trim {^/--------------------------------------------------
                    Please enter your feedback.

                    *** THE FIRST LINE WILL BE USED AS THE  ***
                    ***       FEEDBACK'S SUBJECT LINE       ***

                    Enter .. (two dots) on a new line
                    to delete the previous line and a . (dot)
                    on its own line to finish the description.
                    --------------------------------------------------}

   reprint: func [] [
      output: make string! 1
      print "^/-----"
      foreach line lines [append output reduce [line newline]]
   ]

   lines: make block! 1
   until [
      append lines input
      if (last lines) = ".." [
         clear back back tail lines
         reprint
         prin output
      ]
      if positive? length? lines [
         (last lines) = "."
      ]
   ]

   clear back tail lines

   either positive? length? lines [
      subj: first lines
   ][
      subj: "(No Subject)"
   ]
   insert head lines {^/}

   reprint
   return output
]

change-subject: func [] [
   ask "^/Please enter the subject: "
]


send-it: func [/local header] [
   header: make system/standard/email [
      from: :email
      subject: append copy feedback-type to-string reduce [" " copy/part subj 40]
      organization: "REBOL 2.0 User"
   ]

   if (none? system/schemes/smtp/host) and (none? defserv: system/schemes/default/host) [
      either found? defserv [
         print "^/*** Setting your SMTP server to your default server address ***"
         system/schemes/smtp/host: defserv
      ][
         until [
            system/schemes/smtp/host: ask "Please enter your SMTP server (i.e. mail.domain.com): "
            correct: ask "Is this correct (yes/no)? "
            any [(correct = "yes") (correct = "y")]
         ]
      ]
   ]
   send/header feedback@rebol.com mold reduce [
      name
      email
      system/version
      time
      desc
   ] header

   print "^/Message sent!"

   print newline
]

display: func [] [
   print newline
   prin line: {************************************************************}
   print reduce [{^/   CATEGORY: } feedback-type
                 {^/       NAME: } name
                 {^/      EMAIL: } email
                 {^/    VERSION: } system/version
                 {^/       DATE: } time
                 {^/    SUBJECT: } subj
                 {^/DESCRIPTION:^/} desc]
   print line
]

feedback-type: feedback-func
change-name false
change-email false
print ["^/Using REBOL v" system/version]
change-date false
desc: change-desc

print {^/You now have the option to send this message or edit the message fields.}
either (ask {^/(S)end this message or (E)dit it (s/e)? }) = "s" [
   send-it
][
   until [
      display

      until [
         print {^/^/Enter the number of your selection:}
         index: 0
         prin newline
         foreach item menu [
            index: index + 1
            print [index ">" first item]
         ]
         prin "^/-> "
         integer? choice: load input
      ]
      either (choice > index) or (choice < 1) [
         print "^/*** INVALID OPTION ***"
      ][
         reduce second pick menu choice
      ]

      (choice >= (index - 1))
   ]
]

print newline
print trim {^/--------------------------------------------------
                 Thank you for submitting this feedback.
                 It will help us to provide you with an even higher
                 quality product in the future.
                 --------------------------------------------------
                 ^/^/}
