/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.internal.orbutil;

import com.sun.corba.se.internal.corba.ORB;
import com.sun.corba.se.internal.core.ORBVersion;
import com.sun.corba.se.internal.core.ORBVersionImpl;
import com.sun.corba.se.internal.orbutil.ORBClassLoader;
import com.sun.corba.se.internal.orbutil.ValueHandlerImpl_1_3;
import com.sun.corba.se.internal.orbutil.ValueHandlerImpl_1_3_1;
import java.lang.reflect.Field;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Properties;
import javax.rmi.CORBA.Util;
import javax.rmi.CORBA.ValueHandler;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.DATA_CONVERSION;
import org.omg.CORBA.StructMember;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.TypeCodePackage.BadKind;
import org.omg.CORBA.TypeCodePackage.Bounds;
import org.omg.CORBA.UNKNOWN;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.OutputStream;

public final class ORBUtility {
    private static StructMember[] members = null;
    private static final Hashtable exceptionClassNames = new Hashtable();
    private static final Hashtable exceptionRepositoryIds = new Hashtable();

    static {
        exceptionClassNames.put("IDL:omg.org/CORBA/BAD_CONTEXT:1.0", "org.omg.CORBA.BAD_CONTEXT");
        exceptionClassNames.put("IDL:omg.org/CORBA/BAD_INV_ORDER:1.0", "org.omg.CORBA.BAD_INV_ORDER");
        exceptionClassNames.put("IDL:omg.org/CORBA/BAD_OPERATION:1.0", "org.omg.CORBA.BAD_OPERATION");
        exceptionClassNames.put("IDL:omg.org/CORBA/BAD_PARAM:1.0", "org.omg.CORBA.BAD_PARAM");
        exceptionClassNames.put("IDL:omg.org/CORBA/BAD_TYPECODE:1.0", "org.omg.CORBA.BAD_TYPECODE");
        exceptionClassNames.put("IDL:omg.org/CORBA/COMM_FAILURE:1.0", "org.omg.CORBA.COMM_FAILURE");
        exceptionClassNames.put("IDL:omg.org/CORBA/DATA_CONVERSION:1.0", "org.omg.CORBA.DATA_CONVERSION");
        exceptionClassNames.put("IDL:omg.org/CORBA/IMP_LIMIT:1.0", "org.omg.CORBA.IMP_LIMIT");
        exceptionClassNames.put("IDL:omg.org/CORBA/INTF_REPOS:1.0", "org.omg.CORBA.INTF_REPOS");
        exceptionClassNames.put("IDL:omg.org/CORBA/INTERNAL:1.0", "org.omg.CORBA.INTERNAL");
        exceptionClassNames.put("IDL:omg.org/CORBA/INV_FLAG:1.0", "org.omg.CORBA.INV_FLAG");
        exceptionClassNames.put("IDL:omg.org/CORBA/INV_IDENT:1.0", "org.omg.CORBA.INV_IDENT");
        exceptionClassNames.put("IDL:omg.org/CORBA/INV_OBJREF:1.0", "org.omg.CORBA.INV_OBJREF");
        exceptionClassNames.put("IDL:omg.org/CORBA/MARSHAL:1.0", "org.omg.CORBA.MARSHAL");
        exceptionClassNames.put("IDL:omg.org/CORBA/NO_MEMORY:1.0", "org.omg.CORBA.NO_MEMORY");
        exceptionClassNames.put("IDL:omg.org/CORBA/FREE_MEM:1.0", "org.omg.CORBA.FREE_MEM");
        exceptionClassNames.put("IDL:omg.org/CORBA/NO_IMPLEMENT:1.0", "org.omg.CORBA.NO_IMPLEMENT");
        exceptionClassNames.put("IDL:omg.org/CORBA/NO_PERMISSION:1.0", "org.omg.CORBA.NO_PERMISSION");
        exceptionClassNames.put("IDL:omg.org/CORBA/NO_RESOURCES:1.0", "org.omg.CORBA.NO_RESOURCES");
        exceptionClassNames.put("IDL:omg.org/CORBA/NO_RESPONSE:1.0", "org.omg.CORBA.NO_RESPONSE");
        exceptionClassNames.put("IDL:omg.org/CORBA/OBJ_ADAPTER:1.0", "org.omg.CORBA.OBJ_ADAPTER");
        exceptionClassNames.put("IDL:omg.org/CORBA/INITIALIZE:1.0", "org.omg.CORBA.INITIALIZE");
        exceptionClassNames.put("IDL:omg.org/CORBA/PERSIST_STORE:1.0", "org.omg.CORBA.PERSIST_STORE");
        exceptionClassNames.put("IDL:omg.org/CORBA/TRANSIENT:1.0", "org.omg.CORBA.TRANSIENT");
        exceptionClassNames.put("IDL:omg.org/CORBA/UNKNOWN:1.0", "org.omg.CORBA.UNKNOWN");
        exceptionClassNames.put("IDL:omg.org/CORBA/OBJECT_NOT_EXIST:1.0", "org.omg.CORBA.OBJECT_NOT_EXIST");
        exceptionClassNames.put("IDL:omg.org/CORBA/INVALID_TRANSACTION:1.0", "org.omg.CORBA.INVALID_TRANSACTION");
        exceptionClassNames.put("IDL:omg.org/CORBA/TRANSACTION_REQUIRED:1.0", "org.omg.CORBA.TRANSACTION_REQUIRED");
        exceptionClassNames.put("IDL:omg.org/CORBA/TRANSACTION_ROLLEDBACK:1.0", "org.omg.CORBA.TRANSACTION_ROLLEDBACK");
        exceptionClassNames.put("IDL:omg.org/CORBA/INV_POLICY:1.0", "org.omg.CORBA.INV_POLICY");
        exceptionClassNames.put("IDL:omg.org/CORBA/TRANSACTION_UNAVAILABLE:1.0", "org.omg.CORBA.TRANSACTION_UNAVAILABLE");
        exceptionClassNames.put("IDL:omg.org/CORBA/TRANSACTION_MODE:1.0", "org.omg.CORBA.TRANSACTION_MODE");
        Enumeration enumeration = exceptionClassNames.keys();
        try {
            while (enumeration.hasMoreElements()) {
                Object object = enumeration.nextElement();
                String string = (String)object;
                String string2 = (String)exceptionClassNames.get(string);
                exceptionRepositoryIds.put(string2, string);
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    private ORBUtility() {
    }

    public static int hexOf(char c2) {
        int n2 = c2 - 48;
        if (n2 >= 0 && n2 <= 9) {
            return n2;
        }
        n2 = c2 - 97 + 10;
        if (n2 >= 10 && n2 <= 15) {
            return n2;
        }
        n2 = c2 - 65 + 10;
        if (n2 >= 10 && n2 <= 15) {
            return n2;
        }
        throw new DATA_CONVERSION(1398079693, CompletionStatus.COMPLETED_NO);
    }

    public static void intToBytes(int n2, byte[] byArray, int n3) {
        byArray[n3++] = (byte)(n2 >>> 24 & 0xFF);
        byArray[n3++] = (byte)(n2 >>> 16 & 0xFF);
        byArray[n3++] = (byte)(n2 >>> 8 & 0xFF);
        byArray[n3++] = (byte)(n2 >>> 0 & 0xFF);
    }

    public static int bytesToInt(byte[] byArray, int n2) {
        int n3 = byArray[n2++] << 24 & 0xFF000000;
        int n4 = byArray[n2++] << 16 & 0xFF0000;
        int n5 = byArray[n2++] << 8 & 0xFF00;
        int n6 = byArray[n2++] << 0 & 0xFF;
        return n3 | n4 | n5 | n6;
    }

    public static int compareVersion(int[] nArray, int[] nArray2) {
        if (nArray == null) {
            nArray = new int[]{};
        }
        if (nArray2 == null) {
            nArray2 = new int[]{};
        }
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            if (i2 >= nArray2.length || nArray[i2] > nArray2[i2]) {
                return 1;
            }
            if (nArray[i2] >= nArray2[i2]) continue;
            return -1;
        }
        return nArray.length == nArray2.length ? 0 : -1;
    }

    public static boolean isForeignORB(ORB oRB) {
        if (oRB == null) {
            return false;
        }
        try {
            return oRB.getORBVersion().equals(ORBVersionImpl.FOREIGN);
        }
        catch (SecurityException securityException) {
            return false;
        }
    }

    public static boolean isLegacyORB(ORB oRB) {
        try {
            ORBVersion oRBVersion = oRB.getORBVersion();
            return oRBVersion.equals(ORBVersionImpl.OLD);
        }
        catch (SecurityException securityException) {
            return false;
        }
    }

    public void dprint(String string) {
        ORBUtility.dprint(this, string);
    }

    public static void throwNotSerializableForCorba(String string) {
        throw new BAD_PARAM(string, 1330446342, CompletionStatus.COMPLETED_MAYBE);
    }

    public static boolean isSystemException(String string) {
        String string2 = null;
        string2 = (String)exceptionClassNames.get(string);
        return string2 != null;
    }

    public static int[] parseVersion(String string) {
        int n2;
        int n3;
        if (string == null) {
            return new int[0];
        }
        char[] cArray = string.toCharArray();
        for (n3 = 0; n3 < cArray.length && (cArray[n3] < '0' || cArray[n3] > '9'); ++n3) {
            if (n3 != cArray.length) continue;
            return new int[0];
        }
        int n4 = 1;
        for (n2 = n3 + 1; n2 < cArray.length; ++n2) {
            if (cArray[n2] == '.') {
                ++n4;
                continue;
            }
            if (cArray[n2] < '0' || cArray[n2] > '9') break;
        }
        int[] nArray = new int[n4];
        for (int i2 = 0; i2 < n4; ++i2) {
            int n5 = string.indexOf(46, n3);
            if (n5 == -1 || n5 > n2) {
                n5 = n2;
            }
            nArray[i2] = n3 >= n5 ? 0 : Integer.parseInt(string.substring(n3, n5));
            n3 = n5 + 1;
        }
        return nArray;
    }

    public static String objectToString(Object object) {
        if (object == null) {
            return "null";
        }
        StringBuffer stringBuffer = new StringBuffer();
        Class clazz = object.getClass();
        Class clazz2 = clazz.getComponentType();
        if (object instanceof Properties) {
            Properties properties = (Properties)object;
            stringBuffer.append(clazz.getName());
            stringBuffer.append("(");
            Enumeration enumeration = properties.propertyNames();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                String string2 = properties.getProperty(string);
                stringBuffer.append(" ");
                stringBuffer.append(string);
                stringBuffer.append("=");
                stringBuffer.append(string2);
            }
            stringBuffer.append(" )");
            return stringBuffer.toString();
        }
        try {
            clazz.getDeclaredMethod("toString", null);
            return object.toString();
        }
        catch (Exception exception) {
            if (clazz2 == null) {
                Field[] fieldArray;
                try {
                    fieldArray = clazz.getFields();
                }
                catch (SecurityException securityException) {
                    return object.toString();
                }
                stringBuffer.append(clazz.getName());
                stringBuffer.append("(");
                for (int i2 = 0; i2 < fieldArray.length; ++i2) {
                    Field field = fieldArray[i2];
                    stringBuffer.append(" ");
                    stringBuffer.append(field.getName());
                    stringBuffer.append("=");
                    try {
                        Object object2 = field.get(object);
                        stringBuffer.append(ORBUtility.objectToString(object2));
                        continue;
                    }
                    catch (Exception exception2) {
                        stringBuffer.append("???");
                    }
                }
                stringBuffer.append(" )");
                return stringBuffer.toString();
            }
            stringBuffer.append(clazz2.getName());
            stringBuffer.append("[");
            if (clazz2 == Boolean.TYPE) {
                boolean[] blArray = (boolean[])object;
                stringBuffer.append(blArray.length);
                stringBuffer.append("](");
                for (int i3 = 0; i3 < blArray.length; ++i3) {
                    stringBuffer.append(" ");
                    stringBuffer.append(blArray[i3]);
                }
            } else if (clazz2 == Byte.TYPE) {
                byte[] byArray = (byte[])object;
                stringBuffer.append(byArray.length);
                stringBuffer.append("](");
                for (int i4 = 0; i4 < byArray.length; ++i4) {
                    stringBuffer.append(" ");
                    stringBuffer.append(byArray[i4]);
                }
            } else if (clazz2 == Short.TYPE) {
                short[] sArray = (short[])object;
                stringBuffer.append(sArray.length);
                stringBuffer.append("](");
                for (int i5 = 0; i5 < sArray.length; ++i5) {
                    stringBuffer.append(" ");
                    stringBuffer.append(sArray[i5]);
                }
            } else if (clazz2 == Integer.TYPE) {
                int[] nArray = (int[])object;
                stringBuffer.append(nArray.length);
                stringBuffer.append("](");
                for (int i6 = 0; i6 < nArray.length; ++i6) {
                    stringBuffer.append(" ");
                    stringBuffer.append(nArray[i6]);
                }
            } else if (clazz2 == Long.TYPE) {
                long[] lArray = (long[])object;
                stringBuffer.append(lArray.length);
                stringBuffer.append("](");
                for (int i7 = 0; i7 < lArray.length; ++i7) {
                    stringBuffer.append(" ");
                    stringBuffer.append(lArray[i7]);
                }
            } else if (clazz2 == Character.TYPE) {
                char[] cArray = (char[])object;
                stringBuffer.append(cArray.length);
                stringBuffer.append("](");
                for (int i8 = 0; i8 < cArray.length; ++i8) {
                    stringBuffer.append(" ");
                    stringBuffer.append(cArray[i8]);
                }
            } else if (clazz2 == Float.TYPE) {
                float[] fArray = (float[])object;
                stringBuffer.append(fArray.length);
                stringBuffer.append("](");
                for (int i9 = 0; i9 < fArray.length; ++i9) {
                    stringBuffer.append(" ");
                    stringBuffer.append(fArray[i9]);
                }
            } else if (clazz2 == Double.TYPE) {
                double[] dArray = (double[])object;
                stringBuffer.append(dArray.length);
                stringBuffer.append("](");
                for (int i10 = 0; i10 < dArray.length; ++i10) {
                    stringBuffer.append(" ");
                    stringBuffer.append(dArray[i10]);
                }
            } else {
                Object[] objectArray = (Object[])object;
                stringBuffer.append(objectArray.length);
                stringBuffer.append("](");
                for (int i11 = 0; i11 < objectArray.length; ++i11) {
                    stringBuffer.append(" ");
                    stringBuffer.append(ORBUtility.objectToString(objectArray[i11]));
                }
            }
            stringBuffer.append(" ]");
            return stringBuffer.toString();
        }
    }

    public static void dprint(Object object, String string) {
        System.out.println(object.getClass().getName() + "(" + Thread.currentThread() + "): " + string);
    }

    public static String classNameOf(String string) {
        String string2 = null;
        string2 = (String)exceptionClassNames.get(string);
        if (string2 == null) {
            string2 = "org.omg.CORBA.UNKNOWN";
        }
        return string2;
    }

    public static String repositoryIdOf(String string) {
        String string2 = (String)exceptionRepositoryIds.get(string);
        if (string2 == null) {
            string2 = "IDL:omg.org/CORBA/UNKNOWN:1.0";
        }
        return string2;
    }

    public static int compareVersion(String string, String string2) {
        return ORBUtility.compareVersion(ORBUtility.parseVersion(string), ORBUtility.parseVersion(string2));
    }

    public static void dprint(String string, String string2) {
        System.out.println(string + "(" + Thread.currentThread() + "): " + string2);
    }

    public static ValueHandler createValueHandler(ORB oRB) {
        if (oRB == null) {
            return Util.createValueHandler();
        }
        ORBVersion oRBVersion = oRB.getORBVersion();
        if (oRBVersion == null) {
            return Util.createValueHandler();
        }
        if (oRBVersion.equals(ORBVersionImpl.OLD)) {
            return new ValueHandlerImpl_1_3();
        }
        if (oRBVersion.equals(ORBVersionImpl.NEW)) {
            return new ValueHandlerImpl_1_3_1();
        }
        return Util.createValueHandler();
    }

    public static void insertSystemException(SystemException systemException, Any any) {
        OutputStream outputStream = any.create_output_stream();
        org.omg.CORBA.ORB oRB = outputStream.orb();
        String string = systemException.getClass().getName();
        String string2 = ORBUtility.repositoryIdOf(string);
        outputStream.write_string(string2);
        outputStream.write_long(systemException.minor);
        outputStream.write_long(systemException.completed.value());
        any.read_value(outputStream.create_input_stream(), ORBUtility.getSystemExceptionTypeCode(oRB, string2, string));
    }

    private static boolean isSystemExceptionTypeCode(TypeCode typeCode, org.omg.CORBA.ORB oRB) {
        StructMember[] structMemberArray = ORBUtility.systemExceptionMembers(oRB);
        try {
            return typeCode.kind().value() == 22 && typeCode.member_count() == 3 && typeCode.member_type(0).equal(structMemberArray[0].type) && typeCode.member_type(1).equal(structMemberArray[1].type) && typeCode.member_type(2).equal(structMemberArray[2].type);
        }
        catch (BadKind badKind) {
            return false;
        }
        catch (Bounds bounds) {
            return false;
        }
    }

    private static StructMember[] systemExceptionMembers(org.omg.CORBA.ORB oRB) {
        if (members == null) {
            members = new StructMember[3];
            ORBUtility.members[0] = new StructMember("id", oRB.create_string_tc(0), null);
            ORBUtility.members[1] = new StructMember("minor", oRB.get_primitive_tc(TCKind.tk_long), null);
            ORBUtility.members[2] = new StructMember("completed", oRB.get_primitive_tc(TCKind.tk_long), null);
        }
        return members;
    }

    public static SystemException extractSystemException(Any any) {
        InputStream inputStream = any.create_input_stream();
        org.omg.CORBA.ORB oRB = inputStream.orb();
        if (!ORBUtility.isSystemExceptionTypeCode(any.type(), oRB)) {
            return new UNKNOWN(1398079692, CompletionStatus.COMPLETED_MAYBE);
        }
        return ORBUtility.readSystemException(inputStream);
    }

    public static SystemException readSystemException(InputStream inputStream) {
        try {
            String string = ORBUtility.classNameOf(inputStream.read_string());
            SystemException systemException = (SystemException)ORBClassLoader.loadClass(string).newInstance();
            systemException.minor = inputStream.read_long();
            systemException.completed = CompletionStatus.from_int(inputStream.read_long());
            return systemException;
        }
        catch (Exception exception) {
            return new UNKNOWN(1398079693, CompletionStatus.COMPLETED_MAYBE);
        }
    }

    public static void writeSystemException(SystemException systemException, OutputStream outputStream) {
        String string = ORBUtility.repositoryIdOf(systemException.getClass().getName());
        outputStream.write_string(string);
        outputStream.write_long(systemException.minor);
        outputStream.write_long(systemException.completed.value());
    }

    public static String[] concatenateStringArrays(String[] stringArray, String[] stringArray2) {
        int n2;
        String[] stringArray3 = new String[stringArray.length + stringArray2.length];
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            stringArray3[n2] = stringArray[n2];
        }
        for (n2 = 0; n2 < stringArray2.length; ++n2) {
            stringArray3[n2 + stringArray.length] = stringArray2[n2];
        }
        return stringArray3;
    }

    public static void dprint(Object object, String string, Throwable throwable) {
        System.out.println(object.getClass().getName() + '(' + Thread.currentThread() + "): " + string);
        if (throwable != null) {
            throwable.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static TypeCode getSystemExceptionTypeCode(org.omg.CORBA.ORB oRB, String string, String string2) {
        Class clazz = TypeCode.class;
        synchronized (clazz) {
            return oRB.create_exception_tc(string, string2, ORBUtility.systemExceptionMembers(oRB));
        }
    }
}

