/*
 * Decompiled with CFR 0.152.
 */
package sun.security.tools;

import java.awt.Button;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.Point;
import java.awt.TextField;
import java.awt.Window;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.security.InvalidParameterException;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.text.MessageFormat;
import java.util.LinkedList;
import java.util.Vector;
import sun.security.provider.PolicyParser;
import sun.security.tools.AddEntryDoneButtonListener;
import sun.security.tools.AddPermButtonListener;
import sun.security.tools.AddPrinButtonListener;
import sun.security.tools.CancelButtonListener;
import sun.security.tools.ChangeKeyStoreOKButtonListener;
import sun.security.tools.ChildWindowListener;
import sun.security.tools.ConfirmRemovePolicyEntryOKButtonListener;
import sun.security.tools.EditPermButtonListener;
import sun.security.tools.EditPolicyPermOKButtonListener;
import sun.security.tools.EditPolicyPrinOKButtonListener;
import sun.security.tools.EditPrinButtonListener;
import sun.security.tools.NewPolicyPermOKButtonListener;
import sun.security.tools.NewPolicyPrinOKButtonListener;
import sun.security.tools.OverWriteFileOKButtonListener;
import sun.security.tools.PermissionActionsMenuListener;
import sun.security.tools.PermissionMenuListener;
import sun.security.tools.PermissionNameMenuListener;
import sun.security.tools.PolicyEntry;
import sun.security.tools.PolicyListListener;
import sun.security.tools.PolicyTool;
import sun.security.tools.PrincipalTypeMenuListener;
import sun.security.tools.RemovePermButtonListener;
import sun.security.tools.RemovePrinButtonListener;
import sun.security.tools.ToolWindow;
import sun.security.tools.UserSaveCancelButtonListener;
import sun.security.tools.UserSaveNoButtonListener;
import sun.security.tools.UserSaveYesButtonListener;

class ToolDialog
extends Dialog {
    private static final long serialVersionUID = -372244357011301190L;
    public static final int NOACTION = 0;
    public static final int QUIT = 1;
    public static final int NEW = 2;
    public static final int OPEN = 3;
    public static final String ALL_PERM_CLASS = "java.security.AllPermission";
    public static final String AUDIO_PERM_CLASS = "javax.sound.sampled.AudioPermission";
    public static final String AUTH_PERM_CLASS = "javax.security.auth.AuthPermission";
    public static final String AWT_PERM_CLASS = "java.awt.AWTPermission";
    public static final String DELEGATION_PERM_CLASS = "javax.security.auth.kerberos.DelegationPermission";
    public static final String FILE_PERM_CLASS = "java.io.FilePermission";
    public static final String LOG_PERM_CLASS = "java.util.logging.LoggingPermission";
    public static final String NET_PERM_CLASS = "java.net.NetPermission";
    public static final String PRIVCRED_PERM_CLASS = "javax.security.auth.PrivateCredentialPermission";
    public static final String PROP_PERM_CLASS = "java.util.PropertyPermission";
    public static final String REFLECT_PERM_CLASS = "java.lang.reflect.ReflectPermission";
    public static final String RUNTIME_PERM_CLASS = "java.lang.RuntimePermission";
    public static final String SECURITY_PERM_CLASS = "java.security.SecurityPermission";
    public static final String SERIAL_PERM_CLASS = "java.io.SerializablePermission";
    public static final String SERVICE_PERM_CLASS = "javax.security.auth.kerberos.ServicePermission";
    public static final String SOCK_PERM_CLASS = "java.net.SocketPermission";
    public static final String SQL_PERM_CLASS = "java.sql.SQLPermission";
    public static final String SSL_PERM_CLASS = "javax.net.ssl.SSLPermission";
    public static final String KERBEROS_PRIN_CLASS = "javax.security.auth.kerberos.KerberosPrincipal";
    public static final String NTDOM_PRIN_CLASS = "com.sun.security.auth.NTDomainPrincipal";
    public static final String NTSIDDOM_PRIN_CLASS = "com.sun.security.auth.NTSidDomainPrincipal";
    public static final String NTSIDGRP_PRIN_CLASS = "com.sun.security.auth.NTSidGroupPrincipal";
    public static final String NTSIDPRIMGRP_PRIN_CLASS = "com.sun.security.auth.NTSidPrimaryGroupPrincipal";
    public static final String NTSIDUSER_PRIN_CLASS = "com.sun.security.auth.NTSidUserPrincipal";
    public static final String NTUSER_PRIN_CLASS = "com.sun.security.auth.NTUserPrincipal";
    public static final String UNIXNUMGRP_PRIN_CLASS = "com.sun.security.auth.UnixNumericGroupPrincipal";
    public static final String UNIXNUMUSER_PRIN_CLASS = "com.sun.security.auth.UnixNumericUserPrincipal";
    public static final String UNIX_PRIN_CLASS = "com.sun.security.auth.UnixPrincipal";
    public static final String X500_PRIN_CLASS = "javax.security.auth.x500.X500Principal";
    public static final String PERM = PolicyTool.rb.getString("Permission:                                                       ");
    public static final String ALL_PERM = "AllPermission";
    public static final String AUDIO_PERM = "AudioPermission";
    public static final String AUTH_PERM = "AuthPermission";
    public static final String AWT_PERM = "AWTPermission";
    public static final String DELEGATION_PERM = "DelegationPermission";
    public static final String FILE_PERM = "FilePermission";
    public static final String LOG_PERM = "LoggingPermission";
    public static final String NET_PERM = "NetPermission";
    public static final String PRIVCRED_PERM = "PrivateCredentialPermission";
    public static final String PROPERTY_PERM = "PropertyPermission";
    public static final String REFLECT_PERM = "ReflectPermission";
    public static final String RUNTIME_PERM = "RuntimePermission";
    public static final String SECURITY_PERM = "SecurityPermission";
    public static final String SERIAL_PERM = "SerializablePermission";
    public static final String SERVICE_PERM = "ServicePermission";
    public static final String SOCKET_PERM = "SocketPermission";
    public static final String SQL_PERM = "SQLPermission";
    public static final String SSL_PERM = "SSLPermission";
    public static final String PRIN_TYPE = PolicyTool.rb.getString("Principal Type:");
    public static final String PRIN_NAME = PolicyTool.rb.getString("Principal Name:");
    public static final String KERBEROS_PRIN = "KerberosPrincipal";
    public static final String NTDOM_PRIN = "NTDomainPrincipal";
    public static final String NTSIDDOM_PRIN = "NTSidDomainPrincipal";
    public static final String NTSIDGRP_PRIN = "NTSidGroupPrincipal";
    public static final String NTSIDPRIMGRP_PRIN = "NTSidPrimaryGroupPrincipal";
    public static final String NTSIDUSER_PRIN = "NTSidUserPrincipal";
    public static final String NTUSER_PRIN = "NTUserPrincipal";
    public static final String UNIXNUMGRP_PRIN = "UnixNumericGroupPrincipal";
    public static final String UNIXNUMUSER_PRIN = "UnixNumericUserPrincipal";
    public static final String UNIX_PRIN = "UnixPrincipal";
    public static final String X500_PRIN = "X500Principal";
    public static final String PERM_NAME = PolicyTool.rb.getString("Target Name:                                                    ");
    public static final String[] AUDIO_TARGETS = new String[]{"play", "record"};
    public static final String[] AUTH_TARGETS = new String[]{"doAs", "doAsPrivileged", "getSubject", "getSubjectFromDomainCombiner", "setReadOnly", "modifyPrincipals", "modifyPublicCredentials", "modifyPrivateCredentials", "refreshCredential", "destroyCredential", "createLoginContext.<" + PolicyTool.rb.getString("name") + ">", "getLoginConfiguration", "setLoginConfiguration", "refreshLoginConfiguration"};
    public static final String[] AWT_TARGETS = new String[]{"accessClipboard", "accessEventQueue", "listenToAllAWTEvents", "showWindowWithoutWarningBanner", "readDisplayPixels", "createRobot", "fullScreenExclusive"};
    public static final String[] FILE_TARGETS = new String[]{"<<ALL FILES>>"};
    public static final String[] LOG_TARGETS = new String[]{"control"};
    public static final String[] NET_TARGETS = new String[]{"setDefaultAuthenticator", "requestPasswordAuthentication", "specifyStreamHandler"};
    public static final String[] REF_TARGETS = new String[]{"suppressAccessChecks"};
    public static final String[] RUN_TARGETS = new String[]{"usePolicy", "createClassLoader", "getClassLoader", "setContextClassLoader", "setSecurityManager", "createSecurityManager", "exitVM", "shutdownHooks", "setFactory", "setIO", "modifyThread", "stopThread", "modifyThreadGroup", "getProtectionDomain", "readFileDescriptor", "writeFileDescriptor", "loadLibrary.<" + PolicyTool.rb.getString("library name") + ">", "accessClassInPackage.<" + PolicyTool.rb.getString("package name") + ">", "defineClassInPackage.<" + PolicyTool.rb.getString("package name") + ">", "accessDeclaredMembers", "queuePrintJob"};
    public static final String[] SEC_TARGETS = new String[]{"createAccessControlContext", "getDomainCombiner", "getPolicy", "setPolicy", "getProperty.<" + PolicyTool.rb.getString("property name") + ">", "setProperty.<" + PolicyTool.rb.getString("property name") + ">", "insertProvider.<" + PolicyTool.rb.getString("provider name") + ">", "removeProvider.<" + PolicyTool.rb.getString("provider name") + ">", "setSystemScope", "setIdentityPublicKey", "setIdentityInfo", "addIdentityCertificate", "removeIdentityCertificate", "printIdentity", "clearProviderProperties.<" + PolicyTool.rb.getString("provider name") + ">", "putProviderProperty.<" + PolicyTool.rb.getString("provider name") + ">", "removeProviderProperty.<" + PolicyTool.rb.getString("provider name") + ">", "getSignerPrivateKey", "setSignerKeyPair"};
    public static final String[] SER_TARGETS = new String[]{"enableSubclassImplementation", "enableSubstitution"};
    public static final String[] SQL_TARGETS = new String[]{"setLog"};
    public static final String[] SSL_TARGETS = new String[]{"setHostnameVerifier", "getSSLSessionContext"};
    public static final String PERM_ACTIONS = PolicyTool.rb.getString("Actions:                                                             ");
    public static final String FILE_PERM_READ = "read";
    public static final String FILE_PERM_WRITE = "write";
    public static final String FILE_PERM_DELETE = "delete";
    public static final String FILE_PERM_EXECUTE = "execute";
    public static final String FILE_PERM_ALL = "read, write, delete, execute";
    public static final String PRIVCRED_PERM_READ = "read";
    public static final String SERVICE_PERM_INIT = "initiate";
    public static final String SERVICE_PERM_ACCEPT = "accept";
    public static final String SERVICE_PERM_ALL = "initiate, accept";
    public static final String PROP_PERM_READ = "read";
    public static final String PROP_PERM_WRITE = "write";
    public static final String PROP_PERM_ALL = "read, write";
    public static final String SOCKET_PERM_ACCEPT = "accept";
    public static final String SOCKET_PERM_CONNECT = "connect";
    public static final String SOCKET_PERM_LISTEN = "listen";
    public static final String SOCKET_PERM_RESOLVE = "resolve";
    public static final String SOCKET_PERM_ALL = "accept, connect, listen, resolve";
    public static final int OW_LABEL = 0;
    public static final int OW_OK_BUTTON = 1;
    public static final int OW_CANCEL_BUTTON = 2;
    public static final int PE_CODEBASE_LABEL = 0;
    public static final int PE_CODEBASE_TEXTFIELD = 1;
    public static final int PE_SIGNEDBY_LABEL = 2;
    public static final int PE_SIGNEDBY_TEXTFIELD = 3;
    public static final int PE_PANEL0 = 4;
    public static final int PE_ADD_PRIN_BUTTON = 0;
    public static final int PE_EDIT_PRIN_BUTTON = 1;
    public static final int PE_REMOVE_PRIN_BUTTON = 2;
    public static final int PE_PRIN_LABEL = 5;
    public static final int PE_PRIN_LIST = 6;
    public static final int PE_PANEL1 = 7;
    public static final int PE_ADD_PERM_BUTTON = 0;
    public static final int PE_EDIT_PERM_BUTTON = 1;
    public static final int PE_REMOVE_PERM_BUTTON = 2;
    public static final int PE_PERM_LIST = 8;
    public static final int PE_PANEL2 = 9;
    public static final int PE_CANCEL_BUTTON = 0;
    public static final int PE_DONE_BUTTON = 1;
    public static final int PRD_DESC_LABEL = 0;
    public static final int PRD_PRIN_CHOICE = 1;
    public static final int PRD_PRIN_TEXTFIELD = 2;
    public static final int PRD_NAME_LABEL = 3;
    public static final int PRD_NAME_TEXTFIELD = 4;
    public static final int PRD_CANCEL_BUTTON = 5;
    public static final int PRD_OK_BUTTON = 6;
    public static final int PD_DESC_LABEL = 0;
    public static final int PD_PERM_CHOICE = 1;
    public static final int PD_PERM_TEXTFIELD = 2;
    public static final int PD_NAME_CHOICE = 3;
    public static final int PD_NAME_TEXTFIELD = 4;
    public static final int PD_ACTIONS_CHOICE = 5;
    public static final int PD_ACTIONS_TEXTFIELD = 6;
    public static final int PD_SIGNEDBY_LABEL = 7;
    public static final int PD_SIGNEDBY_TEXTFIELD = 8;
    public static final int PD_CANCEL_BUTTON = 9;
    public static final int PD_OK_BUTTON = 10;
    public static final int CHANGE_KEYSTORE = 0;
    public static final int KSD_NAME_LABEL = 0;
    public static final int KSD_NAME_TEXTFIELD = 1;
    public static final int KSD_TYPE_LABEL = 2;
    public static final int KSD_TYPE_TEXTFIELD = 3;
    public static final int KSD_CANCEL_BUTTON = 4;
    public static final int KSD_OK_BUTTON = 5;
    public static final int USC_LABEL = 0;
    public static final int USC_PANEL = 1;
    public static final int USC_YES_BUTTON = 0;
    public static final int USC_NO_BUTTON = 1;
    public static final int USC_CANCEL_BUTTON = 2;
    public static final int CRPE_LABEL1 = 0;
    public static final int CRPE_LABEL2 = 1;
    private static final int PERMISSION = 0;
    private static final int PERMISSION_NAME = 1;
    private static final int PERMISSION_ACTIONS = 2;
    private static final int PERMISSION_SIGNEDBY = 3;
    private static final int PRINCIPAL_TYPE = 4;
    private static final int PRINCIPAL_NAME = 5;
    PolicyTool tool;
    ToolWindow tw;

    void displayConfirmRemovePolicyEntry() {
        Object object;
        List list = (List)this.tw.getComponent(5);
        int n2 = list.getSelectedIndex();
        PolicyEntry[] policyEntryArray = this.tool.getEntry();
        Point point = this.tw.getLocationOnScreen();
        this.setBounds(point.x + 25, point.y + 100, 600, 400);
        this.setLayout(new GridBagLayout());
        Label label = new Label(PolicyTool.rb.getString("Remove this Policy Entry?"));
        this.tw.addNewComponent(this, label, 0, 0, 0, 2, 1, 0.0, 0.0, 1, ToolWindow.BOTTOM_PADDING);
        label = new Label("Grant " + policyEntryArray[n2].codebaseToString());
        this.tw.addNewComponent(this, label, 1, 1, 1, 2, 1, 0.0, 0.0, 1);
        label = new Label(policyEntryArray[n2].principalsToString());
        this.tw.addNewComponent(this, label, 2, 1, 2, 2, 1, 0.0, 0.0, 1);
        Vector vector = policyEntryArray[n2].getGrantEntry().permissionEntries;
        for (int i2 = 0; i2 < vector.size(); ++i2) {
            object = (PolicyParser.PermissionEntry)vector.elementAt(i2);
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            ((PolicyParser.PermissionEntry)object).write(printWriter);
            String string = stringWriter.toString();
            label = new Label("    " + string.substring(0, string.indexOf(";") + 1));
            if (i2 == vector.size() - 1) {
                this.tw.addNewComponent(this, label, 3 + i2, 1, 3 + i2, 2, 1, 0.0, 0.0, 1, ToolWindow.BOTTOM_PADDING);
                continue;
            }
            this.tw.addNewComponent(this, label, 3 + i2, 1, 3 + i2, 2, 1, 0.0, 0.0, 1);
        }
        Button button = new Button(PolicyTool.rb.getString("Cancel"));
        button.addActionListener(new CancelButtonListener(this));
        this.tw.addNewComponent(this, button, 3 + vector.size(), 2, 3 + vector.size(), 1, 1, 0.0, 0.0, 3, ToolWindow.BOTTOM_PADDING);
        object = new Button(PolicyTool.rb.getString("OK"));
        ((Button)object).addActionListener(new ConfirmRemovePolicyEntryOKButtonListener(this.tool, this.tw, this));
        this.tw.addNewComponent(this, (Component)object, 4 + vector.size(), 1, 3 + vector.size(), 1, 1, 0.0, 0.0, 3, ToolWindow.BOTTOM_PADDING);
        this.pack();
        this.setVisible(true);
    }

    void displaySaveAsDialog(int n2) {
        FileDialog fileDialog = new FileDialog((Frame)this.tw, PolicyTool.rb.getString("Save As"), 1);
        fileDialog.setVisible(true);
        if (fileDialog.getFile() == null || fileDialog.getFile().equals("")) {
            return;
        }
        String string = new String(fileDialog.getDirectory() + fileDialog.getFile());
        fileDialog.dispose();
        File file = new File(string);
        if (file.exists()) {
            ToolDialog toolDialog = new ToolDialog(PolicyTool.rb.getString("Overwrite File"), this.tool, this.tw, true);
            toolDialog.displayOverWriteFileDialog(string, n2);
        } else {
            try {
                this.tool.savePolicy(string);
                MessageFormat messageFormat = new MessageFormat(PolicyTool.rb.getString("Policy successfully written to filename"));
                Object[] objectArray = new Object[]{string};
                this.tw.displayStatusDialog(null, messageFormat.format(objectArray));
                TextField textField = (TextField)this.tw.getComponent(1);
                textField.setText(string);
                this.tw.setVisible(true);
                this.userSaveContinue(this.tool, this.tw, this, n2);
            }
            catch (FileNotFoundException fileNotFoundException) {
                if (string == null || string.equals("")) {
                    this.tw.displayErrorDialog(null, new FileNotFoundException(PolicyTool.rb.getString("null filename")));
                } else {
                    MessageFormat messageFormat = new MessageFormat(PolicyTool.rb.getString("filename not found"));
                    Object[] objectArray = new Object[]{string};
                    this.tw.displayErrorDialog(null, new FileNotFoundException(messageFormat.format(objectArray)));
                }
            }
            catch (Exception exception) {
                this.tw.displayErrorDialog(null, exception);
            }
        }
    }

    void displayUserSave(int n2) {
        if (this.tool.modified) {
            Point point = this.tw.getLocationOnScreen();
            this.setBounds(point.x + 75, point.y + 100, 400, 150);
            this.setLayout(new GridBagLayout());
            Label label = new Label(PolicyTool.rb.getString("     Save changes?"));
            this.tw.addNewComponent(this, label, 0, 0, 0, 1, 1, 0.0, 0.0, 1, ToolWindow.BOTTOM_PADDING);
            Panel panel = new Panel();
            panel.setLayout(new GridBagLayout());
            Button button = new Button(PolicyTool.rb.getString("Yes"));
            button.addActionListener(new UserSaveYesButtonListener(this, this.tool, this.tw, n2));
            this.tw.addNewComponent(panel, button, 0, 0, 0, 1, 1, 0.0, 0.0, 3, ToolWindow.LR_PADDING);
            Button button2 = new Button(PolicyTool.rb.getString("No"));
            button2.addActionListener(new UserSaveNoButtonListener(this, this.tool, this.tw, n2));
            this.tw.addNewComponent(panel, button2, 1, 1, 0, 1, 1, 0.0, 0.0, 3, ToolWindow.LR_PADDING);
            Button button3 = new Button(PolicyTool.rb.getString("Cancel"));
            button3.addActionListener(new UserSaveCancelButtonListener(this));
            this.tw.addNewComponent(panel, button3, 2, 2, 0, 1, 1, 0.0, 0.0, 3, ToolWindow.LR_PADDING);
            this.tw.addNewComponent(this, panel, 1, 0, 1, 1, 1, 0.0, 0.0, 1);
            this.pack();
            this.setVisible(true);
        } else {
            this.userSaveContinue(this.tool, this.tw, this, n2);
        }
    }

    void keyStoreDialog(int n2) {
        Point point = this.tw.getLocationOnScreen();
        this.setBounds(point.x + 25, point.y + 100, 500, 200);
        this.setLayout(new GridBagLayout());
        if (n2 == 0) {
            Label label = new Label(PolicyTool.rb.getString("New KeyStore URL:"));
            this.tw.addNewComponent(this, label, 0, 0, 0, 1, 1, 0.0, 0.0, 1, ToolWindow.BOTTOM_PADDING);
            TextField textField = new TextField(this.tool.getKeyStoreName(), 30);
            this.tw.addNewComponent(this, textField, 1, 1, 0, 1, 1, 0.0, 0.0, 1, ToolWindow.BOTTOM_PADDING);
            label = new Label(PolicyTool.rb.getString("New KeyStore Type:"));
            this.tw.addNewComponent(this, label, 2, 0, 1, 1, 1, 0.0, 0.0, 1, ToolWindow.BOTTOM_PADDING);
            textField = new TextField(this.tool.getKeyStoreType(), 30);
            this.tw.addNewComponent(this, textField, 3, 1, 1, 1, 1, 0.0, 0.0, 1, ToolWindow.BOTTOM_PADDING);
            Button button = new Button(PolicyTool.rb.getString("Cancel"));
            button.addActionListener(new CancelButtonListener(this));
            this.tw.addNewComponent(this, button, 4, 1, 2, 1, 1, 0.0, 0.0, 3);
            Button button2 = new Button(PolicyTool.rb.getString("OK"));
            button2.addActionListener(new ChangeKeyStoreOKButtonListener(this.tool, this.tw, this));
            this.tw.addNewComponent(this, button2, 5, 0, 2, 1, 1, 0.0, 0.0, 3);
        }
        this.setVisible(true);
    }

    void displayPolicyEntryDialog(boolean bl2) {
        Serializable serializable;
        Serializable serializable2;
        Component component;
        int n2 = 0;
        PolicyEntry[] policyEntryArray = null;
        List list = new List(3, false);
        list.addActionListener(new EditPrinButtonListener(this.tool, this.tw, this, bl2));
        List list2 = new List(10, false);
        list2.addActionListener(new EditPermButtonListener(this.tool, this.tw, this, bl2));
        Point point = this.tw.getLocationOnScreen();
        this.setBounds(point.x + 75, point.y + 200, 650, 500);
        this.setLayout(new GridBagLayout());
        this.setResizable(false);
        if (bl2) {
            Writer writer;
            Object object;
            Object object2;
            policyEntryArray = this.tool.getEntry();
            component = (List)this.tw.getComponent(5);
            n2 = ((List)component).getSelectedIndex();
            serializable2 = policyEntryArray[n2].getGrantEntry().principals;
            for (int i2 = 0; i2 < ((LinkedList)serializable2).size(); ++i2) {
                String string = null;
                object2 = (PolicyParser.PrincipalEntry)((LinkedList)serializable2).get(i2);
                object = new StringWriter();
                writer = new PrintWriter((Writer)object);
                ((PolicyParser.PrincipalEntry)object2).write((PrintWriter)writer);
                string = ((StringWriter)object).toString();
                list.add(string);
            }
            serializable = policyEntryArray[n2].getGrantEntry().permissionEntries;
            for (int i3 = 0; i3 < ((Vector)serializable).size(); ++i3) {
                object2 = null;
                object = (PolicyParser.PermissionEntry)((Vector)serializable).elementAt(i3);
                writer = new StringWriter();
                PrintWriter printWriter = new PrintWriter(writer);
                ((PolicyParser.PermissionEntry)object).write(printWriter);
                if (File.separatorChar == '\\' && ((PolicyParser.PermissionEntry)object).permission.equals(FILE_PERM_CLASS)) {
                    ((PolicyParser.PermissionEntry)object).name = this.addSingleBackSlash(((PolicyParser.PermissionEntry)object).name);
                    object2 = this.addSingleBackSlash(((StringWriter)writer).toString());
                } else {
                    object2 = ((StringWriter)writer).toString();
                }
                object2 = ((String)object2).substring(0, ((String)object2).indexOf(";") + 1);
                list2.add((String)object2);
            }
        }
        component = new Label(PolicyTool.rb.getString("CodeBase:"));
        this.tw.addNewComponent(this, component, 0, 0, 0, 1, 1, 0.0, 0.0, 1);
        serializable2 = bl2 ? new TextField(policyEntryArray[n2].getGrantEntry().codeBase, 60) : new TextField(60);
        this.tw.addNewComponent(this, (Component)serializable2, 1, 1, 0, 1, 1, 0.0, 0.0, 1);
        component = new Label(PolicyTool.rb.getString("SignedBy:"));
        this.tw.addNewComponent(this, component, 2, 0, 1, 1, 1, 0.0, 0.0, 1);
        serializable2 = bl2 ? new TextField(policyEntryArray[n2].getGrantEntry().signedBy, 60) : new TextField(60);
        this.tw.addNewComponent(this, (Component)serializable2, 3, 1, 1, 1, 1, 0.0, 0.0, 1);
        serializable = new Panel();
        ((Container)serializable).setLayout(new GridBagLayout());
        Button button = new Button(PolicyTool.rb.getString("Add Principal"));
        button.addActionListener(new AddPrinButtonListener(this.tool, this.tw, this, bl2));
        this.tw.addNewComponent((Container)serializable, button, 0, 0, 0, 1, 1, 100.0, 0.0, 2);
        button = new Button(PolicyTool.rb.getString("Edit Principal"));
        button.addActionListener(new EditPrinButtonListener(this.tool, this.tw, this, bl2));
        this.tw.addNewComponent((Container)serializable, button, 1, 1, 0, 1, 1, 100.0, 0.0, 2);
        button = new Button(PolicyTool.rb.getString("Remove Principal"));
        button.addActionListener(new RemovePrinButtonListener(this.tool, this.tw, this, bl2));
        this.tw.addNewComponent((Container)serializable, button, 2, 2, 0, 1, 1, 100.0, 0.0, 2);
        this.tw.addNewComponent(this, (Component)serializable, 4, 1, 2, 1, 1, 0.0, 0.0, 2);
        component = new Label(PolicyTool.rb.getString("Principals:"));
        this.tw.addNewComponent(this, component, 5, 0, 3, 1, 1, 0.0, 0.0, 1, ToolWindow.BOTTOM_PADDING);
        this.tw.addNewComponent(this, list, 6, 1, 3, 3, 1, 0.0, 0.0, 1, ToolWindow.BOTTOM_PADDING);
        serializable = new Panel();
        ((Container)serializable).setLayout(new GridBagLayout());
        button = new Button(PolicyTool.rb.getString("  Add Permission"));
        button.addActionListener(new AddPermButtonListener(this.tool, this.tw, this, bl2));
        this.tw.addNewComponent((Container)serializable, button, 0, 0, 0, 1, 1, 100.0, 0.0, 2);
        button = new Button(PolicyTool.rb.getString("  Edit Permission"));
        button.addActionListener(new EditPermButtonListener(this.tool, this.tw, this, bl2));
        this.tw.addNewComponent((Container)serializable, button, 1, 1, 0, 1, 1, 100.0, 0.0, 2);
        button = new Button(PolicyTool.rb.getString("Remove Permission"));
        button.addActionListener(new RemovePermButtonListener(this.tool, this.tw, this, bl2));
        this.tw.addNewComponent((Container)serializable, button, 2, 2, 0, 1, 1, 100.0, 0.0, 2);
        this.tw.addNewComponent(this, (Component)serializable, 7, 0, 4, 2, 1, 0.0, 0.0, 2, ToolWindow.LITE_BOTTOM_PADDING);
        this.tw.addNewComponent(this, list2, 8, 0, 5, 3, 1, 0.0, 0.0, 1, ToolWindow.BOTTOM_PADDING);
        serializable = new Panel();
        ((Container)serializable).setLayout(new GridBagLayout());
        button = new Button(PolicyTool.rb.getString("Cancel"));
        button.addActionListener(new CancelButtonListener(this));
        this.tw.addNewComponent((Container)serializable, button, 0, 1, 0, 1, 1, 0.0, 0.0, 3, ToolWindow.LR_PADDING);
        button = new Button(PolicyTool.rb.getString("Done"));
        button.addActionListener(new AddEntryDoneButtonListener(this.tool, this.tw, this, bl2));
        this.tw.addNewComponent((Container)serializable, button, 1, 0, 0, 1, 1, 0.0, 0.0, 3, ToolWindow.LR_PADDING);
        this.tw.addNewComponent(this, (Component)serializable, 9, 0, 6, 2, 1, 0.0, 0.0, 3);
        this.setVisible(true);
    }

    void displayPermissionDialog(boolean bl2, boolean bl3) {
        TextField textField;
        Serializable serializable;
        Object object;
        Object object2;
        Object object3;
        PolicyParser.PermissionEntry permissionEntry = null;
        List list = (List)this.getComponent(8);
        int n2 = list.getSelectedIndex();
        if (!bl2 && bl3) {
            object3 = this.parsePermissionString(list.getItem(n2), 0);
            object2 = this.parsePermissionString(list.getItem(n2), 1);
            object = this.parsePermissionString(list.getItem(n2), 2);
            permissionEntry = new PolicyParser.PermissionEntry((String)object3, (String)object2, (String)object);
            permissionEntry.signedBy = this.parsePermissionString(list.getItem(n2), 3);
        } else if (bl2 && bl3) {
            object3 = (List)this.tw.getComponent(5);
            int n3 = ((List)object3).getSelectedIndex();
            object = this.tool.getEntry();
            serializable = object[n3].getGrantEntry().permissionEntries;
            permissionEntry = (PolicyParser.PermissionEntry)((Vector)serializable).elementAt(n2);
        }
        object3 = new ToolDialog(PolicyTool.rb.getString("Permissions"), this.tool, this.tw, true);
        ((Window)object3).addWindowListener(new ChildWindowListener((ToolDialog)object3));
        object2 = this.getLocationOnScreen();
        ((Window)object3).setBounds(((Point)object2).x + 50, ((Point)object2).y + 100, 700, 250);
        ((Container)object3).setLayout(new GridBagLayout());
        ((Dialog)object3).setResizable(false);
        object = bl3 ? new Label(PolicyTool.rb.getString("  Edit Permission:")) : new Label(PolicyTool.rb.getString("  Add New Permission:"));
        this.tw.addNewComponent((Container)object3, (Component)object, 0, 0, 0, 1, 1, 0.0, 0.0, 1, ToolWindow.BOTTOM_PADDING);
        serializable = new Choice();
        ((Choice)serializable).add(PERM);
        ((Choice)serializable).add(ALL_PERM);
        ((Choice)serializable).add(AUDIO_PERM);
        ((Choice)serializable).add(AUTH_PERM);
        ((Choice)serializable).add(AWT_PERM);
        ((Choice)serializable).add(DELEGATION_PERM);
        ((Choice)serializable).add(FILE_PERM);
        ((Choice)serializable).add(LOG_PERM);
        ((Choice)serializable).add(NET_PERM);
        ((Choice)serializable).add(PRIVCRED_PERM);
        ((Choice)serializable).add(PROPERTY_PERM);
        ((Choice)serializable).add(REFLECT_PERM);
        ((Choice)serializable).add(RUNTIME_PERM);
        ((Choice)serializable).add(SECURITY_PERM);
        ((Choice)serializable).add(SERIAL_PERM);
        ((Choice)serializable).add(SERVICE_PERM);
        ((Choice)serializable).add(SOCKET_PERM);
        ((Choice)serializable).add(SQL_PERM);
        ((Choice)serializable).add(SSL_PERM);
        ((Choice)serializable).addItemListener(new PermissionMenuListener((ToolDialog)object3));
        this.tw.addNewComponent((Container)object3, (Component)serializable, 1, 0, 1, 1, 1, 0.0, 0.0, 1, ToolWindow.LR_PADDING);
        TextField textField2 = textField = bl3 ? new TextField(permissionEntry.permission, 30) : new TextField(30);
        if (bl3) {
            this.setPermissions(permissionEntry.permission, (Choice)serializable);
        }
        this.tw.addNewComponent((Container)object3, textField, 2, 1, 1, 1, 1, 0.0, 0.0, 1, ToolWindow.LR_PADDING);
        serializable = new Choice();
        ((Choice)serializable).add(PERM_NAME);
        ((Choice)serializable).addItemListener(new PermissionNameMenuListener((ToolDialog)object3));
        TextField textField3 = textField = bl3 ? new TextField(permissionEntry.name, 40) : new TextField(40);
        if (bl3) {
            this.setPermissionNames(permissionEntry.permission, (Choice)serializable, textField);
        }
        this.tw.addNewComponent((Container)object3, (Component)serializable, 3, 0, 2, 1, 1, 0.0, 0.0, 1, ToolWindow.LR_PADDING);
        this.tw.addNewComponent((Container)object3, textField, 4, 1, 2, 1, 1, 0.0, 0.0, 1, ToolWindow.LR_PADDING);
        serializable = new Choice();
        ((Choice)serializable).add(PERM_ACTIONS);
        ((Choice)serializable).addItemListener(new PermissionActionsMenuListener((ToolDialog)object3));
        TextField textField4 = textField = bl3 ? new TextField(permissionEntry.action, 40) : new TextField(40);
        if (bl3) {
            this.setPermissionActions(permissionEntry.permission, (Choice)serializable, textField);
        }
        this.tw.addNewComponent((Container)object3, (Component)serializable, 5, 0, 3, 1, 1, 0.0, 0.0, 1, ToolWindow.LR_PADDING);
        this.tw.addNewComponent((Container)object3, textField, 6, 1, 3, 1, 1, 0.0, 0.0, 1, ToolWindow.LR_PADDING);
        object = new Label(PolicyTool.rb.getString("Signed By:"));
        this.tw.addNewComponent((Container)object3, (Component)object, 7, 0, 4, 1, 1, 0.0, 0.0, 1, ToolWindow.LR_PADDING);
        textField = bl3 ? new TextField(permissionEntry.signedBy, 40) : new TextField(40);
        this.tw.addNewComponent((Container)object3, textField, 8, 1, 4, 1, 1, 0.0, 0.0, 1, ToolWindow.LR_PADDING);
        Button button = new Button(PolicyTool.rb.getString("Cancel"));
        button.addActionListener(new CancelButtonListener((ToolDialog)object3));
        this.tw.addNewComponent((Container)object3, button, 9, 1, 5, 1, 1, 0.0, 0.0, 3, ToolWindow.TOP_PADDING);
        Button button2 = new Button(PolicyTool.rb.getString("OK"));
        if (bl2) {
            button2.addActionListener(new EditPolicyPermOKButtonListener(this.tool, this.tw, this, (ToolDialog)object3, bl3));
        } else {
            button2.addActionListener(new NewPolicyPermOKButtonListener(this.tool, this.tw, this, (ToolDialog)object3, bl3));
        }
        this.tw.addNewComponent((Container)object3, button2, 10, 0, 5, 1, 1, 0.0, 0.0, 3, ToolWindow.TOP_PADDING);
        ((Dialog)object3).setVisible(true);
    }

    void displayPrincipalDialog(boolean bl2, boolean bl3) {
        Serializable serializable;
        Object object;
        Object object2;
        Object object3;
        PolicyParser.PrincipalEntry principalEntry = null;
        List list = (List)this.getComponent(6);
        int n2 = list.getSelectedIndex();
        if (!bl2 && bl3) {
            object3 = this.parsePrincipalString(list.getItem(n2), 4);
            object2 = this.parsePrincipalString(list.getItem(n2), 5);
            principalEntry = new PolicyParser.PrincipalEntry((String)object3, (String)object2);
        } else if (bl2 && bl3) {
            object3 = (List)this.tw.getComponent(5);
            int n3 = ((List)object3).getSelectedIndex();
            object = this.tool.getEntry();
            serializable = object[n3].getGrantEntry().principals;
            principalEntry = (PolicyParser.PrincipalEntry)((LinkedList)serializable).get(n2);
        }
        object3 = new ToolDialog(PolicyTool.rb.getString("Principals"), this.tool, this.tw, true);
        ((Window)object3).addWindowListener(new ChildWindowListener((ToolDialog)object3));
        object2 = this.getLocationOnScreen();
        ((Window)object3).setBounds(((Point)object2).x + 50, ((Point)object2).y + 100, 650, 190);
        ((Container)object3).setLayout(new GridBagLayout());
        ((Dialog)object3).setResizable(false);
        object = bl3 ? new Label(PolicyTool.rb.getString("  Edit Principal:")) : new Label(PolicyTool.rb.getString("  Add New Principal:"));
        this.tw.addNewComponent((Container)object3, (Component)object, 0, 0, 0, 1, 1, 0.0, 0.0, 1, ToolWindow.BOTTOM_PADDING);
        serializable = new Choice();
        ((Choice)serializable).add(PRIN_TYPE);
        ((Choice)serializable).add(KERBEROS_PRIN);
        ((Choice)serializable).add(NTDOM_PRIN);
        ((Choice)serializable).add(NTSIDDOM_PRIN);
        ((Choice)serializable).add(NTSIDGRP_PRIN);
        ((Choice)serializable).add(NTSIDPRIMGRP_PRIN);
        ((Choice)serializable).add(NTSIDUSER_PRIN);
        ((Choice)serializable).add(NTUSER_PRIN);
        ((Choice)serializable).add(UNIXNUMGRP_PRIN);
        ((Choice)serializable).add(UNIXNUMUSER_PRIN);
        ((Choice)serializable).add(UNIX_PRIN);
        ((Choice)serializable).add(X500_PRIN);
        ((Choice)serializable).addItemListener(new PrincipalTypeMenuListener((ToolDialog)object3));
        if (bl3) {
            this.setPrincipals(principalEntry.getPrincipalClass(), (Choice)serializable);
        }
        this.tw.addNewComponent((Container)object3, (Component)serializable, 1, 0, 1, 1, 1, 0.0, 0.0, 1, ToolWindow.LR_PADDING);
        TextField textField = bl3 ? new TextField(principalEntry.getDisplayClass(), 30) : new TextField(30);
        this.tw.addNewComponent((Container)object3, textField, 2, 1, 1, 1, 1, 0.0, 0.0, 1, ToolWindow.LR_PADDING);
        object = new Label(PRIN_NAME);
        textField = bl3 ? new TextField(principalEntry.getDisplayName(), 40) : new TextField(40);
        this.tw.addNewComponent((Container)object3, (Component)object, 3, 0, 2, 1, 1, 0.0, 0.0, 1, ToolWindow.LR_PADDING);
        this.tw.addNewComponent((Container)object3, textField, 4, 1, 2, 1, 1, 0.0, 0.0, 1, ToolWindow.LR_PADDING);
        Button button = new Button(PolicyTool.rb.getString("Cancel"));
        button.addActionListener(new CancelButtonListener((ToolDialog)object3));
        this.tw.addNewComponent((Container)object3, button, 5, 1, 3, 1, 1, 0.0, 0.0, 3, ToolWindow.TOP_PADDING);
        Button button2 = new Button(PolicyTool.rb.getString("OK"));
        if (bl2) {
            button2.addActionListener(new EditPolicyPrinOKButtonListener(this.tool, this.tw, this, (ToolDialog)object3, bl3));
        } else {
            button2.addActionListener(new NewPolicyPrinOKButtonListener(this.tool, this.tw, this, (ToolDialog)object3, bl3));
        }
        this.tw.addNewComponent((Container)object3, button2, 6, 0, 3, 1, 1, 0.0, 0.0, 3, ToolWindow.TOP_PADDING);
        ((Dialog)object3).setVisible(true);
    }

    void displayOverWriteFileDialog(String string, int n2) {
        Point point = this.tw.getLocationOnScreen();
        this.setBounds(point.x + 75, point.y + 100, 400, 150);
        this.setLayout(new GridBagLayout());
        MessageFormat messageFormat = new MessageFormat(PolicyTool.rb.getString("OK to overwrite existing file filename?"));
        Object[] objectArray = new Object[]{string};
        Label label = new Label(messageFormat.format(objectArray));
        this.tw.addNewComponent(this, label, 0, 0, 0, 2, 1, 0.0, 0.0, 1, ToolWindow.TOP_PADDING);
        Button button = new Button(PolicyTool.rb.getString("OK"));
        button.addActionListener(new OverWriteFileOKButtonListener(this.tool, this.tw, this, string, n2));
        this.tw.addNewComponent(this, button, 1, 0, 1, 1, 1, 0.0, 0.0, 3, ToolWindow.TOP_PADDING);
        button = new Button(PolicyTool.rb.getString("Cancel"));
        button.addActionListener(new CancelButtonListener(this));
        this.tw.addNewComponent(this, button, 2, 1, 1, 1, 1, 0.0, 0.0, 3, ToolWindow.TOP_PADDING);
        this.setVisible(true);
    }

    PolicyParser.PermissionEntry getPermFromDialog() {
        TextField textField = (TextField)this.getComponent(2);
        String string = new String(textField.getText().trim());
        textField = (TextField)this.getComponent(4);
        String string2 = null;
        if (!textField.getText().trim().equals("")) {
            string2 = new String(textField.getText().trim());
        }
        if (string.equals("") || !string.equals(ALL_PERM_CLASS) && string2 == null) {
            throw new InvalidParameterException(PolicyTool.rb.getString("Permission and Target Name must have a value"));
        }
        textField = (TextField)this.getComponent(6);
        String string3 = null;
        if (!textField.getText().trim().equals("")) {
            string3 = new String(textField.getText().trim());
        }
        textField = (TextField)this.getComponent(8);
        String string4 = null;
        if (!textField.getText().trim().equals("")) {
            string4 = new String(textField.getText().trim());
        }
        PolicyParser.PermissionEntry permissionEntry = new PolicyParser.PermissionEntry(string, string2, string3);
        permissionEntry.signedBy = string4;
        if (string4 != null) {
            String[] stringArray = this.tool.parseSigners(permissionEntry.signedBy);
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                try {
                    PublicKey publicKey = this.tool.getPublicKeyAlias(stringArray[i2]);
                    if (publicKey != null) continue;
                    MessageFormat messageFormat = new MessageFormat(PolicyTool.rb.getString("Warning: A public key for alias 'signers[i]' does not exist."));
                    Object[] objectArray = new Object[]{stringArray[i2]};
                    this.tool.warnings.addElement(messageFormat.format(objectArray));
                    this.tw.displayStatusDialog(this, messageFormat.format(objectArray));
                    continue;
                }
                catch (Exception exception) {
                    this.tw.displayErrorDialog((Window)this, exception);
                }
            }
        }
        return permissionEntry;
    }

    PolicyParser.PrincipalEntry getPrinFromDialog() {
        TextField textField = (TextField)this.getComponent(2);
        String string = new String(textField.getText().trim());
        textField = (TextField)this.getComponent(4);
        String string2 = new String(textField.getText().trim());
        if (string.equals("*")) {
            string = "WILDCARD_PRINCIPAL_CLASS";
        }
        if (string2.equals("*")) {
            string2 = "WILDCARD_PRINCIPAL_NAME";
        }
        PolicyParser.PrincipalEntry principalEntry = null;
        try {
            if (string.equals("WILDCARD_PRINCIPAL_CLASS") && !string2.equals("WILDCARD_PRINCIPAL_NAME")) {
                throw new Exception(PolicyTool.rb.getString("Cannot Specify Principal with a Wildcard Class without a Wildcard Name"));
            }
            if (string.equals("")) {
                string = "PolicyParser.REPLACE_NAME";
                this.tool.warnings.addElement("Warning: Principal name '" + string2 + "' specified without a Principal class.\n" + "\t'" + string2 + "' will be interpreted " + "as a key store alias.\n" + "\tThe final principal class will be " + X500_PRIN_CLASS + ".\n" + "\tThe final principal name will be " + "determined by the following:\n" + "\n" + "\tIf the key store entry identified by '" + string2 + "'\n" + "\tis a key entry, then the principal name will be\n" + "\tthe subject distinguished name from the first\n" + "\tcertificate in the entry's certificate chain.\n" + "\n" + "\tIf the key store entry identified by '" + string2 + "'\n" + "\tis a trusted certificate entry, then the\n" + "\tprincipal name will be the subject distinguished\n" + "\tname from the trusted public key certificate.");
                this.tw.displayStatusDialog(this, "'" + string2 + "' will be interpreted as a key " + "store alias.  View Warning Log for details.");
            } else if (string2.equals("")) {
                throw new Exception(PolicyTool.rb.getString("Cannot Specify Principal without a Name"));
            }
            principalEntry = new PolicyParser.PrincipalEntry(string, string2);
        }
        catch (Exception exception) {
            this.tw.displayErrorDialog((Window)this, exception);
        }
        return principalEntry;
    }

    PolicyEntry getPolicyEntryFromDialog() throws InvalidParameterException, MalformedURLException, NoSuchMethodException, ClassNotFoundException, InstantiationException, IllegalAccessException, InvocationTargetException, CertificateException, IOException, Exception {
        Object object;
        TextField textField = (TextField)this.getComponent(1);
        String string = null;
        if (!textField.getText().trim().equals("")) {
            string = new String(textField.getText().trim());
        }
        textField = (TextField)this.getComponent(3);
        String string2 = null;
        if (!textField.getText().trim().equals("")) {
            string2 = new String(textField.getText().trim());
        }
        PolicyParser.GrantEntry grantEntry = new PolicyParser.GrantEntry(string2, string);
        LinkedList linkedList = new LinkedList();
        List list = (List)this.getComponent(6);
        String[] stringArray = list.getItems();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            object = new PolicyParser.PrincipalEntry(this.parsePrincipalString(stringArray[i2], 4), this.parsePrincipalString(stringArray[i2], 5));
            linkedList.add(object);
        }
        grantEntry.principals = linkedList;
        Vector vector = new Vector();
        object = (List)this.getComponent(8);
        String[] stringArray2 = ((List)object).getItems();
        for (int i3 = 0; i3 < stringArray2.length; ++i3) {
            PolicyParser.PermissionEntry permissionEntry = new PolicyParser.PermissionEntry(this.parsePermissionString(stringArray2[i3], 0), this.parsePermissionString(stringArray2[i3], 1), this.parsePermissionString(stringArray2[i3], 2));
            permissionEntry.signedBy = this.parsePermissionString(stringArray2[i3], 3);
            vector.addElement(permissionEntry);
        }
        grantEntry.permissionEntries = vector;
        PolicyEntry policyEntry = new PolicyEntry(this.tool, grantEntry);
        return policyEntry;
    }

    void setPermissions(String string, Choice choice) {
        if (string.equals(ALL_PERM_CLASS)) {
            choice.select(ALL_PERM);
        } else if (string.equals(AUDIO_PERM_CLASS)) {
            choice.select(AUDIO_PERM);
        } else if (string.equals(AUTH_PERM_CLASS)) {
            choice.select(AUTH_PERM);
        } else if (string.equals(AWT_PERM_CLASS)) {
            choice.select(AWT_PERM);
        } else if (string.equals(DELEGATION_PERM_CLASS)) {
            choice.select(DELEGATION_PERM);
        } else if (string.equals(FILE_PERM_CLASS)) {
            choice.select(FILE_PERM);
        } else if (string.equals(LOG_PERM_CLASS)) {
            choice.select(LOG_PERM);
        } else if (string.equals(NET_PERM_CLASS)) {
            choice.select(NET_PERM);
        } else if (string.equals(PRIVCRED_PERM_CLASS)) {
            choice.select(PRIVCRED_PERM);
        } else if (string.equals(PROP_PERM_CLASS)) {
            choice.select(PROPERTY_PERM);
        } else if (string.equals(REFLECT_PERM_CLASS)) {
            choice.select(REFLECT_PERM);
        } else if (string.equals(RUNTIME_PERM_CLASS)) {
            choice.select(RUNTIME_PERM);
        } else if (string.equals(SECURITY_PERM_CLASS)) {
            choice.select(SECURITY_PERM);
        } else if (string.equals(SERIAL_PERM_CLASS)) {
            choice.select(SERIAL_PERM);
        } else if (string.equals(SERVICE_PERM_CLASS)) {
            choice.select(SERVICE_PERM);
        } else if (string.equals(SOCK_PERM_CLASS)) {
            choice.select(SOCKET_PERM);
        } else if (string.equals(SQL_PERM_CLASS)) {
            choice.select(SQL_PERM);
        } else if (string.equals(SSL_PERM_CLASS)) {
            choice.select(SSL_PERM);
        }
    }

    void setPrincipals(String string, Choice choice) {
        if (string.equals("WILDCARD_PRINCIPAL_CLASS")) {
            choice.select(PRIN_TYPE);
        } else if (string.equals(KERBEROS_PRIN_CLASS)) {
            choice.select(KERBEROS_PRIN);
        } else if (string.equals(NTDOM_PRIN_CLASS)) {
            choice.select(NTDOM_PRIN);
        } else if (string.equals(NTSIDDOM_PRIN_CLASS)) {
            choice.select(NTSIDDOM_PRIN);
        } else if (string.equals(NTSIDGRP_PRIN_CLASS)) {
            choice.select(NTSIDGRP_PRIN);
        } else if (string.equals(NTSIDPRIMGRP_PRIN_CLASS)) {
            choice.select(NTSIDPRIMGRP_PRIN);
        } else if (string.equals(NTSIDUSER_PRIN_CLASS)) {
            choice.select(NTSIDUSER_PRIN);
        } else if (string.equals(NTUSER_PRIN_CLASS)) {
            choice.select(NTUSER_PRIN);
        } else if (string.equals(UNIX_PRIN_CLASS)) {
            choice.select(UNIX_PRIN);
        } else if (string.equals(UNIXNUMGRP_PRIN_CLASS)) {
            choice.select(UNIXNUMGRP_PRIN);
        } else if (string.equals(UNIXNUMUSER_PRIN_CLASS)) {
            choice.select(UNIXNUMUSER_PRIN);
        } else if (string.equals(X500_PRIN_CLASS)) {
            choice.select(X500_PRIN);
        }
    }

    String addSingleBackSlash(String string) {
        String string2 = new String();
        int n2 = string.length();
        char[] cArray = new char[1];
        for (int i2 = 0; i2 < n2; ++i2) {
            cArray[0] = string.charAt(i2);
            string2 = string2.concat(new String(cArray));
            if (cArray[0] != '\\') continue;
            string2 = string2.concat(new String(cArray));
            if (string.charAt(i2 + 1) != '\\') continue;
            ++i2;
        }
        return string2;
    }

    private String parsePermissionString(String string, int n2) {
        string = string.substring(string.indexOf(" ") + 1);
        switch (n2) {
            case 0: {
                if (string.indexOf(ALL_PERM_CLASS) != -1) {
                    return new String(ALL_PERM_CLASS);
                }
                if (string.indexOf("\"") == -1) {
                    return string.substring(0, string.indexOf(";"));
                }
                return string.substring(0, string.indexOf("\"") - 1);
            }
            case 1: {
                if (string.indexOf(ALL_PERM_CLASS) != -1) {
                    return null;
                }
                if (string.indexOf("\"") == -1) {
                    return null;
                }
                return string.substring(string.indexOf("\"") + 1, string.indexOf("\"", string.indexOf("\"") + 1));
            }
            case 2: {
                if (string.indexOf(ALL_PERM_CLASS) != -1) {
                    return null;
                }
                if (string.indexOf("\"") == -1 || string.indexOf("\", \"") == -1) {
                    return null;
                }
                String string2 = string.substring(string.indexOf("\", \"") + 4, string.indexOf(";") - 1);
                if (string2.indexOf("signedBy") != -1) {
                    return string2.substring(0, string2.indexOf("signedBy") - 3);
                }
                return string2;
            }
            case 3: {
                if (string.indexOf("signedBy") == -1) {
                    return null;
                }
                return string.substring(string.indexOf("signedBy") + 10, string.indexOf(";") - 1);
            }
        }
        return null;
    }

    private String parsePrincipalString(String string, int n2) {
        int n3 = string.indexOf(" ");
        int n4 = string.indexOf(" ", n3 + 1);
        String string2 = null;
        switch (n2) {
            case 4: {
                string2 = string.substring(n3 + 1, n4);
                if (!string2.equals("*")) break;
                return "WILDCARD_PRINCIPAL_CLASS";
            }
            case 5: {
                string2 = string.substring(n4).trim();
                if (string2.indexOf("\"") != -1) {
                    return string2.substring(string2.indexOf("\"") + 1, string2.indexOf("\"", string2.indexOf("\"") + 1));
                }
                if (!string2.equals("*")) break;
                return "WILDCARD_PRINCIPAL_NAME";
            }
        }
        return string2;
    }

    void setPermissionActions(String string, Choice choice, TextField textField) {
        choice.removeAll();
        choice.add(PERM_ACTIONS);
        textField.setEditable(true);
        if (string.equals(FILE_PERM_CLASS)) {
            choice.add("read");
            choice.add("write");
            choice.add(FILE_PERM_DELETE);
            choice.add(FILE_PERM_EXECUTE);
            choice.add(FILE_PERM_ALL);
        } else if (string.equals(PRIVCRED_PERM_CLASS)) {
            choice.add("read");
        } else if (string.equals(PROP_PERM_CLASS)) {
            choice.add("read");
            choice.add("write");
            choice.add(PROP_PERM_ALL);
        } else if (string.equals(SERVICE_PERM_CLASS)) {
            choice.add(SERVICE_PERM_INIT);
            choice.add("accept");
            choice.add(SERVICE_PERM_ALL);
        } else if (string.equals(SOCK_PERM_CLASS)) {
            choice.add(SOCKET_PERM_LISTEN);
            choice.add(SOCKET_PERM_CONNECT);
            choice.add("accept");
            choice.add(SOCKET_PERM_RESOLVE);
            choice.add(SOCKET_PERM_ALL);
        } else {
            textField.setEditable(false);
        }
    }

    void setPermissionNames(String string, Choice choice, TextField textField) {
        choice.removeAll();
        choice.add(PERM_NAME);
        textField.setEditable(true);
        String[] stringArray = null;
        if (string.equals(ALL_PERM_CLASS)) {
            textField.setEditable(false);
        } else if (string.equals(AUDIO_PERM_CLASS)) {
            stringArray = AUDIO_TARGETS;
        } else if (string.equals(AUTH_PERM_CLASS)) {
            stringArray = AUTH_TARGETS;
        } else if (string.equals(AWT_PERM_CLASS)) {
            stringArray = AWT_TARGETS;
        } else if (!string.equals(DELEGATION_PERM_CLASS)) {
            if (string.equals(FILE_PERM_CLASS)) {
                stringArray = FILE_TARGETS;
            } else if (string.equals(LOG_PERM_CLASS)) {
                stringArray = LOG_TARGETS;
            } else if (string.equals(NET_PERM_CLASS)) {
                stringArray = NET_TARGETS;
            } else if (!string.equals(PRIVCRED_PERM_CLASS) && !string.equals(PROP_PERM_CLASS)) {
                if (string.equals(REFLECT_PERM_CLASS)) {
                    stringArray = REF_TARGETS;
                } else if (string.equals(RUNTIME_PERM_CLASS)) {
                    stringArray = RUN_TARGETS;
                } else if (string.equals(SECURITY_PERM_CLASS)) {
                    stringArray = SEC_TARGETS;
                } else if (string.equals(SERIAL_PERM_CLASS)) {
                    stringArray = SER_TARGETS;
                } else if (!string.equals(SERVICE_PERM_CLASS) && !string.equals(SOCK_PERM_CLASS)) {
                    if (string.equals(SQL_PERM_CLASS)) {
                        stringArray = SQL_TARGETS;
                    } else if (string.equals(SSL_PERM_CLASS)) {
                        stringArray = SSL_TARGETS;
                    }
                }
            }
        }
        if (stringArray != null) {
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                choice.add(stringArray[i2]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void userSaveContinue(PolicyTool policyTool, ToolWindow toolWindow, ToolDialog toolDialog, int n2) {
        switch (n2) {
            case 1: {
                toolWindow.setVisible(false);
                toolWindow.dispose();
                System.exit(0);
            }
            case 2: {
                try {
                    policyTool.openPolicy(null);
                }
                catch (Exception exception) {
                    policyTool.modified = false;
                    toolWindow.displayErrorDialog(null, exception);
                }
                List list = new List(40, false);
                list.addActionListener(new PolicyListListener(policyTool, toolWindow));
                toolWindow.replacePolicyList(list);
                TextField textField = (TextField)toolWindow.getComponent(1);
                textField.setText("");
                TextField textField2 = (TextField)toolWindow.getComponent(3);
                textField2.setText("");
                toolWindow.setVisible(true);
                break;
            }
            case 3: {
                Object[] objectArray;
                MessageFormat messageFormat;
                FileDialog fileDialog = new FileDialog((Frame)toolWindow, PolicyTool.rb.getString("Open"), 0);
                fileDialog.setVisible(true);
                if (fileDialog.getFile() == null || fileDialog.getFile().equals("")) {
                    return;
                }
                String string = new String(fileDialog.getDirectory() + fileDialog.getFile());
                try {
                    policyTool.openPolicy(string);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    if (string == null || string.equals("")) {
                        toolWindow.displayErrorDialog(null, new FileNotFoundException(PolicyTool.rb.getString("null filename")));
                    } else {
                        messageFormat = new MessageFormat(PolicyTool.rb.getString("filename not found"));
                        objectArray = new Object[]{string};
                        toolWindow.displayErrorDialog(null, new FileNotFoundException(messageFormat.format(objectArray)));
                    }
                }
                catch (PolicyParser.ParsingException parsingException) {
                    messageFormat = new MessageFormat(PolicyTool.rb.getString("Error parsing policy file policyFile: pppe.getMessage()"));
                    objectArray = new Object[]{string, parsingException.getMessage()};
                    toolWindow.displayErrorDialog(null, messageFormat.format(objectArray));
                    messageFormat = new MessageFormat(PolicyTool.rb.getString("Error: Could not open policy file, filename, because of parsing error: pppe.getMessage()"));
                    Object[] objectArray2 = new Object[]{string, parsingException.getMessage()};
                    policyTool.warnings.addElement(messageFormat.format(objectArray));
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    toolWindow.displayErrorDialog(null, new Exception(PolicyTool.rb.getString("Permission could not be mapped to an appropriate class")));
                }
                catch (Exception exception) {
                    toolWindow.displayErrorDialog(null, exception);
                }
                finally {
                    policyTool.modified = false;
                }
                List list = new List(40, false);
                list.addActionListener(new PolicyListListener(policyTool, toolWindow));
                PolicyEntry[] policyEntryArray = policyTool.getEntry();
                if (policyEntryArray != null) {
                    for (int i2 = 0; i2 < policyEntryArray.length; ++i2) {
                        list.add(policyEntryArray[i2].headerToString());
                    }
                }
                toolWindow.replacePolicyList(list);
                TextField textField = (TextField)toolWindow.getComponent(1);
                textField.setText(string);
                TextField textField3 = (TextField)toolWindow.getComponent(3);
                if (policyTool.getKeyStoreType() != null && policyTool.getKeyStoreType().length() > 0) {
                    textField3.setText(policyTool.getKeyStoreName() + ", " + policyTool.getKeyStoreType());
                } else {
                    textField3.setText(policyTool.getKeyStoreName());
                }
                toolWindow.setVisible(true);
                if (!policyTool.newWarning) break;
                toolWindow.displayStatusDialog(null, PolicyTool.rb.getString("Errors have occurred while opening the policy configuration.  View the Warning Log for more information."));
            }
        }
    }

    ToolDialog(String string, PolicyTool policyTool, ToolWindow toolWindow, boolean bl2) {
        super((Frame)toolWindow, bl2);
        this.setTitle(string);
        this.tool = policyTool;
        this.tw = toolWindow;
        this.addWindowListener(new ChildWindowListener(this));
    }
}

