/*
 * cmd.c
 *
 * Copyright (c) 2002 Dug Song <dugsong@monkey.org>
 *
 * $Id: cmd.c,v 1.1 2002/11/08 21:04:52 dugsong Exp $
 */

#include "w00gaim.h"

void
w00gaim_cmd_on(struct conversation *conv, struct w00ctx *ctx, char *who)
{
	char *enc, *text;
	int enclen;
	
	w00gaim_ctx_kexsend(ctx, &enc, &enclen);
	text = w00gaim_encode(enc, enclen);
	g_free(enc);
	serv_send_im(conv->gc, ctx->her_name, text, -1, 0);
	g_free(text);
}

void
w00gaim_cmd_status(struct conversation *conv, struct w00ctx *ctx, char *who)
{
	if (ctx != NULL) {
		w00gaim_notice(conv, "%d-bit %s encryption with %s %s",
		    EVP_CIPHER_key_length(ctx->cipher) * 8,
		    EVP_CIPHER_name(ctx->cipher), who,
		    (ctx->state == w00DONE) ? "enabled" : "requested");
	} else
		w00gaim_notice(conv, "encryption with %s disabled", who);
}

void
w00gaim_cmd_off(struct conversation *conv, struct w00ctx *ctx, char *who)
{
	if (ctx != NULL) {
		w00gaim_notice(conv, "encryption with %s %s", who,
		    ctx->state == w00DONE ? "disabled" : "aborted");
	} else
		w00gaim_notice(conv, "encrypted with %s disabled", who);
}

void
w00gaim_cmd_fp(struct conversation *conv, struct w00ctx *ctx,
    char *who)
{
	EVP_PKEY *pkey;
	
	if ((pkey = w00gaim_pkey_get(who, FALSE)) != NULL) {
		char *p = EVP_PKEY_fingerprint(pkey);
		w00gaim_notice(conv, "%s %d %s", who, EVP_PKEY_bits(pkey), p);
		EVP_PKEY_free(pkey);
		g_free(p);
	} else
		w00gaim_notice(conv, "no key for %s", who);
}

void
w00gaim_cmd_help(struct conversation *conv, struct w00ctx *ctx, char *who)
{
	write_to_conv(conv, "w00gaim commands:",
	    WFLAG_SYSTEM, NULL, time(NULL), -1);
	write_to_conv(conv, "/w00gaim fp <user> : print key fingerprint",
	    WFLAG_SYSTEM, NULL, time(NULL), -1);
	write_to_conv(conv, "/w00gaim on <cipher>: enable encryption",
	    WFLAG_SYSTEM, NULL, time(NULL), -1);
	write_to_conv(conv, "/w00gaim off : disable encryption",
	    WFLAG_SYSTEM, NULL, time(NULL), -1);
	write_to_conv(conv, "/w00gaim status : report encryption",
	    WFLAG_SYSTEM, NULL, time(NULL), -1);
}

