/*
 * im.c
 *
 * Copyright (c) 2002 Dug Song <dugsong@monkey.org>
 *
 * $Id: im.c,v 1.1 2002/11/08 21:04:52 dugsong Exp $
 */

#include "w00gaim.h"

void
w00gaim_new_conversation(char *who)
{
	struct conversation *conv = find_conversation(who);
	struct w00ctx *ctx = w00gaim_ctx_lookup(who);

	w00gaim_cmd_status(conv, ctx, who);
}

void
w00gaim_im_send(struct gaim_connection *gc, char *who, char **text, void *arg)
{
	struct conversation *conv = find_conversation(who);
	struct w00ctx *ctx = w00gaim_ctx_lookup(who);
	char *enc;
	int enclen;

	if (text == NULL || *text == NULL)
		return;
	else if (conv == NULL)
		conv = new_conversation(who);
	
	if (strncmp(*text, w00COMMAND, sizeof(w00COMMAND) - 1) == 0) {
		char *cmd = *text + (sizeof(w00COMMAND) - 1);
		
		if (strncmp(cmd, "on ", 3) == 0) {
			if (ctx != NULL && ctx->state == w00RCVD) {
				w00gaim_cmd_on(conv, ctx, who);
				w00gaim_ctx_kexsave(ctx);
				ctx->state = w00DONE;
				w00gaim_cmd_status(conv, ctx, who);
			} else {
				if (ctx != NULL)
					ctx = w00gaim_ctx_free(ctx);
				if ((ctx = w00gaim_ctx_new(gc->username, who)) == NULL) {
					w00gaim_notice(conv,
					    "couldn't load keys for %s and %s",
					    gc->username, who);
				} else if ((ctx->cipher =
				    EVP_get_cipherbyname(cmd + 3)) == NULL) {
					ctx = w00gaim_ctx_free(ctx);
					w00gaim_notice(conv,
					    "unknown cipher '%s'", cmd + 3);
				} else {
					w00gaim_cmd_on(conv, ctx, who);
					ctx->state = w00SENT;
					w00gaim_cmd_status(conv, ctx, who);
				}
			}
		} else if (strcmp(cmd, "off") == 0) {
			w00gaim_cmd_off(conv, ctx, who);
			ctx = w00gaim_ctx_free(ctx);
		} else if (strncmp(cmd, "fp ", 3) == 0) {
			w00gaim_cmd_fp(conv, ctx, cmd + 3);
		} else if (strcmp(cmd, "status") == 0) {
			w00gaim_cmd_status(conv, ctx, who);
		} else
			w00gaim_cmd_help(conv, ctx, who);
		
		gtk_editable_delete_text(GTK_EDITABLE(conv->entry), 0, -1);
		g_free(*text);
		*text = NULL;
	} else if (ctx != NULL && ctx->state == w00DONE) {
		/* Encrypt and send message. */
		write_to_conv(conv, *text, WFLAG_SEND, 0, time(NULL), -1);
		w00gaim_ctx_encrypt(ctx, &enc, &enclen, *text, strlen(*text));
		g_free(*text);
		*text = w00gaim_encode(enc, enclen);
		g_free(enc);
		serv_send_im(gc, who, *text, -1, 0);
		
		gtk_editable_delete_text(GTK_EDITABLE(conv->entry), 0, -1);
		g_free(*text);
		*text = NULL;
	}
}

void
w00gaim_im_recv(struct gaim_connection *gc, char **who, char **text,
    guint32 *flags, void *arg)
{
	struct conversation *conv = find_conversation(*who);
	struct w00ctx *ctx = w00gaim_ctx_lookup(*who);
	char *enc;
	int len, enclen;
	
	if (text == NULL || *text == NULL)
		return;
	else if (conv == NULL)
		conv = new_conversation(*who);
	
	if ((len = w00gaim_decode(*text)) > 4) {
		uint32_t type = ntohl(*(uint32_t *)(*text));
		
		if (type == w00MSG) {
			if (ctx == NULL || w00gaim_ctx_decrypt(ctx,
			    &enc, &enclen, *text, len) < 0) {
 				w00gaim_notice(conv, "can't decrypt message "
				    "from %s", *who);
				g_free(*text);
				*text = NULL;
			} else {
				g_free(*text);
				*text = enc;
			}
		} else if (type == w00KEX) {
			if (ctx != NULL && ctx->state == w00SENT) {
				if (w00gaim_ctx_kexrecv(ctx, *text, len) < 0) {
					ctx = w00gaim_ctx_free(ctx);
					w00gaim_notice(conv, "couldn't verify "
					    "request from %s", *who);
				} else {
					w00gaim_ctx_kexsave(ctx);
					ctx->state = w00DONE;
					w00gaim_cmd_status(conv, ctx, *who);
				}
			} else {
				if (ctx != NULL)
					ctx = w00gaim_ctx_free(ctx);
				
				if ((ctx = w00gaim_ctx_new(gc->username,
				    *who)) == NULL) {
					w00gaim_notice(conv, "couldn't load "
					    "keys for %s and %s", gc->username,
					    who);
				} else if (w00gaim_ctx_kexrecv(ctx, *text,
				    len) < 0) {
					ctx = w00gaim_ctx_free(ctx);
					w00gaim_notice(conv, "couldn't verify "
					    "request from %s", *who);
				} else {
					ctx->state = w00RCVD;
					w00gaim_cmd_status(conv, ctx, *who);
					w00gaim_notice(conv, 
					    "type '/w00gaim on %s' to enable",
					    EVP_CIPHER_name(ctx->cipher));
				}
			}
			g_free(*text);
			*text = NULL;
		}
	} else if (ctx != NULL) {
		w00gaim_notice(conv, "unencrypted message from %s: %s",
		    *who, *text);
		g_free(*text);
		*text = NULL;
	}
}

void
w00gaim_buddy_signoff(struct gaim_connection *gc, char *who)
{
	struct w00ctx *ctx = w00gaim_ctx_lookup(who);

	if (ctx != NULL) {
		w00gaim_ctx_remove(ctx);
		ctx = w00gaim_ctx_free(ctx);
	}
}
