/*
 * misc.c
 *
 * Copyright (c) 2002 Dug Song <dugsong@monkey.org>
 *
 * $Id: misc.c,v 1.1 2002/11/08 21:04:52 dugsong Exp $
 */

#include "w00gaim.h"

char *
w00gaim_encode(const char *buf, int buflen)
{
	EVP_ENCODE_CTX md;
	char *p;
	int i, len;

	len = (sizeof(w00PREFIX) + ((buflen * 4) / 3) + 8);
	p = g_malloc(len);
	len = sprintf(p, "%s", w00PREFIX);

	EVP_EncodeInit(&md);
	EVP_EncodeUpdate(&md, p + len, &i, (char *)buf, buflen);
	EVP_EncodeFinal(&md, p + len + i, &i);
	
	return (p);
}

int
w00gaim_decode(char *text)
{
	EVP_ENCODE_CTX md;
	char *p;
	int i, len, res;
	
	if (strncmp(text, w00PREFIX, sizeof(w00PREFIX) - 1) != 0)
		return (-1);
	
	p = text + (sizeof(w00PREFIX) - 1);

	EVP_DecodeInit(&md);
	res = EVP_DecodeUpdate(&md, text, &len, p, strlen(p));
	EVP_DecodeFinal(&md, text + len, &i);
	len += i;

	if (res < 0)
		return (-1);
	
	return (len);
}

EVP_PKEY *
w00gaim_pkey_get(const char *who, gboolean priv)
{
	FILE *fp;
	EVP_PKEY *pkey = NULL;
	char buf[BUFSIZ];
	
	snprintf(buf, sizeof(buf), "%s/.gaim/w00keys/%s%s",
	    g_get_home_dir(), who, priv ? "" : ".pub");
	
	if ((fp = fopen(buf, "r")) != NULL) {
		if (!priv) {
			X509 *cert = PEM_read_X509(fp, NULL, NULL, NULL);
			pkey = X509_get_pubkey(cert);
			X509_free(cert);
		} else
			pkey = PEM_read_PrivateKey(fp, NULL, NULL, NULL);
		fclose(fp);
	}
	return (pkey);
}

void
w00gaim_notice(struct conversation *conv, const char *fmt, ...)
{
	char buf[BUFSIZ];
	va_list ap;
	
	va_start(ap, fmt);
	vsnprintf(buf, sizeof(buf), fmt, ap);
	va_end(ap);

	write_to_conv(conv, buf, WFLAG_SYSTEM, NULL, time(NULL), -1);
}
