#!/bin/sh
#
# Generate keys for w00gaim.
#
# Copyright (c) 2002 Dug Song <dugsong@monkey.org>
#
# $Id: w00gaim-keygen.sh,v 1.4 2002/11/08 21:04:52 dugsong Exp $ 

if [ $# -ne 1 ]; then
    echo "Usage: `basename $0` username" >&2 && exit 1
fi

USERNAME=$1
TMPDIR=/tmp/w00gaim-keygen.$$

mkdir $TMPDIR || exit 1
trap 'rm -rf $TMPDIR; exit 1' 1 2 3 13 15
cd $TMPDIR

openssl genrsa -out $USERNAME 1024
#openssl req -new -subj /CN=$USERNAME -key $USERNAME -out $USERNAME.csr 2>&-
# XXX - can't rely on newer openssl req -subj feature...
cat <<EOF > w00gaim.cnf
[req]
default_bits		= 1024
distinguished_name	= req_distinguished_name
encrypt_key		= no
prompt			= no

[ req_distinguished_name ]
CN			= $USERNAME
EOF
openssl req -new -config w00gaim.cnf -key $USERNAME -out $USERNAME.csr 2>&-
openssl x509 -req -days 3650 -in $USERNAME.csr -signkey $USERNAME \
	-out $USERNAME.pub 2>&-

if [ $? -ne 0 ]; then
    echo "Couldn't generate new keypair" >&2
    rm -rf $TMPDIR
    exit 1
fi

chmod 400 $USERNAME
chmod 444 $USERNAME.pub

echo -n "Enter directory to save keys in ($HOME/.gaim/w00keys/): "
read DSTDIR
DSTDIR=${DSTDIR:-$HOME/.gaim/w00keys}

mkdir -p $DSTDIR

if mv -i $USERNAME $DSTDIR ; then
    echo "Your private key has been saved in $DSTDIR/$USERNAME"
fi
if mv -i $USERNAME.pub $DSTDIR ; then
    echo "Your public key has been saved in $DSTDIR/$USERNAME.pub"
fi

rm -rf $TMPDIR
