/*
 * w00gaim.c
 *
 * Copyright (c) 2002 Dug Song <dugsong@monkey.org>
 *
 * $Id: w00gaim.c,v 1.5 2002/11/08 21:04:52 dugsong Exp $
 */

#include "w00gaim.h"

char *
name(void)
{
	return ("w00gaim");
}

char *
description(void)
{
	return ("w00w00 encryption plugin");
}

int
gaim_plugin_init(void *handle)
{
	OpenSSL_add_all_algorithms();

	w00gaim_ctx_init();

	gaim_signal_connect(handle, event_new_conversation,
	    w00gaim_new_conversation, NULL);
	
	gaim_signal_connect(handle, event_im_send, w00gaim_im_send, NULL);
	gaim_signal_connect(handle, event_im_recv, w00gaim_im_recv, NULL);
	gaim_signal_connect(handle, event_buddy_signoff,
	    w00gaim_buddy_signoff, NULL);

	gaim_signal_connect(handle, event_chat_send, w00gaim_chat_send, NULL);
	gaim_signal_connect(handle, event_chat_recv, w00gaim_chat_recv, NULL);
	gaim_signal_connect(handle, event_chat_join, w00gaim_chat_join, NULL);
	gaim_signal_connect(handle, event_chat_leave,
	    w00gaim_chat_leave, NULL);
	
	return (0);
}

int
gaim_plugin_remove(void)
{
	w00gaim_ctx_destroy();
	
	return (0);
}
