/*
 * w00gaim.h
 *
 * Copyright (c) 2002 Dug Song <dugsong@monkey.org>
 *
 * $Id: w00gaim.h,v 1.1 2002/11/08 21:04:52 dugsong Exp $
 */

#ifndef w00GAIM_H
#define w00GAIM_H

#define GAIM_PLUGINS
#include "gaim.h"

#include <openssl/ssl.h>
#include <openssl/rand.h>

#include <string.h>

#include "cryptoaux.h"

typedef enum w00state {
	w00NONE,
	w00SENT,
	w00RCVD,
	w00DONE
} w00state_t;

typedef enum w00type {
	w00MSG,
	w00KEX
} w00type_t;

struct w00ctx {
	char			*her_name;
	DH			*my_dh;
	BIGNUM			*her_bn;
	EVP_PKEY		*my_pkey;
	EVP_PKEY		*her_pkey;
	const EVP_CIPHER	*cipher;
	EVP_CIPHER_CTX		 enc_ctx;
	EVP_CIPHER_CTX		 dec_ctx;
	w00state_t		 state;
};

#define w00PREFIX		"<w00gaim>"
#define w00COMMAND		"/w00gaim "

/* Message encoding. */
char	*w00gaim_encode(const char *buf, int len);
int	 w00gaim_decode(char *text);

/* Key management. */
EVP_PKEY *w00gaim_pkey_get(const char *who, gboolean priv);

/* Session management. */
void		 w00gaim_ctx_init(void);
struct w00ctx	*w00gaim_ctx_new(const char *my_name, const char *her_name);
struct w00ctx	*w00gaim_ctx_lookup(const char *who);
void		 w00gaim_ctx_remove(struct w00ctx *ctx);
struct w00ctx	*w00gaim_ctx_free(struct w00ctx *ctx);
void		 w00gaim_ctx_destroy(void);

int	 w00gaim_ctx_kexsend(struct w00ctx *ctx, char **buf, int *len);
int	 w00gaim_ctx_kexrecv(struct w00ctx *ctx, char *buf, int len);
int	 w00gaim_ctx_kexsave(struct w00ctx *ctx);

int	 w00gaim_ctx_encrypt(struct w00ctx *ctx, char **outbuf, int *len,
	    char *inbuf, int inlen);
int	 w00gaim_ctx_decrypt(struct w00ctx *ctx, char **outbuf, int *len,
	    char *inbuf, int inlen);

void	 w00gaim_notice(struct conversation *conv, const char *fmt, ...);

/* Interactive commands. */
void	 w00gaim_cmd_on(struct conversation *conv,
	    struct w00ctx *ctx, char *who);
void	 w00gaim_cmd_status(struct conversation *conv,
	    struct w00ctx *ctx, char *who);
void	 w00gaim_cmd_off(struct conversation *conv,
	    struct w00ctx *ctx, char *who);
void	 w00gaim_cmd_fp(struct conversation *conv,
	    struct w00ctx *ctx, char *who);
void	 w00gaim_cmd_help(struct conversation *conv,
	    struct w00ctx *ctx, char *who);

/* Event callbacks. */
void	 w00gaim_new_conversation(char *who);

void	 w00gaim_im_send(struct gaim_connection *gc,
	    char *who, char **text, void *arg);
void	 w00gaim_im_recv(struct gaim_connection *gc,
	    char **who, char **text, guint32 *flags, void *arg);
void	 w00gaim_buddy_signoff(struct gaim_connection *gc,
	    char *who);

void	 w00gaim_chat_send(struct gaim_connection *gc,
	    int id, char **text);
void	 w00gaim_chat_recv(struct gaim_connection *gc,
	    int id, char **who, char **text);
void	 w00gaim_chat_join(struct gaim_connection *gc,
	    int id, char *room);
void	 w00gaim_chat_leave(struct gaim_connection *gc,
	    int id);

#endif /* w00GAIM_H */
