/* ----- global data ----- */

#ifndef _DATA_H
#define _DATA_H

__BEGIN_DECLS

/* NOTE: these are defined in main.c */

extern int sockfd;               /* the main file descriptor      */

extern int klogfd;               /* /dev/klog fd                  */
extern int nullfd;               /* /dev/null for stdin           */

extern int  dblogfd;             /* where we log debbuging info   */
extern FILE *dblogfd1;           /* same file but FILE *          */

extern int  errlogfd;            /* where we write errors to      */
extern FILE *errlogfd1;          /* same file but FILE *          */

extern FILE *confd;              /* syslog config file            */
extern FILE *spoolfd;            /* where to spool to locally     */

extern int connected;            /* are we connected to the serv? */ 

extern int subID;                /* our sub-ID.. sent from server */

extern int spooling, didspool;   /* are we or were we spooling?   */
extern pid_t spoolpid;           /* pid of the spooling process   */

extern int pinging;              /* are we pinging or not?        */
extern volatile int streaming;   /* set to 1 when we're streaming */

extern int shmID;                /* key ID for shared memory      */
extern char *segptr;             /* ptr to shared mem buffer      */
extern char oldbuf[MAXSEGSIZE];  /* has old shared mem.. compares */

extern volatile pid_t chpid;    /* child's pid needed so we can kill it  */

extern int nfds;               /* fd's for select()    */
extern int funix;              /* the /dev/log unix fd */
extern fd_set readfds, unixm;  /* fd sets for select() */

extern int prevmsg; /* previous msg type  */

extern int repcount;
extern long prevlogtime;
extern char prevlogmsg[MAXLOGSIZE];

extern jmp_buf dospool, infoconn, reconnect, dropconn, doquit, sigdropconn;

extern volatile sig_atomic_t running; /* it isn't waiting for child  */
extern volatile sig_atomic_t newData; /* child knows it has new data */
extern volatile sig_atomic_t gotAlrm; /* alarm ran out...            */

extern struct msg logmsg;
 
extern int locPort; 
extern int curport;

extern struct sockaddr_in laddr, daddr;

extern int useServ; /* server # in list to start with #0 */
extern int curServ; /* index into server structure       */
extern struct server servList[MAXSERVNUM];

extern char SRSdir[MAXDNAMESIZE];

extern int gotInfoServ; /* we'ved connected to the info server */

extern struct passwd *pwd;

/* files the user can define */
extern char *errorFile, *dbFile, *spoolFile, *servListFile;

extern int prim;   /* connect to prim/sec server?   */

extern int silent; /* output connecting info or not */
extern int errors; /* was there an error or not?    */

extern volatile int debugging; /* output debugging info or not  */

extern int start;  /* 1 when first started   */
extern int done;   /* have we called quit()? */

extern int child;  /* used to determine if ping process is up */

extern int initing; /* are we initializing? */

extern int curlogfd; /* index into logfds[] */
extern struct logfd logfds[MAXLOGTYPES];

#ifndef NOSSL
extern SSL *sslconn;
extern SSL_CTX *sslctx;
#endif

__END_DECLS

#endif /* _DATA_H */
