/* ------ function declarations ------ */

#ifndef _FUNCTIONS_H
#define _FUNCTIONS_H

__BEGIN_DECLS

/* fix implicit declarations */
char *inet_ntoa __P((struct in_addr in));
unsigned long int inet_addr __P((const char *cp));

FILE *popen __P((const char *, const char *));
int pclose __P((FILE *));
/* ------------------------- */

/* startup code */
void init();       /* basic init.. setup longjmps.. etc. */
void setupFiles(); /* setup necessary files              */

void shrMemInit(); /* initialize shared memory           */
/* ------------ */

/* connecting/socket code */
void initConn __P((char *primserv, char *secserv));
int  connServ __P((char *host));

void setsockopts(int fd, int all); /* setup socket options */
/* ---------------------- */

/* configuration */
void config();                    /* reads from syslog config file  */
void printConfig();               /* output the configuration stats */
void sendSysConf();               /* send syslog.conf to the server */
/* ------------- */

/* I/O stuff (to/from server/client) */
void send_data __P((char *fmt, ...)); 
void recv_data __P((char *readbuf, int len)); 
/* --------------------------------- */


/* authentication */
void doAuth();         /* authenticate ourselves with server */
/* -------------- */

/* ssl functions */
#ifndef NOSSL
void makeSSLconn(); /* make SSL connection */
#endif
/* ------------- */

/* misc. functions */
void usage __P((char *progname)); /* output help/proper usage */

void procData();             /* process data from client.. */

void getVers();              /* check the current client/server vers  */
void getSubID();             /* get our sub-ID from the server...     */
void getServList();          /* get a list of servers (their IPs)     */

void getSRSuser();           /* get uid of SRS user in passwd file    */

void putServ __P((int serv, char *buf)); /* parses the IP address     */

void updateClient();         /* download a new client (from getVers)  */

void createDirs();           /* creates directories for SRS logs...   */

void getOkay();              /* get "OKAY" from server */

void doServer();             /* figure out what to do about serv */
void nextServer();           /* progress through the server list */

void daemonize();            /* daemonize ourselves */
void getArgs __P((int argc, char **argv)); /* get and parse args */

int  importInt  __P((char *value)); /* import int for cmd len */
char *exportInt __P((int value));   /* export int for cmd len */

void copyLogStruct __P((int srcstruct, int dststruct)); /* copy log struct */

void rbindport(); /* bind to the highest free reserved port */
/* --------------- */

/* convert facilities/priorities */
char *facValToName(int facility);
int facNameToVal(char *facility);

char *priValToName(int priority);
int priNameToVal(char *priority);
/* ----------------------------- */

/* streaming stuff */
void initStream();      /* init. streaming stuff like SYSLOGFILE  */
void doStreaming();     /* read data from SYSLOGFILE & send serv. */

void doLogging  __P((char *str));  /* parse system log message    */
/* --------------- */

/* spooling stuff */                 
void initSpool();   /* initalize spooling   */
void doSpooling();  /* do the spooling loop */ 

void forkSpool();   /* fork a spool process */
void killSpooler(); /* kill a spool process */

void write_spool __P((char *fmt, ...)); /* write logs to spool file */
/* -------------- */

/* ping stuff */
void startPings();        /* fork child to do pinging    */
void checkPings();        /* check for PINGs from server */

void killPinger();        /* kill the ping process       */
/* ------------- */

/* signal handlers (should all be self-explanatory) */
RETSIGTYPE restart __P((int sig));

RETSIGTYPE errTimeout   __P((int sig));
RETSIGTYPE verTimeout   __P((int sig));
RETSIGTYPE subIDTimeout __P((int sig));
RETSIGTYPE listTimeout  __P((int sig));
RETSIGTYPE okayTimeout  __P((int sig));

RETSIGTYPE gotNewData __P((int sig));
RETSIGTYPE startUp    __P((int sig));

RETSIGTYPE sighandler __P((int sig));

RETSIGTYPE dropinfoconn   __P((int sig));
RETSIGTYPE dropstreamconn __P((int stat));
/* --------------- */

/* parsing stuff */
void parseSysConf __P((char *str));  /* parse configuration options */

int  parseFac __P((char *str, int numfacs)); /* parse facility  */
void parsePri __P((char *str));              /* parse priority  */

void parseFile __P((char *str, int didfacs, int numfacs, \
                    char *fac, char *pri));

void parseRemHost   __P((char *str)); /* parse the remote hostname  */
void parseNamedPipe __P((char *str)); /* parse the named pipe name  */
/* ------------- */

/* debug/error stuff */
void debug(char *fmt, ...); /* reports debugging information */
void error(char *fmt, ...); /* logs errors to the error file */
/* ----------- */

/* disconnecting/exiting stuff */
void quit __P((int stat));            

void closeLogFiles(); /* close locally spooled files */

void freeSharedMem(); /* free/detach shared memmory  */
void freeLogTypes();  /* free the log types          */
void freeServList();  /* free the server list        */ 

void doKills();       /* kill parent/child procs     */
/* --------------------------- */

__END_DECLS

#endif /* _FUNCTIONS_H */
