#ifndef _HEADERS_H
#define _HEADERS_H

/* --------------------------------------------- */

#ifdef HAVE_CONFIG_H
#include <config.h> /* essential */
#endif

#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <stddef.h>
#include <stdarg.h>

#include <pwd.h>
#include <utmp.h>
#include <ctype.h>
#include <errno.h>
#include <fcntl.h>

#ifdef _PATH_HEQUIV
#undef _PATH_HEQUIV
#endif

#include <netdb.h>

#ifdef HAVE_PATHS_H
# include <paths.h>
#endif

#include <dirent.h>
#include <signal.h>
#include <setjmp.h>
#include <string.h>
#include <malloc.h>
#include <sys/param.h>

#ifdef HAVE_MEMORY_H
# include <memory.h>
#endif

#include <limits.h>

#ifdef SYSLOG_NAMES
# undef SYSLOG_NAMES
#endif

#include <syslog.h>

#ifdef HAVE_GETOPT_H
# include <getopt.h>
#endif

#ifdef HAVE_SYS_SELECT_H
# include <sys/select.h>
#endif

#ifdef HAVE_POSIX_OPT_H
#include <posix_opt.h>
#endif

#ifdef _POSIX_SAVED_IDS
# undef _POSIX_SAVED_IDS
#endif

#ifdef HAVE_SYS_STAT_H
# include <sys/stat.h>
#endif

#include <sys/un.h>

#ifdef HAVE_SYS_SHM_H
#include <sys/shm.h>
#endif

#include <sys/ipc.h>

#ifdef HAVE_ASM_PAGE_H
# include <asm/page.h>
#endif

#ifdef HAVE_KVM_H
#include <kvm.h>
#endif

#include <sys/stat.h>
#include <sys/types.h>
#include <netinet/in.h>
#include <sys/socket.h>

#ifdef BSD
# include <sys/uio.h>
#endif

#include <sys/utsname.h>

#ifdef HAVE_SYS_WAIT_H
# include <sys/wait.h>
#endif

#ifdef HAVE_UTIME_H
# include <utime.h>
#endif

#ifdef TIME_WITH_SYS_TIME
# include <time.h>
# include <sys/time.h>
#else
# ifdef HAVE_SYS_TIME_H
#  include <sys/time.h>
# else
#  include <time.h>
# endif
#endif

#ifdef HAVE_SYS_TIMES_H
# include <sys/times.h>
#endif

#ifdef HAVE_SYS_TIME_H
# include <sys/time.h>
#endif

#ifdef HAVE_SYS_STRLOG_H
#include <sys/strlog.h>
#endif

#ifdef HAVE_SYS_STROPTS_H
#include <sys/stropts.h>
#endif

/* ------------------------------- */

#ifndef __GNUC__
# define __asm__  asm
# define __unix__ unix
# define __vax__  vax
#endif

#ifndef __unix__
# error This is for Unix-derived operating systems only.
#endif

#ifdef __vax__
# error This will not compile on a VAX machine.
#endif

#ifndef __P
# ifdef STDC_HEADERS
#  define __P(x) x
# else
#  define __P(x) ()
# endif
#endif

/* _DECLS's */
#ifndef __cplusplus
# ifndef __BEGIN_DECLS
#  define __BEGIN_DECLS
# endif
# ifndef __END_DECLS
#  define __END_DECLS
# endif
#endif
/* -------- */

/* ------------------------------- */

/* SSL header files */
#ifndef NOSSL
# include "ssl.h"
     
#ifdef HAVE_DB_H
# include "db.h"
#endif

# include "err.h"
# include "pem.h"
#endif

/* ------------------------------- */

#include "macros.h"     /* macro definitions        */
#include "structs.h"    /* global data structures   */
#include "data.h"       /* global data declarations */
#include "functions.h"  /* function declarations    */

/* ------------------------------- */

#endif /* _HEADERS_H */
