/* ------------- our macros ------------- */

#ifndef _MACROS_H
#define _MACROS_H

__BEGIN_DECLS

/* marker macros */

#define BEGIN_HOUR 0
#define END_HOUR 23
#define END_MINUTE 59
#define END_SECOND 0

#define ID   "0001" /* client's identification  */
#define VER  "1"    /* current client version */

#define SRSMAILADDR "SRS@repsec.com"   /* report/request from here */

/* info servers... */
#define PRIMSERV "128.11.253.1"  /* enigma.repsec.com  */
#define SECSERV  "128.11.253.60" /* prodigy.repsec.com */

/* ----------------------------- */

/* file/directory information */
/* -------------------------- */

#ifdef _PATH_LOG
# define SYSLOGFILE _PATH_LOG          /* where syslogs come from */
#else
# define SYSLOGFILE "/dev/log"
#endif

/* this never changes does it? */
# define SUNLOGFILE "/devices/pseudo/log@0:log" /* /dev/log -> this */

#ifdef _PATH_KLOG
# define KLOGFILE _PATH_KLOG
#else
# define KLOGFILE "/dev/klog"
#endif

/* -------------------------- */

#ifdef _PATH_LOGCONF
# define CONFILE _PATH_LOGCONF
#else
# define CONFILE   "/etc/syslog.conf"  /* the SRS config file    */ 
#endif

#define USERFILE "/etc/SRS.user"

/* -------------------------- */

#ifndef UTMP_FILE
# ifdef UTMP_FILENAME
#  define UTMP_FILE UTMP_FILENAME
# else
#  ifdef _PATH_UTMP
#   define UTMP_FILE _PATH_UTMP
#  else
#   define UTMP_FILE "/etc/utmp"
#  endif
# endif
#endif

/* -------------------------- */

#define PATH_LOGPID "/etc/SRS.pid"

#define LOGFILE    "SRS.log"           /* file for syslogs */

#define ERRLOG     "error.log"         /* file to log errors to  */
#define DEBLOG     "debug.log"         /* file to output db info */
/* -------------------------- */

/* ssl macros */
#ifndef NOSSL
#define PARAMDIR "/var/log/SRS/certs"
#endif
/* ---------- */

/* miscellaneous stuff */
#ifndef INADDR_NONE
# define INADDR_NONE ((unsigned long int) 0xffffffff)
#endif

#ifndef IPPORT_RESERVED
#define IPPORT_RESERVED 1024
#endif

#define PORT 797     /* server port to conn to     */
#define LOCPORT 979  /* local port to bind to      */

#define INIT 100    /* used by INIT for setjmp()   */

#define ALL   1000  /* used for '*' facilities     */
#define NONE -1000  /* used for 'none' facilitites */

#define REPTIME 30          /* min time between duplicate msgs  */
#define PROBETIME 5 * 60    /* time of inactivity for KEEPALIVE */
/* -------------------------- */

#ifndef HAVE_MEMCPY
# define memcpy(d, s, n) bcopy((s), (d), (n))
#endif

#ifndef WIFEXITED
# define WIFEXITED(stat_val) (((stat_val) & 255) == 0)
#endif
/* -------------------------- */

/* ------ syslog stuff ------ */
#define LOG_NPRIORITIES 12 /* I think it's 12.. */

#ifndef LOG_FAC
# define LOG_FAC(p) (((p) & LOG_FACMASK) >> 2)
#endif

#ifndef LOG_PRI
# define LOG_PRI(p) ((p) & LOG_PRIMASK)
#endif

#ifndef LOG_MAKEPRI
# define LOG_MAKEPRI(fac, pri) (((fac) << 3) | (pri))
#endif

#ifndef INTERNAL_MARK
# define INTERNAL_MARK LOG_MAKEPRI(LOG_NFACILITIES, 0)
#endif

#ifndef INTERNAL_NOPRI
# define INTERNAL_NOPRI 0x10
#endif

#ifndef DEFUPRI
# ifdef SUN
#  define DEFUPRI (LOG_USER | LOG_INFO)
# else
#  define DEFUPRI (LOG_USER | LOG_NOTICE)
# endif
#endif

#ifndef DEFSPRI
# define DEFSPRI (LOG_KERN | LOG_CRIT)
#endif
/* -------------------------- */

/* --- I/O declarations. ---  */
#define STDIN  0
#define STDOUT 1
#define STDERR 2
/* -------------------------- */


/* maximum stuff */
/* ------------- */

/* the real # of combos = NFAC * NPRI * USERS, but that's too big */
#define MAXLOGTYPES LOG_NFACILITIES + LOG_NPRIORITIES + MAXNUMUSERS

#define MAXUSERNAME 8             /* max. length of a user name */
#define MAXNUMUSERS 20            /* max. # users to report to  */

#define MAXFNAMESIZE 256           /* max. length of a filename  */
#define MAXDNAMESIZE 256           /* max. length of a directory */

#ifndef PAGE_SIZE
#define PAGE_SIZE 4096
#endif

#define MAXSEGSIZE   PAGE_SIZE     /* max. size of shared mem. seg */

#define MAXREADSIZE  MAXSEGSIZE/2  /* max. number of bytes at once */
#define MAXWRITESIZE MAXSEGSIZE/2  /* max. number of bytes at once */

#define MAXLOGSIZE MAXREADSIZE

#define MAXSERVNUM 32              /* maximum # of servers in list */

/* -------------------------- */

/* time stuff */
#define MAXPAUSE  5               /* max. sleep() when waiting...  */
#define NORMPAUSE 2               /* avg. time to sleep() for wait */

#define MAXTIMEOUT 2 * 60         /* max # of seconds to wait...   */

#define MAXFLUSHTIME 30           /* "last message repeated" after */
/* -------------------------- */

/* for error checking.. quit()/exit().. etc. */
#define ERROR   -1   
#define SUCCESS  0
#define ABORT    SUCCESS /* aborts are intentional.. so its okay */

__END_DECLS

#endif /* _MACROS_H */
