#ifndef _STRUCTS_H
#define _STRUCTS_H

__BEGIN_DECLS

typedef struct code {
   char *c_name;
   int c_val;  
} Code;

/* ---------------------------------------------------- */

/* structure for all msgs.. the basic interface */
struct msg {
   int cmdlen;
   char cmdmsg[MAXSEGSIZE];
} logmsg;

/* ---------------------------------------------------- */

/* streaming server struct */
struct server {
   char *name;
   int port;
} servList[MAXSERVNUM];

/* ---------------------------------------------------- */

/* priority structure for a logmsg */
struct priority {
   int single;
   int exclude;

   int ignpri;
   int priority;
};

/* ---------------------------------------------------- */

struct log {
   int fd;
   char *filename;

   /* FIX - make facilities and priorities dynamic */

   int facility; /* the facility type */
   struct priority priority; /* priority type */

   int nsync; /* synchronize fd or not? */
} logs[MAXLOGTYPES];

/* FIX - make logs[] dynamic */

__END_DECLS

#endif /* _STRUCTS_H */
