#include "headers.h" /* has all the important stuff */

/* just called at startup to setup setjmp() */
void init()
{  
   tzset();
   /* srandom(time(NULL) + getpid()); */

   shrMemInit();

   /* just initialize stuff.. all we need to do for now is */
   /* initialize setjmp().. that's located in quit()       */ 
   dropstreamconn(INIT), quit(INIT);
}


/* -------------------------- */


void shrMemInit()
{
   int res;

   if (debugging == 1) (void)putchar('\n');

#  ifdef HAVE_SHMGET
   debug("getting the shared memory ID\n");

   shmID = shmget(IPC_PRIVATE, MAXSEGSIZE, IPC_CREAT | IPC_EXCL | 0600);
   if (shmID == ERROR)
   {
      error("error getting the ID: %s\n\n", strerror(errno));
      pinging = 0;
      return;
   }

#  else
   pinging = 0;
   return;
#  endif

#  ifdef HAVE_SHMAT
   debug("attaching the shared memory segment\n");

   segptr = shmat(shmID, 0, 0);
   if (segptr == NULL)
   {
      error("error attaching the segment: %s\n\n", strerror(errno));
      pinging = 0;
      return;
   }

#  else
   pinging = 0;
   return;
#  endif

   memset(segptr, 0, MAXSEGSIZE);

#  ifdef HAVE_SHMCTL
   debug("removing the shared memory ID\n");

   res = shmctl(shmID, IPC_RMID, 0);
   if (res == ERROR)
   {
      pinging = 0;
      error("error removing the ID: %s\n\n", strerror(errno));

      debug("now detaching the shared memory segment too\n");

      res = shmdt(segptr);
      if (res == ERROR)
         error("error detaching the segment: %s\n\n", strerror(errno));

      return;
   }

#  else
   pinging = 0;
   return;
#  endif

   if (debugging == 1) (void)putchar('\n');
}


/* ----------------------------- */


/* setup necessary files */
void setupFiles()
{
   char buf[128];
   char dblog[MAXFNAMESIZE];
   char errlog[MAXFNAMESIZE];      

   time_t tm = time(NULL);

   memset(buf, 0, sizeof(buf));
   memset(dblog, 0, sizeof(dblog));
   memset(errlog, 0, sizeof(errlog));

   /* ---------------- error log ----------------- */

   if (errorFile == NULL) (void)sprintf(errlog, "%s/%s", SRSdir, ERRLOG);
   else (void)snprintf(errlog, sizeof(errlog)-1, "%s", errorFile);

   /* -------- */

   errlogfd = open(errlog, O_WRONLY | O_CREAT | O_APPEND, 0600);
   if (errlogfd == ERROR)
   {
      (void)fprintf(stderr, "erroring opening %s: %s\n\n", errlog, 
                    strerror(errno));

      exit(ERROR);
   }

   /* -------- */

   errlogfd1 = fopen(errlog, "a+");
   if (errlogfd1 == NULL)
   {
      (void)fprintf(stderr, "erroring opening %s: %s\n\n", errlog, 
                    strerror(errno));

      exit(ERROR);
   }

   /* -------- */
   (void)chmod(errlog, S_IREAD | S_IWRITE);

   /* ---------------- debug log ----------------- */

   if (debugging == 1)
   {
      if (dbFile == NULL) 
         (void)snprintf(dblog, sizeof(dblog)-1, "%s/%s",  SRSdir, DEBLOG);

      else (void)snprintf(dblog, sizeof(errlog)-1, "%s", dbFile);

      /* -------- */

      dblogfd = open(dblog, O_WRONLY | O_CREAT | O_APPEND, 0600);
      if (dblogfd == ERROR)
      {
         (void)fprintf(stderr, "erroring opening %s: %s\n\n", dblog, 
                       strerror(errno));

         exit(ERROR);
      }

      /* -------- */

      dblogfd1 = fopen(dblog, "a+");
      if (dblogfd1 == NULL)
      {
         (void)fprintf(stderr, "erroring opening %s: %s\n\n", dblog, 
                       strerror(errno));

         exit(ERROR);
      }

      /* -------- */
      (void)chmod(dblog, S_IREAD | S_IWRITE);
   }

   /* -------------------------------------- */

   sprintf(buf, "----------------------------------------------\n\n");
   (void)write(errlogfd, buf, strlen(buf));

   if (debugging == 1) (void)write(dblogfd, buf, strlen(buf));

   memset(buf, 0, sizeof(buf));

   sprintf(buf, "SRS restarted on: %s\n", ctime(&tm));
   (void)write(errlogfd, buf, strlen(buf));

   if (debugging == 1) (void)write(dblogfd, buf, strlen(buf));

   if (debugging == 1)
   {
      (void)putchar('\n');
      (void)write(dblogfd, "\n", 1);
   }

   debug("writing debug log to %s\n", dblog);
   debug("writing error log to %s\n", errlog);
}

