/* ---- global data ----- */

#ifndef _DATA_H
#define _DATA_H

__BEGIN_DECLS

extern int mainfd;                   /* main fd to listen on... */
extern int mainpid;                  /* super-server pid        */

extern int child;                    /* is a child running?     */  

extern int locPort;                  /* local port to bind to   */

extern int nullfd;                   /* /dev/null for stdtin    */

extern int dblogfd;                  /* file to log messages to */
extern FILE *dblogfd1;

extern int errlogfd;                 /* file to write errors to */
extern FILE *errlogfd1;

extern int curlogfd;                 /* index into logs[]       */

extern char *errorFile;              /* error log file          */
extern char *servListFile;           /* ptr to servlist fname   */

extern struct sockaddr_in laddr;     /* our local addr struct.  */

extern int curPid;    /* index into pidstats[] */
extern int curClient; /* index into clients[]  */
extern struct client clients[MAXCONNS];

extern int repcount;
extern long prevlogtime;
extern char prevlogmsg[MAXLOGSIZE];

#ifndef NOSSL
extern DH *dhparms; /* holds DH parameters */
#endif

extern int prevmsg; /* previous msg type */

extern struct passwd *pwd;

extern int errors;  /* indicates an error occured */
extern int silent;  /* in silent mode.. no output */

extern volatile sig_atomic_t nofree;  /* error finding structure   */
extern volatile sig_atomic_t stopped; /* set to 1 when wecan't run */
extern volatile sig_atomic_t timeout; /* set to 1 when we timeout  */

extern volatile int debugging; /* are we in debugging mode? */

extern jmp_buf doquit, newconn; /* places to jump */

__END_DECLS

#endif /* _DATA_H */
