#ifndef _FUNCTIONS_H
#define _FUNCTIONS_H

__BEGIN_DECLS

/* fix implicit declarions */
char *inet_ntoa __P((struct in_addr in));
int gethostname  __P((char *name, size_t len));
/* ----------------------- */

/* setup/init code */
void init();           /* basic inits..            */
void shrMemInit();     /* initialize shared memory */

void setup();          /* do the general setup     */

void setupFiles();     /* setup the SRS files      */
void setupClients();   /* setup client structures  */
void setupSubIDs();    /* setup the Sub-ID's       */

void setPids(int pid); /* setup the pid's          */
/* ------------ */

/* ------ socket code ------ */
void initconn();    /* binds to the port, listens for a connection, etc. */
int getconn();      /* this accepts the connection and sets stuff up...  */

void setsockopts(); /* setup socket options */
/* ------------------------- */

/* ---- server I/O functions ---- */
/* read/write data from/to client */
void send_data __P((int fd, char *fmt, ...)); 
void recv_data __P((int fd, char *readbuf, int len, int notify));
/* ------------------------------- */

/* ------ auth functions ------ */
void authClient __P((char *str, const int len));
/* ---------------------------- */

/* configuration functions */
void readSysConf();           /* read syslog.conf from client */
void printConfig();           /* output config logs (stats)   */
/* ----------------------- */

/* ---- parsing functions ---- */
void getID    __P((char *str));       /* parse client ID   */

void parseSysConf __P((char *str));   /* parse syslog.conf */

void parseRemHost __P((char *str));   /* parse remote host */
void parseNamedPipe __P((char *str)); /* parse named pipe  */

int parseFac __P((char *str, int numfacs)); /* parse multi-facilities */
void parsePri __P((char *str));             /* parse priority for fac */

void parseFile __P((char *str, int didfacs, int numfacs, \
                    char *fac, char *pri)); /* parse file name */

void doLogging __P((char *str)); /* parse/log client's syslog msg */
/* --------------------------- */

/* conversion functions */
int priNameToVal __P((char *priority));
char *priValToName __P((int priority));

int facNameToVal __P((char *facility));
char *facValToName __P((int facility));
/* -------------------- */

/* handle client data */
void procData(int stopit); /* process data from client */

/* send stuff to the client */
void sendSubID();        /* send client its sub-ID */
void sendVers();         /* send client the current client/server ver. */
void sendServList();     /* send client the current stream server list */ 
/* ------------------ */

/* ping stuff */
void startPings();       /* fork child and start pinging          */
void sendPings();        /* send pings & get pongs to/from client */
/* ---------- */

/* SSL functions */
#ifndef NOSSL
void loadDHparams();            /* load dh parameter file */
void makeSSLconn __P((int fd)); /* init. SSL connections  */
#endif
/* ------------- */

/* misc. functions */
void usage  __P((char *progname));        /* give proper usage    */
void doArgs __P((int argc, char **argv)); /* parse and setup args */

void createDirs __P((int client));    /* creates clients' logging dirs */

void checkValid();          /* make sure structs and pids are right */
void checkValid1();         /* make sure structs and pids are right */

int  checkMaxSubIDs();      /* make sure we're not over the limit   */

void getOkay();             /* check for OKAY from client (verify)  */

void daemonize();           /* daemonize into background */

void makeHostArgs __P((int argc, char **argv)); /* put hostname in args */

char *exportInt __P((int value));   /* export int for cmd len */
int  importInt  __P((char *value)); /* import int for cmd len */

void copyLogStruct __P((int srcstruct, int dststruct)); /* copy log structs */

void getSRSuser(); /* get uid of SRS user in passwd file */
/* --------------- */

/* streaming stuff */
void initStream();     /* initialize files for streaming */
void readStream();     /* read streams from the client   */
/* --------------- */

/* sighandlers (should all be self-explanatory) */
RETSIGTYPE sighandler __P((int signum));

RETSIGTYPE IDtimeout     __P((int signum));
RETSIGTYPE authIDtimeout __P((int signum));

RETSIGTYPE InsTimeout  __P((int signum));
RETSIGTYPE okayTimeout __P((int signum));
RETSIGTYPE pingTimeout __P((int signum));

RETSIGTYPE startUp    __P((int signum));
RETSIGTYPE gotNewData __P((int signum));
/* -------------------------------------------- */

/* functions for debugging/errors */
void debug __P((char *fmt, ...));  /* func to report debugging info   */
void error __P((char *fmt, ...));  /* func to write errors to err log */
/* -------------------- */

/* functions for exiting */
void quit __P((int stat));  /* used when exiting.. to free structures */

void closeSockets();        /* close the client sockets   */
void closeLogFiles();       /* close and free log files   */

void freeClients();         /* free the client structures */
void freeSharedMem();       /* free/detach shared memory  */

void doKills();             /* kill() the child processes */
/* --------------------- */

__END_DECLS

#endif /* _FUNCTIONS_H */
