/* source system to use standard ANSI C & POSIX */
#ifndef _HEADERS_H
#define _HEADERS_H

#ifdef HAVE_CONFIG_H
#include <config.h> /* essential */
#endif

#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <stddef.h>
#include <stdarg.h>

#include <errno.h>
#include <fcntl.h>
#include <ctype.h>

#ifdef _PATH_HEQUIV
# undef _PATH_HEQUIV
#endif

#include <netdb.h>

#include <string.h>
#include <signal.h>
#include <malloc.h>

#include <pwd.h>
/* ------------------------- */

#ifdef NEED_MEMORY_H
#include <memory.h>
#endif

#ifdef HAVE_GETOPT_H
#include <getopt.h>
#endif

#include <limits.h>
#include <setjmp.h>

#ifdef SYSLOG_NAMES
# undef SYSLOG_NAMES
#endif

#include <syslog.h>

#ifdef HAVE_SYS_SHM_H
#include <sys/shm.h>
#endif

#include <sys/ipc.h>

#ifdef HAVE_SYS_SELECT_H
#include <sys/select.h>
#endif

#ifdef HAVE_POSIX_OPT_H
#include <posix_opt.h>
#endif

#ifdef _POSIX_SAVED_IDS
# undef _POSIX_SAVED_IDS
#endif

#ifdef HAVE_KVM_H
# include <kvm.h>
#endif

#ifdef HAVE_ASM_PAGE_H
# include <asm/page.h>
#endif

#ifdef HAVE_SYS_WAIT_H
# include <sys/wait.h>
#endif

#include <sys/stat.h>

#ifdef HAVE_UTIME_H
# include <utime.h>
#endif

#ifdef TIME_WITH_SYS_TIME
# include <time.h>
# include <sys/time.h>
#else
# ifdef HAVE_SYS_TIME_H
#  include <sys/time.h>
# else
#  include <time.h>
# endif
#endif

#ifdef HAVE_SYS_TIMES_H
# include <sys/times.h>
#endif

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <sys/utsname.h>

#ifdef NLIST_STRUCT
# include <nlist.h>
#endif

/* ------------------------------ */

/* not needed yet.. but might be */
#ifndef __GNUC__
#define __asm__  asm
#define __unix__ unix
#define __vax__  vax
#endif

#ifndef __unix__
#error This is for Unix-derived clients only.
#endif

#ifdef __vax__
#error This will not work on a VAX machine.
#endif

#ifndef __P
# ifdef STDC_HEADERS
#  define __P(x) x
# else
#  define __P(x) ()
# endif
#endif /* STDC_HEADERS */

/* _DECLS's */
#ifndef __cplusplus
# ifndef __BEGIN_DECLS
#  define __BEGIN_DECLS
# endif
# ifndef __END_DECLS
#  define __END_DECLS
# endif

#endif
/* -------- */

/* ------------------------------ */

/* SSL header files */
#ifndef NOSSL
# include "ssl.h"

#ifdef HAVE_DB_H
# include "db.h"
#endif

# include "err.h"
# include "pem.h"
#endif
/* ---------------- */

#include "macros.h"     /* macro definitions    */
#include "errors.h"     /* error definitions    */
#include "data.h"       /* global data declarations  */
#include "structs.h"    /* has the global structures */
#include "functions.h"  /* function declarations     */

#endif /* _HEADERS_H */
