/* ------------- our macros ------------- */

#ifndef _MACROS_H
#define _MACROS_H

__BEGIN_DECLS

/* various files/directories */
#define SERVFILE   "/etc/srs.servers"        /* where the serv list is  */

#define LOGFILE    "SRS.log"                 /* file to log sys msgs on */

#define ERRLOG     "error.log"               /* error message log file  */
#define DEBLOG     "debug.log"               /* debugging output file   */

#define USERFILE   "/etc/SRS.user"          

#define SRSDIR     "/var/log/SRS"            /* client logs are stored  */
#define CLIENTDIRS "clients"                 /* client logs are stored  */
/* ------------------------- */

/* client/server versions */
#define CVER  "1"                 /* current client version (no floats) */
#define SVER  "1"                 /* current server version (no floats) */ 
/* ---------------------- */

#define PORT 797                  /* port for clients to connect to */

/* --- standard I/O locations --- */
#define STDIN  0
#define STDOUT 1
#define STDERR 2
/* ------------------------------ */

#define INIT 100            /* used for setjmp() in quit() */

#define ALL   1000
#define NONE -1000

/* ----- syslogd stuff ----- */
#define LOG_NPRIORITIES 12

#ifndef LOG_FAC
# define LOG_FAC(p) (((p) & LOG_FACMASK) >> 2)
#endif

#ifndef LOG_PRI
# define LOG_PRI(p) ((p) & LOG_PRIMASK)
#endif

#ifndef LOG_MAKEPRI /* ifdef SUN */
# define LOG_MAKEPRI(fac, pri) (((fac) << 3) | (pri))
#endif

#ifndef INTERNAL_MARK
# define INTERNAL_MARK LOG_MAKEPRI(LOG_NFACILITIES, 0)
#endif

#ifndef INTERNAL_NOPRI
# define INTERNAL_NOPRI 0x10
#endif

#ifndef LOG_FTP
#define LOG_FTP (11 << 3)
#endif

#ifndef DEFUPRI
# ifdef SUN
#  define DEFUPRI (LOG_USER | LOG_INFO)
# else
#  define DEFUPRI (LOG_KERN | LOG_CRIT)
# endif
#endif

#ifndef DEFSPRI
# define DEFSPRI (LOG_KERN | LOG_CRIT) /* for syslogd stuff */
#endif

/* ------------------------- */

/* SSL related macros */
#define PARAMDIR "/var/log/SRS/certs"
/* ------------------ */

/* --- miscellaneous stuff --- */
#ifndef INADDR_NONE
# define INADDR_NONE ((unsigned long int) 0xffffffff)
#endif

#define REPTIME 30       /* min time between duplicate msgs   */
#define PROBETIME 60 * 5 /* time of inactivity for KEEPALIVE  */

#define NOPING 500       /* error with shmem so we can't ping */

#ifndef PAGE_SIZE
# define PAGE_SIZE 4096
#endif

#ifndef HAVE_MEMCPY
# define memcpy(d, s, n) bcopy((s), (d), (n))
#endif

#ifndef WIFEXITED
# define WIFEXITED(stat_val) (((stat_val) & 255) == 0)
#endif
/* --------------------------- */

/* --- maximum stuff --- */
#define MAXSERVNUM 32          /* max. number of servers in list    */
#define MAXCONNS   15          /* max. # of conns we can handle     */
#define MAXSUBIDS   5          /* max # of times 1 client can conn. */

#define MAXUSERNAME 8
#define MAXNUMUSERS 20

/* for all combos should be NFAC * NPRI * USERS, but that's too big */
#define MAXLOGTYPES LOG_NFACILITIES + LOG_NPRIORITIES + MAXNUMUSERS

#define MAXFNAMESIZE 256       /* max. length a filename can be */

#define MAXSEGSIZE PAGE_SIZE      /* max. size of shared mem seg */
#define MAXREADSIZE MAXSEGSIZE/2  /* maximum number of bytes at once */
#define MAXWRITESIZE MAXSEGSIZE/2 /* maximum number of bytes at once */

#define MAXLOGSIZE MAXREADSIZE    /* max. size of sys msg from client */

/* time stuff */
#define NORMPAUSE 2         /* normal amount to pause for client  */
#define MAXPAUSE  5         /* max. we'll give client to leave    */

#define MAXTIMELEN 32       /* max. time() len in characters      */
#define MAXTIMEOUT 3 * 60   /* max. time to wait for instruction  */

#define MAXFLUSHTIME 30     /* "last message repeated" after 30s  */
/* ---------- */

#define MAXNUMKIDS MAXSUBIDS /* max # of children this can contain */
/* --------------------- */

/* values for exit()/quit().. */
#define ERROR   -1               /* used in error checking */
#define SUCCESS  0               /* used in error checking and quiting */
#define ABORT    SUCCESS         /* aborts are intentional.. so okay   */
/* -------------------------- */

__END_DECLS

#endif /* _MACROS_H */
