#ifndef _STRUCTS_H
#define _STRUCTS_H

__BEGIN_DECLS

typedef struct code {
   char *c_name;
   int c_val;
} Code;

/* ----------------------------------- */

/* the basic structure for all msgs.. (used as an interface) */
struct msg {
   int cmdlen;
   char cmdmsg[MAXSEGSIZE];
};

/* ----------------------------------- */

/* priority structure for syslog msg priorities */
struct priority {
   int single;
   int exclude;

   int ignpri;
   int priority;
};

/* ----------------------------------- */

/* the basic struct for a syslog msg */
struct log {
   int fd;
   char *filename;

   int facility;
   struct priority priority;

   int nsync;
};

/* ----------------------------------- */

/* keep track of PIDs to kill then we exit.. in client structure */
struct pidstat {
   volatile sig_atomic_t pid;  /* pid of the process to kill later */
   int ppid; /* pid of our parent process..      */
   int pgid; /* pid of the process group leader  */
};

/* ----------------------------------- */

/* main structure.. for clients */
struct client {
   int ID;        /* client's ID */

   int sockfd;    /* fd we have with client  */
   int streamfd;  /* fd to streaming storage */

   char *hname; /* connection's host name */

   int pinging;   /* are we pinging? */

   /* FIX - make this dynamic...        */
   struct log logs[MAXLOGTYPES]; 

   int shmID;               /* key ID for shared memory           */

   struct msg logmsg;       /* used to receive msgs from client   */

   char *segptr;            /* pointer to malloc'd shared mem seg */
   char oldbuf[MAXSEGSIZE]; 

   struct pidstat pidstats[MAXNUMKIDS];  /* PIDs to kill later    */

#  ifndef NOSSL
   SSL *sslconn;
   SSL_CTX *sslctx;
#  endif

   /* keep track of the PIDs for all this client's connections    */
   /* [note: we don't even need these yet.. ]                     */

   volatile sig_atomic_t numSubIDs;  /* current number of sub-IDs */

   struct sockaddr_in saddr; /* source/client address */

   volatile sig_atomic_t free;    /* determine if structure is free */
   volatile sig_atomic_t running; /* indicate if we can run         */
   volatile sig_atomic_t newData; /* indicate if we have new data   */
} clients[MAXCONNS];

__END_DECLS

#endif /* _STRUCTS_H */
