#! /bin/sh
#
# This script is to setup and install SRS on your system
#
# It creates (or uses) a non-root user so that you don't risk having 
# super-user privileges abused
#
# -------------------------------------------------------

echo -e "\nSRS by RepSec, Inc. (RSI)"
echo -e "-------------------------\n"

# -------------------------------------------------------
#
# Make sure this is run as root (uid 0)

ID="`id -a | cut -d' ' -f1 | cut -d'=' -f2 | cut -d'(' -f1`"

if [ $ID != "0" ]
then
   echo "This script must be run as root"
   exit
fi

# -------------------------------------------------------
#
# Find out which non-root user to run SRS with

echo -n "Enter a non-root user for SRS to use [srs]: "
read username

if [ -z $username ] 
then
   username="srs"
   echo "Attempting to add user \"$username\" to the system..."

else
   echo -e "\nAttempting to add user \"$username\" to the system..."

fi

# -------------------------------------------------------
#
# See if the user already exists

if [ -n "`grep "^$username:" /etc/passwd`" ] 
then
   echo -e "User \"$username\" already exists.. continuing\n"

   echo "# This was generate automatically be SRS install.sh" > /etc/SRS.user
   echo -e "# Do not modify\n" >> /etc/SRS.user

   echo "$username" >> /etc/SRS.user

   if [ -d "/var/log" ]
   then
      echo "Installing SRS certificates into /var/log/SRS/certs"
      mkdir /var/log/SRS 2>/dev/null
      mkdir /var/log/SRS/certs 2>/dev/null
      rm -f /var/log/SRS/certs/* 2>/dev/null

      cp -f certs/* /var/log/SRS/certs
      cp -f ../certs/* /var/log/SRS/certs

   elif [ -d "/var/adm" ]
   then
      echo "Installing SRS certificates into /var/adm/SRS/certs"
      mkdir /var/adm/SRS 2>/dev/null
      mkdir /var/adm/SRS/certs 2>/dev/null
      rm -f /var/adm/SRS/certs/* 2>/dev/null

      cp -f certs/* /var/adm/SRS/certs
      cp -f ../certs/* /var/adm/SRS/certs

   elif [ -d "/usr/adm" ]
   then
      echo "Installing SRS certificates into /usr/adm/SRS/certs"
      mkdir /usr/adm/SRS 2>/dev/null
      mkdir /usr/adm/SRS/certs 2>/dev/null
      rm -f /usr/adm/SRS/certs/* 2>/dev/null

      cp -f certs/* /usr/adm/SRS/certs
      cp -f ../certs/* /usr/adm/SRS/certs

   fi

   make install

   echo -ne "\nSRS setup is now complete. "
   echo -e "Please type 'make install' and read SRS docs.\n"

   exit

fi

# -------------------------------------------------------
#
# Create the user using "useradd" or "adduser" depending on your system

if [ -f "/etc/shadow" ]
then
   addcmd="usersadd"
   addcmd1="adduser"

else
   addcmd="adduser"
   addcmd1="useradd"

fi

if [ "`which $addcmd | cut -c1-9`" != "which: no" ]
then
   echo -e "Attempting to add the user with the '$addcmd' command.\n"
   `which $addcmd` "$username"

elif [ "`which $addcmd1 | cut -c1-9`" != "which: no" ]
then
   echo -e "Attempting to add the user with the '$addcmd1' command.\n"
   `which $addcmd1` "$username"

else
   echo -e "\nNo commands to add users were found."
   echo -e "Please add user \"$username\" to the system manually" \
           "and then re-run this script.\n"

   exit

fi

# -------------------------------------------------------
#
# SRS binary will check this file to find out which non-root user to use

echo    "# This was generate automatically be SRS install.sh" > /etc/SRS.user
echo -e "# Do not modify\n" >> /etc/SRS.user

echo "$username" >> /etc/SRS.user

if [ -d "/var/log" ]
then
   echo "Installing SRS certificates into /var/log/SRS/certs"
   mkdir /var/log/SRS 2>/dev/null
   mkdir /var/log/SRS/certs 2>/dev/null
   rm -f /var/log/SRS/certs/* 2>/dev/null

   cp -f certs/* /var/log/SRS/certs 2>/dev/null
   cp -f ../certs/* /var/log/SRS/certs 2>/dev/null

elif [ -d "/var/adm" ]
then
   echo "Installing SRS certificates into /var/adm/SRS/certs"
   mkdir /var/adm/SRS 2>/dev/null
   mkdir /var/adm/SRS/certs 2>/dev/null
   rm -f /var/adm/SRS/certs/* 2>/dev/null

   cp -f certs/* /var/adm/SRS/certs
   cp -f ../certs/* /var/adm/SRS/certs

elif [ -d "/usr/adm" ]
then
   echo "Installing SRS certificates into /usr/adm/SRS/certs"
   mkdir /usr/adm/SRS 2>/dev/null
   mkdir /usr/adm/SRS/certs 2>/dev/null
   rm -f /usr/adm/SRS/certs/* 2>/dev/null

   cp -f certs/* /usr/adm/SRS/certs
   cp -f ../certs/* /usr/adm/SRS/certs

fi

make install
echo -e "\nSRS setup is now complete. Please read SRS.doc.\n"

exit
