/* This has functions to read the configuration file */
/* ------------------------------------------------- */

#include "headers.h" /* has all important stuff */

/* reads client's syslog.conf */
void readSysConf()
{
   int res;
   register int i;
   char readbuf[MAXREADSIZE/4];

   if (curlogfd > 0)
   {
      if (debugging == 1) 
      {
         (void)putchar('\n');
         (void)write(dblogfd, "\n", 1);
      }

      debug("re-HUPing client's config file..\n\n");

      for (i = 0; i <= curlogfd; i++)
      {
         if ((clients[curClient].logs[i].fd <= 0) &&
             (clients[curClient].logs[i].filename == NULL)) continue;

         else
         {
            if (clients[curClient].logs[i].fd > 0) 
               close(clients[curClient].logs[i].fd); 

            if (clients[curClient].logs[i].filename != NULL)
               free(clients[curClient].logs[i].filename);

            memset(&clients[curClient].logs[i], 0, sizeof(struct log));

            clients[curClient].logs[i].fd = ERROR;
            clients[curClient].logs[i].filename = NULL;
         }
      }
   }

   /* inform client we're ready */
   send_data(clients[curClient].sockfd, "START SYSLOG.CONF OKAY\n");

   debug("----- BEGIN PARSE SYSLOG.CONF -----\n\n");

   curlogfd = ERROR;

   res = seteuid(0);
   if (res == ERROR) 
   {
      error("error with seteuid: %s\n\n", strerror(errno));
      quit(ERROR);
   }

   while(1) 
   {      
      memset(readbuf, 0, sizeof(readbuf));
      recv_data(clients[curClient].sockfd, readbuf, sizeof(readbuf)-1, 0);

      if (isprint(readbuf[0]) == 0) continue;
      else if (strncmp(readbuf, "END SYSLOG.CONF", 15) == 0) break;
      else
      {
         debug("parsing line:\n%s\n", readbuf);

         if (strchr(readbuf, '\n') == NULL) 
         {
            debug("no newline in message.. adding one\n");
            readbuf[sizeof(readbuf)-2] = '\n';
            readbuf[sizeof(readbuf)-1] = '\0';
         }

         else
         {
            char *dataptr = readbuf;
            char *dataptr1 = dataptr;

            while(1)
            {
               dataptr = dataptr1;

               if (isprint((*(strchr(dataptr, '\n') + 1))) != 0)
               {
                  debug("possibly several commands in one line\n");
                  dataptr1 = strchr(dataptr, '\n');

                  dataptr1 += 1, parseSysConf(dataptr1);               
               }

               else break;
            }
         }

         parseSysConf(readbuf);          
      }
   }

   res = seteuid(pwd->pw_uid);
   if (res == ERROR) 
   {
      error("error with seteuid: %s\n\n", strerror(errno));
      quit(ERROR);
   }

   debug("----- END PARSE SYSLOG.CONF -----\n\n");

   send_data(clients[curClient].sockfd, "SUCCESSFUL logging\n");
   printConfig();
}


/* ------------------------------- */


/* output what's being logged to where */
void printConfig()
{
   register int i;

   for (i = 0; i <= curlogfd; i++)
   {
       if ((clients[curClient].logs[i].filename == NULL) || 
           (clients[curClient].logs[i].fd <= 0)) continue;

       if ((clients[curClient].logs[i].facility != ALL)  && 
           (clients[curClient].logs[i].priority.priority != ALL) &&
           (clients[curClient].logs[i].priority.priority != NONE))
       {
          debug("%s, for %s.%s\n", clients[curClient].logs[i].filename, 
                facValToName(clients[curClient].logs[i].facility),
                priValToName(clients[curClient].logs[i].priority.priority));
       }
 
       else
       {
          if (clients[curClient].logs[i].facility == ALL)
          {
             if (clients[curClient].logs[i].priority.priority == ALL)
                debug("%s, for *.*\n", clients[curClient].logs[i].filename);

             else if (clients[curClient].logs[i].priority.priority == NONE)
                debug("%s, for *.none\n", clients[curClient].logs[i].filename);

             else
                debug("%s, for *.%s\n", clients[curClient].logs[i].filename, 
                   priValToName(clients[curClient].logs[i].priority.priority));
          }

          else if (clients[curClient].logs[i].priority.priority == ALL)
             debug("%s for %s.*\n", clients[curClient].logs[i].filename, 
                   facValToName(clients[curClient].logs[i].facility));

          else if (clients[curClient].logs[i].priority.priority == NONE)
             debug("%s, for %s.none\n", clients[curClient].logs[i].filename, 
                   facValToName(clients[curClient].logs[i].facility));

       }
   }

   if (debugging == 1)
   {
      (void)putchar('\n');
      (void)write(dblogfd, "\n", 1);
   }
}
