#include "headers.h"

/* functions to conver priority/facility names/values */
/* -------------------------------------------------- */

#include "facilities.h"
#include "priorities.h"

/* convert a priority name into a priority value */
int priNameToVal(char *priority)
{
   register int i;

   for (i = 0; prioritynames[i].c_name != NULL; i++)
   {
      if (priority == NULL) break;

      /* debug("comparing %s to %s\n", priority, prioritynames[i].c_name); */
      else if (strcmp(priority, prioritynames[i].c_name) == 0)
         return prioritynames[i].c_val;
   }

   debug("priority = %d\n", ERROR);
   return ERROR;
}


/* --------------------------- */


/* convert a priority value into a priority name */
char *priValToName(int priority)
{
   register int i;

   if (abs(priority) == ALL)
   {
      if (priority == ALL) return "all";
      else return "none";
   }

   for (i = 0; prioritynames[i].c_name != NULL; i++)
      if (prioritynames[i].c_val == LOG_PRI(priority))
         return prioritynames[i].c_name;

   debug("priority = unknown\n");
   return "unknown";
}


/* --------------------------- */


/* convert a facility name into a facility value */
int facNameToVal(char *facility)
{
   register int i;

   for (i = 0; facilitynames[i].c_name != NULL; i++)
   {
      if (facility == NULL) break;
      else if (strcmp(facility, facilitynames[i].c_name) == 0)
         return facilitynames[i].c_val;
   }

   debug("facility = %d\n", ERROR);
   return ERROR;
}


/* --------------------------- */


/* convert a facility value into a facility name */
char *facValToName(int facility)
{
   register int i;

   if (facility == ALL)
      return "all";

   for (i = 0; facilitynames[i].c_name != NULL; i++)
      if (facilitynames[i].c_val == facility)
         return facilitynames[i].c_name;

   for (i = 0; facilitynames[i].c_name != NULL; i++)
      if (facilitynames[i].c_val == (facility << 3))
         return facilitynames[i].c_name;

   return "unknown";
}
/* -------------------------------------------------- */
