#include "headers.h" /* has all important stuff */

/* this file does the authentication stuff */

/* read data from SYSLOGFILE.. and send it to server */
void readStream()
{
   int count = 0;         /* prevent overflows */

   char newmsg[MAXLOGSIZE];
   char logmsg[MAXLOGSIZE];
   char rawmsg[MAXLOGSIZE];

   char readbuf[MAXREADSIZE];
   char *dataptr, *logptr, *newptr, *rawptr;  

   debug("(in readStream) waiting for client's logs..\n\n");


   while(1)
   {
      logptr = logmsg, rawptr = rawmsg, newptr = newmsg;

      memset(logmsg,  0, sizeof(logmsg));
      memset(newmsg,  0, sizeof(newmsg));
      memset(rawmsg,  0, sizeof(rawmsg));

      while(1)
      {
         memset(readbuf, 0, sizeof(readbuf));

         recv_data((clients[curClient]).sockfd, readbuf, 
                   sizeof(readbuf)-1, (child == 1 ? 1 : 0));

         if (debugging == 1)
         {
            (void)putchar('\n');
            (void)write(dblogfd, "\n", 1);
         }

         if (strlen(readbuf) <= 17)
            debug("(in readStream).. the data is: %s%c", readbuf,
                  (strchr(readbuf, '\n') == NULL ? '\n' : '\0'));

         else
            debug("(in readStream).. the data is:\n%s%c", readbuf,
                  (strchr(readbuf, '\n') == NULL ? '\n' : '\0'));

         /* check for the possible cmds we could get in this state */
         if (strncmp(readbuf, "END STREAM", 10) == 0) 
         {
            error("got request to stop streaming from client\n\n");
            return;
         }

         else if (strncmp(readbuf, "STREAM : ", 9) == 0) break;
         else if (strncmp(readbuf, "START SYSLOG.CONF", 17) == 0)
                 readSysConf(); 

         else if (strncmp(readbuf, "START PINGS", 10) == 0) startPings();
         else if (strncmp(readbuf, "PONG", 4) == 0) continue;
         else if (strncmp(readbuf, "PING CHECK", 10) == 0) continue;
         else
         {
            error("unknown message from client:\n%s\n%c", readbuf,
                  (strchr(readbuf, '\n') == NULL ? '\n' : '\0'));

            continue;
         }
      }

      /* parse it to get time value.. */
      dataptr = strstr(readbuf, "STREAM :");
      dataptr += 9; /* skip the "STREAM : " */

      count = 0;
      while ((*dataptr) && (isprint(*dataptr) != 0) && 
            (count < (int)sizeof(logmsg)))
      {
         *logptr++ = *dataptr++;
         count++;
      }

      /* -------------------------------- */

      count = 0;
      dataptr = logmsg, dataptr += 20;

      while((*dataptr) && (isprint(*dataptr) != 0) &&
            (count < (int)sizeof(rawmsg)))
      {
         *rawptr++ = *dataptr++;
         count++;
      }

      if (isprint(prevlogmsg[0]) == 0)
      {
         memset(prevlogmsg, 0, sizeof(prevlogmsg));
         (void)strncpy(prevlogmsg, rawmsg, sizeof(prevlogmsg)-1);

         prevlogtime = time(NULL);

         doLogging(logmsg);         
      }

      else if (strncmp(rawmsg, prevlogmsg, strlen(prevlogmsg)) == 0)
      {
         if ((time(NULL) - prevlogtime) >= REPTIME)
         {
            char repmsg[MAXLOGSIZE - 20];

            memset(repmsg, 0, sizeof(repmsg));

            if (repcount == 1)
               sprintf(repmsg, " last message repeated %d time\n", repcount);

            else
               sprintf(repmsg, " last message repeated %d times\n", repcount);
 
            repcount = 0;
            prevlogtime = time(NULL);

            count = 0;
            newptr = newmsg, dataptr = logmsg;

            while((*dataptr) && (isprint(*dataptr) != 0) &&
                  (count < (int)sizeof(newmsg)) && (count < 19))
            {
               *newptr++ = *dataptr++;
               count++;
            }

            strncat(newmsg, repmsg, sizeof(newmsg) - strlen(newmsg) - 1);

            debug("newmsg = %s\n", newmsg); 
            doLogging(newmsg);
         }

         else
         {
            debug("last message repeated..\n\n");
            repcount++;
         }
      }

      else
      {
         prevlogtime = time(NULL);
         strncpy(prevlogmsg, rawmsg, sizeof(prevlogmsg)-1);
         doLogging(logmsg);           /* parse system log message */
      }
   }

   return;
}
